# 機能設計書 5-TimeZone

## 概要

本ドキュメントは、VBCorLibライブラリにおけるタイムゾーン機能（TimeZone）の設計を記述する。TimeZoneクラスは、.NET Frameworkの`System.TimeZone`クラスに相当するタイムゾーン情報の取得とUTC/ローカル時間変換機能を提供するクラスである。

### 本機能の処理概要

TimeZoneクラスは、現在のシステムのタイムゾーン情報を取得し、UTC時間とローカル時間の相互変換、夏時間（サマータイム）の判定を行う機能を提供する。

**業務上の目的・背景**：グローバルなビジネスアプリケーションでは、異なるタイムゾーン間での時刻変換が必要となる。TimeZoneは現在のシステムのタイムゾーン設定に基づいて、UTC時間とローカル時間の変換、夏時間期間の判定を行うことで、時刻の正確な管理を可能にする。

**機能の利用シーン**：タイムゾーン変換を必要とする場面で利用される。具体的には、国際間取引でのタイムスタンプ管理、ログファイルの時刻統一、スケジュール管理システムでの時差対応、データベースの時刻フィールドの変換などの場面で活用される。

**主要な処理内容**：
1. タイムゾーン名の取得（DaylightName、StandardName）
2. 夏時間期間の取得（GetDayLightChanges）
3. UTCオフセットの取得（GetUtcOffset）
4. 夏時間判定（IsDaylightSavingTime）
5. ローカル時間への変換（ToLocalTime）
6. UTC時間への変換（ToUniversalTime）

**関連システム・外部連携**：Windows APIの`GetTimeZoneInformation`を使用してシステムのタイムゾーン情報を取得する。CorDateTimeクラスと連携して時刻変換を行う。

**権限による制御**：権限による制御は行わない。全てのメソッドは同一の動作を行う。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラスである |

## 機能種別

計算処理 / データ操作ユーティリティ / タイムゾーン処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Time | Variant | Yes | 変換対象の時刻（CorDateTime/Date） | なし |
| Year | Long | Yes | 夏時間期間を取得する年 | なし |

### 入力データソース

システムのタイムゾーン設定（Windows API経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タイムゾーン名 | String | DaylightName、StandardNameプロパティ戻り値 |
| 夏時間期間 | DayLightTime | GetDayLightChangesの戻り値 |
| UTCオフセット | TimeSpan | GetUtcOffsetの戻り値 |
| 夏時間判定 | Boolean | IsDaylightSavingTimeの戻り値 |
| ローカル時間 | CorDateTime | ToLocalTimeの戻り値 |
| UTC時間 | CorDateTime | ToUniversalTimeの戻り値 |

### 出力先

呼び出し元への戻り値

## 処理フロー

### 処理シーケンス

```
1. クラス初期化
   └─ GetTimeZoneInformation APIでタイムゾーン情報を取得
   └─ 夏時間名、標準時間名、UTCオフセットを設定
2. 夏時間判定
   └─ 年から夏時間期間を算出
   └─ 対象時刻が期間内かを判定
3. 時刻変換
   └─ UTCオフセットを加算/減算
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|夏時間判定| C[GetDaylightTimes]
    B -->|時刻変換| D{変換方向}
    C --> E[期間内判定]
    D -->|ToLocalTime| F[オフセット加算]
    D -->|ToUniversalTime| G[オフセット減算]
    E --> H[Boolean返却]
    F --> I[CorDateTime返却]
    G --> I
    H --> J[終了]
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | システム依存 | タイムゾーン情報はシステム設定に依存 | クラス初期化時 |
| BR-02 | 夏時間対応 | UTCオフセットは夏時間を考慮して返す | GetUtcOffset |
| BR-03 | Kind保持 | ToLocalTimeはLocalKind、ToUniversalTimeはUtcKindを設定 | 時刻変換 |

### 計算ロジック

**UTCオフセットの算出**
- 標準時: -(Bias + StandardBias) 分
- 夏時間: -(Bias + DaylightBias) 分

**夏時間開始/終了日の算出**
- wDay=5の場合: 月の最終週の指定曜日
- wDay=1-4の場合: 月の第n週の指定曜日

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 通常エラーは発生しない | - |

## 備考

- Windows APIのTIME_ZONE_INFORMATION構造体を使用
- 夏時間が使用されないタイムゾーンではDayLightTimeがMinValueで初期化される
- IObjectインターフェースを実装

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TimeZone.cls | `Source/CorLib/System/TimeZone.cls` | 46-54行目: 内部変数定義 |
| 1-2 | TimeZone.cls | `Source/CorLib/System/TimeZone.cls` | 171-184行目: Class_Initialize - API呼び出し |
| 1-3 | TimeZone.cls | `Source/CorLib/System/TimeZone.cls` | 86-92行目: GetUtcOffset |
| 1-4 | TimeZone.cls | `Source/CorLib/System/TimeZone.cls` | 99-105行目: IsDaylightSavingTime |
| 1-5 | TimeZone.cls | `Source/CorLib/System/TimeZone.cls` | 112-122行目: ToLocalTime |
| 1-6 | TimeZone.cls | `Source/CorLib/System/TimeZone.cls` | 129-139行目: ToUniversalTime |
| 1-7 | TimeZone.cls | `Source/CorLib/System/TimeZone.cls` | 190-237行目: 夏時間切り替え日算出 |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TimeZone.cls | `Source/CorLib/System/TimeZone.cls` | ソース | タイムゾーンのメインクラス |
| TimeZoneStatic.cls | `Source/CorLib/System/TimeZoneStatic.cls` | ソース | タイムゾーンの静的メソッド |
| DayLightTime.cls | `Source/CorLib/System.Globalization/DayLightTime.cls` | ソース | 夏時間期間を表すクラス |
| CorDateTime.cls | `Source/CorLib/System/CorDateTime.cls` | ソース | 日付時刻クラス |
