# 機能設計書 50-DESCryptoServiceProvider

## 概要

本ドキュメントは、VBCorLibライブラリにおけるDES対称暗号化機能「DESCryptoServiceProvider」クラスの機能設計について記述する。

### 本機能の処理概要

DESCryptoServiceProviderクラスは、Windows CryptoAPIを利用したDES（Data Encryption Standard）対称ブロック暗号アルゴリズムのラッパークラスである。DESは64ビットのブロックサイズと64ビットの鍵サイズ（実効56ビット）を使用する古典的な暗号アルゴリズムであり、レガシーシステムとの互換性維持のために提供される。

**業務上の目的・背景**：レガシーシステムとの暗号化データ互換性の維持、既存のDES暗号化データの復号化、古いプロトコルやファイルフォーマットとの相互運用性の確保。

**機能の利用シーン**：
- レガシーシステムとの暗号化データ交換
- 古いDES暗号化ファイルの復号化
- 既存システムとの互換性維持
- 歴史的な暗号化データのマイグレーション

**主要な処理内容**：
1. 暗号化/復号化トランスフォーマの生成（CreateEncryptor/CreateDecryptor）
2. Windows CryptoAPIを使用した暗号化/復号化
3. 弱い鍵/準弱い鍵の検出と拒否
4. 暗号モード（CBC/ECB/CFB）の設定
5. パディングモードの設定

**関連システム・外部連携**：Windows CryptoAPIに依存、ICryptoTransformインターフェースを通じてCryptoStreamと連携。

**権限による制御**：本機能には権限による制御は存在しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面からの直接操作を持たない |

## 機能種別

データ変換処理 / 暗号化機能

## 入力仕様

### アルゴリズムパラメータ

| パラメータ名 | 型 | 必須 | 説明 | デフォルト値 |
|-------------|-----|-----|------|-------------|
| BlockSize | Long | No | ブロックサイズ（ビット） | 64（固定） |
| KeySize | Long | No | キーサイズ（ビット） | 64（固定） |
| Key | Byte() | No | 秘密鍵（未指定時は自動生成） | 自動生成 |
| IV | Byte() | No | 初期化ベクトル（未指定時は自動生成） | 自動生成 |
| Mode | CipherMode | No | 暗号モード | CBC |
| Padding | PaddingMode | No | パディングモード | PKCS7 |
| FeedbackSize | Long | No | フィードバックサイズ（ビット） | 8 |

### CreateEncryptor/CreateDecryptorパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|-----|------|
| RgbKey | Variant(Byte()) | No | 暗号化/復号化に使用する秘密鍵 |
| RgbIV | Variant(Byte()) | No | 暗号化/復号化に使用するIV |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CreateEncryptor戻り値 | ICryptoTransform | 暗号化トランスフォーマ（CryptoAPITransform） |
| CreateDecryptor戻り値 | ICryptoTransform | 復号化トランスフォーマ（CryptoAPITransform） |
| Key | Byte() | 現在の秘密鍵（未設定時は自動生成） |
| IV | Byte() | 現在のIV（未設定時は自動生成） |
| LegalBlockSizes | KeySizes() | 有効なブロックサイズ一覧（64ビットのみ） |
| LegalKeySizes | KeySizes() | 有効なキーサイズ一覧（64ビットのみ） |

### サポートする暗号パラメータ

```
ブロックサイズ: 64 ビット（固定）
キーサイズ: 64 ビット（固定、実効56ビット）

暗号モード:
  - CBC (Cipher Block Chaining) - デフォルト
  - ECB (Electronic Codebook)
  - CFB (Cipher Feedback) - FeedbackSize=8のみ
  ※ OFBはサポートしない

パディングモード:
  - PKCS7 - デフォルト
  - None
  - Zeros
  - ANSIX923
  - ISO10126
```

## 処理フロー

### 処理シーケンス

```
1. インスタンス生成
   └─ CryptoAPIでDESサポート確認
   └─ SymmetricAlgorithmBase初期化
   └─ LegalBlockSize/LegalKeySize設定（64ビット固定）
   └─ デフォルト値設定（Mode=CBC, Padding=PKCS7）
2. パラメータ設定（オプション）
   └─ Mode/Padding設定
   └─ Key/IV設定（省略時は自動生成）
   └─ 弱い鍵チェック（CheckForWeakKeyイベント）
3. トランスフォーマ生成
   ├─ CreateEncryptor: 暗号化用トランスフォーマ
   └─ CreateDecryptor: 復号化用トランスフォーマ
4. CryptoAPITransform.Init
   └─ CryptoAPI鍵インポート
   └─ 暗号モード/フィードバックサイズ設定
   └─ IV設定
5. データ変換
   └─ TransformBlock: CryptEncrypt/CryptDecrypt呼び出し
   └─ TransformFinalBlock: 最終ブロックの変換（パディング処理）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{CryptoAPIサポート確認}
    B -->|未サポート| C[例外スロー]
    B -->|サポート| D[DESCryptoServiceProvider生成]
    D --> E{パラメータ設定}
    E --> F[Mode/Padding設定]
    E --> G[Key/IV設定]
    G --> H{弱い鍵チェック}
    H -->|弱い鍵| I[例外スロー]
    H -->|準弱い鍵| J[例外スロー]
    H -->|OK| K{トランスフォーマ生成}
    F --> K
    K -->|暗号化| L[CreateEncryptor]
    K -->|復号化| M[CreateDecryptor]
    L --> N[CryptoAPITransform.Init]
    M --> N
    N --> O[CryptoAPI鍵インポート]
    O --> P[暗号パラメータ設定]
    P --> Q{暗号モード}
    Q -->|ECB| R[ECB処理]
    Q -->|CBC| S[CBC処理]
    Q -->|CFB| T{FeedbackSize=8?}
    T -->|No| U[例外スロー]
    T -->|Yes| V[CFB処理]
    R --> W[CryptEncrypt/CryptDecrypt]
    S --> W
    V --> W
    W --> X{全ブロック完了?}
    X -->|No| W
    X -->|Yes| Y[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 固定ブロックサイズ | ブロックサイズは64ビット固定 | 常時 |
| BR-002 | 固定キーサイズ | キーサイズは64ビット固定（実効56ビット） | 常時 |
| BR-003 | 弱い鍵拒否 | DESの弱い鍵（Weak Key）は拒否 | 鍵設定時 |
| BR-004 | 準弱い鍵拒否 | DESの準弱い鍵（Semi-Weak Key）は拒否 | 鍵設定時 |
| BR-005 | CFBフィードバック制限 | CFBモードはFeedbackSize=8のみサポート | CFBモード時 |
| BR-006 | OFBモード非サポート | OFBモードは例外をスロー | OFBモード使用時 |
| BR-007 | CryptoAPI必須 | Windows CryptoAPIでDESがサポートされている必要がある | 初期化時 |

### DES弱い鍵

```
弱い鍵（4種類）:
  0101010101010101
  FEFEFEFEFEFEFEFE
  E0E0E0E0F1F1F1F1
  1F1F1F1F0E0E0E0E

準弱い鍵（12種類）:
  01FE01FE01FE01FE, FE01FE01FE01FE01
  1FE01FE00EF10EF1, E01FE01FF10EF10E
  01E001E001F101F1, E001E001F101F101
  1FFE1FFE0EFE0EFE, FE1FFE1FFE0EFE0E
  011F011F010E010E, 1F011F010E010E01
  E0FEE0FEF1FEF1FE, FEE0FEE0FEF1FEF1
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CryptographicException | CryptoAPIでDES未サポート | DESサポート環境で実行 |
| - | CryptographicException | 弱い鍵を指定 | 異なる鍵を使用 |
| - | CryptographicException | 準弱い鍵を指定 | 異なる鍵を使用 |
| - | CryptographicException | OFBモードを指定 | CBC/ECB/CFBを使用 |
| - | CryptographicException | CFBでFeedbackSize!=8 | FeedbackSize=8を使用 |
| - | CryptographicException | 暗号化/復号化失敗 | 正しいキー/IVを使用 |
| - | ArgumentException | RgbKeyのみまたはRgbIVのみ指定（ECB以外） | 両方または両方とも省略 |
| - | ArgumentException | 無効なIVサイズ | 8バイトのIVを指定 |
| - | ArgumentException | 無効なキーサイズ | 8バイトのキーを指定 |

### リトライ仕様

暗号化/復号化処理であるため、リトライは不要。

## トランザクション仕様

本機能はトランザクション処理を行わない。

## パフォーマンス要件

- Windows CryptoAPIを使用するため高速
- ハードウェアアクセラレーションが利用可能な環境ではさらに高速
- 1MBデータの暗号化: 数ミリ秒〜数十ミリ秒程度

## セキュリティ考慮事項

- **重要**: DESは現代の基準では安全ではない（56ビット鍵は総当たり攻撃に脆弱）
- 新規開発ではAES（RijndaelManaged）の使用を強く推奨
- レガシーシステム互換性のためにのみ使用すべき
- キーと IVは使用後にClearメソッドで消去することを推奨
- ECBモードは同一平文ブロックが同一暗号文になるため、CBCの使用を推奨
- 弱い鍵/準弱い鍵は自動的に拒否される

## 備考

- .NET FrameworkのDESCryptoServiceProviderと高い互換性を持つ
- 内部でWindows CryptoAPIを使用
- DESはFIPS 46-3で定義された暗号アルゴリズム
- 2005年にNISTはDESの使用を非推奨とした

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造とクラス定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DESCryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` | クラス定義、定数（49-54行目） |

**読解のコツ**:
- 49行目: LegalBlockSize定数（64ビット固定）
- 50行目: LegalKeySize定数（64ビット固定）
- 51行目: DefaultFeedbackSize定数（8ビット）
- 53行目: mBase変数（SymmetricAlgorithmBase）、WithEventsで弱い鍵チェックイベント受信

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DESCryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` | 公開メソッド/プロパティ |

**主要処理フロー**:
1. **63-75行目**: BlockSizeプロパティ - ブロックサイズ取得/設定
2. **110-122行目**: KeySizeプロパティ - キーサイズ取得/設定
3. **138-149行目**: Modeプロパティ - 暗号モード取得/設定
4. **156-167行目**: Paddingプロパティ - パディングモード取得/設定
5. **175-187行目**: Keyプロパティ - 秘密鍵取得/設定
6. **202-214行目**: IVプロパティ - IV取得/設定
7. **250-252行目**: CreateEncryptor - 暗号化トランスフォーマ生成
8. **263-265行目**: CreateDecryptor - 復号化トランスフォーマ生成

#### Step 3: CryptoAPI連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DESCryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` | CreateCipher（306-320行目） |
| 3-2 | CryptoAPITransform.cls | `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` | Init（204-233行目） |

**主要処理フロー**:
- 306-320行目: CreateCipher - パラメータ検証、CryptoAPITransform生成
- 315-316行目: CFBモードでFeedbackSize!=8の場合例外
- 326-340行目: Class_Initialize - CryptoAPIサポート確認、パラメータ初期化

#### Step 4: 弱い鍵チェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DESCryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` | mBase_CheckForWeakKey（466-474行目） |

**主要処理フロー**:
- 466-474行目: CheckForWeakKeyイベントハンドラ
- DESStatic.IsWeakKey/IsSemiWeakKeyで鍵を検証
- 弱い鍵または準弱い鍵の場合、CryptographicExceptionを設定

#### Step 5: 暗号化/復号化処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | CryptoAPITransform.cls | `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` | TransformBlock/TransformFinalBlock |

**主要処理フロー**:
- **132-146行目**: TransformBlock - ブロック変換
- **156-164行目**: TransformFinalBlock - 最終ブロック変換
- **248-296行目**: EncryptFinalBlock - 暗号化最終処理
- **298-307行目**: EncryptBlock - ブロック暗号化（CryptEncrypt呼び出し）
- **355-419行目**: DecryptFinalBlock - 復号化最終処理
- **313-353行目**: DecryptBlock - ブロック復号化（CryptDecrypt呼び出し）

### プログラム呼び出し階層図

```
DESCryptoServiceProvider
    │
    ├─ Class_Initialize()
    │      └─ CryptoAPI.SupportsAlgorithm(): DESサポート確認
    │             └─ 未サポート時は例外
    │
    ├─ CreateEncryptor(RgbKey, RgbIV)
    │      └─ CreateCipher(RgbKey, RgbIV, True)
    │             ├─ パラメータ検証（CFB FeedbackSize）
    │             └─ CryptoAPITransform.Init()
    │                    ├─ CryptoAPI.ImportPlainTextKey(): 鍵インポート
    │                    ├─ CryptoAPI.SetKeyParam(): モード設定
    │                    └─ CryptoAPI.SetKeyParam(): IV設定
    │
    ├─ CreateDecryptor(RgbKey, RgbIV)
    │      └─ CreateCipher(RgbKey, RgbIV, False)
    │
    ├─ mBase_CheckForWeakKey(RgbKey, Ex)
    │      ├─ DESStatic.IsWeakKey(): 弱い鍵チェック
    │      └─ DESStatic.IsSemiWeakKey(): 準弱い鍵チェック
    │
    └─ SymmetricAlgorithmBase (mBase)
           ├─ GetKey(): 鍵取得（未設定時はGenerateKey）
           ├─ SetKey(): 鍵設定（CheckForWeakKeyイベント発火）
           ├─ GenerateKey(): ランダム鍵生成（弱い鍵は再生成）
           └─ GenerateIV(): ランダムIV生成

CryptoAPITransform
    │
    ├─ TransformBlock(InputBuffer, InputOffset, InputCount, OutputBuffer, OutputOffset)
    │      ├─ EncryptBlock(): CryptEncrypt呼び出し
    │      └─ DecryptBlock(): CryptDecrypt呼び出し
    │
    └─ TransformFinalBlock(InputBuffer, InputOffset, InputCount)
           ├─ EncryptFinalBlock(): パディング追加 + CryptEncrypt
           ├─ DecryptFinalBlock(): CryptDecrypt + パディング除去
           └─ Reset(): 状態リセット
```

### データフロー図

```
[入力]                    [処理]                         [出力]

平文データ ─────────────▶ CreateEncryptor ─────────────▶ ICryptoTransform
  │                           │
  │                           └─ Init()
  │                                 ├─ CryptoAPI鍵インポート
  │                                 └─ モード/IV設定
  │
  └───────────────────────▶ TransformBlock ────────────▶ 暗号化データ
                               │
                               └─ CryptEncrypt()
                                      (Windows CryptoAPI)

暗号化データ ────────────▶ CreateDecryptor ─────────────▶ ICryptoTransform
  │                           │
  │                           └─ Init()
  │
  └───────────────────────▶ TransformBlock ────────────▶ 平文データ
                               │
                               └─ CryptDecrypt()
                                      (Windows CryptoAPI)

鍵設定 ──────────────────▶ SetKey ──────────────────────▶ 検証結果
  │                           │
  └─ CheckForWeakKey          ├─ IsWeakKey()
                              └─ IsSemiWeakKey()
                                     │
                                     └─ 弱い鍵は例外
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DESCryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` | ソース | メインクラス定義（579行） |
| CryptoAPITransform.cls | `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` | ソース | CryptoAPIラッパートランスフォーマ（464行） |
| SymmetricAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithmBase.cls` | ソース | 対称暗号基底クラス（470行） |
| DES.cls | `Source/CorLib/System.Security.Cryptography/DES.cls` | インターフェース | DESインターフェース |
| DESStatic.cls | `Source/CorLib/System.Security.Cryptography/DESStatic.cls` | ソース | 弱い鍵チェック（IsWeakKey/IsSemiWeakKey） |
| SymmetricAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithm.cls` | インターフェース | 対称暗号インターフェース |
| ICryptoTransform.cls | `Source/CorLib/System.Security.Cryptography/ICryptoTransform.cls` | インターフェース | 暗号変換インターフェース |
| CryptoAPI.bas | `Source/CorLib/System.Security.Cryptography/CryptoAPI.bas` | モジュール | Windows CryptoAPI呼び出し |
| CryptoHelper.bas | `Source/CorLib/System.Security.Cryptography/CryptoHelper.bas` | モジュール | パディング処理、乱数生成 |
