# 機能設計書 51-TripleDESCryptoServiceProvider

## 概要

本ドキュメントは、VBCorLibライブラリにおけるTripleDESCryptoServiceProvider機能の設計仕様を記載する。本クラスはTriple DES（3DES）対称暗号化アルゴリズムのサービスプロバイダとして、データの暗号化および復号化機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：Triple DES（3DES）は、DESアルゴリズムを3回適用することで強化された対称暗号化方式である。DESの56ビット鍵長が現代の計算能力に対して脆弱であることが判明したため、互換性を維持しながらセキュリティを向上させる目的で開発された。金融機関やレガシーシステムとの互換性が求められる場面で広く使用されている。

**機能の利用シーン**：金融トランザクションデータの暗号化、レガシーシステムとの相互運用性が必要なファイル暗号化、既存のDESベースシステムからの移行段階での暗号化処理などで利用される。

**主要な処理内容**：
1. Triple DESアルゴリズムを使用した暗号化オブジェクト（Encryptor）の生成
2. Triple DESアルゴリズムを使用した復号化オブジェクト（Decryptor）の生成
3. 128ビットまたは192ビットの暗号鍵の管理と検証
4. 初期化ベクトル（IV）の生成と管理
5. 弱い鍵のチェックと拒否
6. 複数の暗号モード（CBC、ECB、CFB、OFB、CTS）のサポート

**関連システム・外部連携**：Windows CryptoAPI（advapi32.dll）を使用して暗号化処理を実行する。CryptoAPITransformクラスを介して実際の暗号化/復号化変換を行う。

**権限による制御**：特別な権限制御は実装されていないが、暗号化サービスの利用にはWindows CryptoAPIへのアクセスが必要である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Simply VB Unit Runner | 主機能 | テストスイート内のTripleDESテスト（TripleDESCryptoServiceProviderTests等）の実行 |
| 7 | File Encryption | 主機能 | Triple DES暗号化アルゴリズム（選択可能な対称暗号の1つ） |

## 機能種別

暗号化/復号化処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Key | Byte() | No | 暗号鍵（128ビットまたは192ビット） | 弱い鍵は拒否される |
| IV | Byte() | No | 初期化ベクトル（64ビット固定） | 8バイト長であること |
| RgbKey | Byte() | No | 暗号化/復号化時の鍵 | RgbIVとセットで指定 |
| RgbIV | Byte() | No | 暗号化/復号化時のIV | RgbKeyとセットで指定 |

### 入力データソース

- ユーザーが指定する暗号鍵およびIV
- 未指定の場合は自動生成

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CreateEncryptor戻り値 | ICryptoTransform | 暗号化変換オブジェクト |
| CreateDecryptor戻り値 | ICryptoTransform | 復号化変換オブジェクト |
| Key | Byte() | 現在の暗号鍵 |
| IV | Byte() | 現在の初期化ベクトル |

### 出力先

暗号化/復号化変換オブジェクトを呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化
   └─ SymmetricAlgorithmBaseの設定（ブロックサイズ64ビット、鍵サイズ192ビット）
2. 暗号化/復号化オブジェクト生成要求
   └─ CreateEncryptor/CreateDecryptorメソッド呼び出し
3. パラメータ検証
   └─ RgbKeyとRgbIVの整合性チェック、弱い鍵チェック
4. CryptoAPITransformの初期化
   └─ CALG_3DES_112またはCALG_3DESアルゴリズムで初期化
5. 変換オブジェクト返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CreateEncryptor/CreateDecryptor呼び出し]
    B --> C{RgbKey指定あり?}
    C -->|Yes| D{RgbIV指定あり?}
    C -->|No| E{RgbIV指定あり?}
    D -->|No| F[例外:IVが必要]
    D -->|Yes| G[パラメータ使用]
    E -->|Yes| H[例外:Keyが必要]
    E -->|No| I[内部Key/IV使用]
    G --> J{弱い鍵チェック}
    I --> J
    J -->|弱い鍵| K[例外:弱い鍵]
    J -->|OK| L{KeySize判定}
    L -->|128ビット| M[CALG_3DES_112]
    L -->|192ビット| N[CALG_3DES]
    M --> O[CryptoAPITransform初期化]
    N --> O
    O --> P[変換オブジェクト返却]
    P --> Q[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-51-01 | 弱い鍵の拒否 | TripleDES.IsWeakKeyがTrueを返す鍵は使用不可 | 鍵設定時 |
| BR-51-02 | Key/IV同時指定 | RgbKeyとRgbIVは両方指定または両方省略 | 変換オブジェクト生成時 |
| BR-51-03 | CFBフィードバックサイズ | CFBモードではフィードバックサイズは8ビット固定 | CFBモード使用時 |

### 計算ロジック

- KeySizeが128ビットの場合：CALG_3DES_112（2キーTriple DES）
- KeySizeが192ビットの場合：CALG_3DES（3キーTriple DES）

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ArgumentException | IVなしでKeyのみ指定 | IVも指定する |
| - | ArgumentException | KeyなしでIVのみ指定 | Keyも指定する |
| - | CryptographicException | 弱い鍵を使用 | 異なる鍵を生成する |
| - | CryptographicException | CFBで8ビット以外のフィードバックサイズ | フィードバックサイズを8に設定 |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

Windows CryptoAPIを使用するため、ネイティブコードによる高速な暗号化処理を実現

## セキュリティ考慮事項

- 弱い鍵のチェックを実装し、セキュリティ上問題のある鍵は拒否
- 暗号鍵とIVはClearメソッドで明示的にクリア可能
- AESへの移行が推奨される（Triple DESは旧式アルゴリズム）

## 備考

- .NET Frameworkとの互換性を維持した実装
- SymmetricAlgorithmおよびTripleDESインターフェースを実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TripleDES.cls | `Source/CorLib/System.Security.Cryptography/TripleDES.cls` | TripleDESインターフェースの定義を理解 |

**読解のコツ**: VB6のクラスモジュールにおけるインターフェース定義パターンを把握する。プロパティとメソッドのシグネチャに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TripleDESCryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/TripleDESCryptoServiceProvider.cls` | メインの実装クラス |

**主要処理フロー**:
1. **347-358行目**: Class_Initialize - デフォルト設定の初期化
2. **264-266行目**: CreateEncryptor - 暗号化変換オブジェクト生成
3. **277-279行目**: CreateDecryptor - 復号化変換オブジェクト生成
4. **320-341行目**: CreateCipher - 実際の暗号変換オブジェクト生成ロジック

#### Step 3: 基盤クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SymmetricAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithmBase.cls` | 対称暗号の共通基盤 |
| 3-2 | CryptoAPITransform.cls | `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` | Windows CryptoAPIとの連携 |

**主要処理フロー**:
- **380-384行目**: mBase_CheckForWeakKey - 弱い鍵チェックイベント

### プログラム呼び出し階層図

```
TripleDESCryptoServiceProvider
    │
    ├─ SymmetricAlgorithmBase (mBase)
    │      ├─ Key/IV管理
    │      ├─ LegalBlockSizes/LegalKeySizes管理
    │      └─ CheckForWeakKeyイベント発火
    │
    ├─ CreateCipher (Private)
    │      ├─ パラメータ検証
    │      ├─ アルゴリズム選択 (CALG_3DES_112 / CALG_3DES)
    │      └─ CryptoAPITransform.Init呼び出し
    │
    └─ TripleDESStatic
           └─ IsWeakKey (弱い鍵チェック)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Key (Byte[])  ────────┐
                      │
IV (Byte[])   ────────┤
                      ▼
              ┌─────────────────┐
              │ パラメータ検証   │
              │ 弱い鍵チェック   │
              └────────┬────────┘
                       ▼
              ┌─────────────────┐
              │ CreateCipher    │──────▶ ICryptoTransform
              │ (CryptoAPI呼出) │
              └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TripleDESCryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | メイン実装 |
| TripleDES.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | インターフェース定義 |
| TripleDESStatic.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 静的メソッド（IsWeakKey等） |
| SymmetricAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 対称暗号基盤クラス |
| CryptoAPITransform.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | CryptoAPI変換実装 |
| TripleDESCryptoServiceProvider.html | `Source/CorLib/DocIncludes/` | ドキュメント | APIドキュメント |
