# 機能設計書 52-RC2CryptoServiceProvider

## 概要

本ドキュメントは、VBCorLibライブラリにおけるRC2CryptoServiceProvider機能の設計仕様を記載する。本クラスはRC2対称暗号化アルゴリズムのサービスプロバイダとして、データの暗号化および復号化機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：RC2（Rivest Cipher 2）は、可変長鍵を持つブロック暗号アルゴリズムである。S/MIMEなどの電子メールセキュリティ規格で使用されてきた経緯があり、レガシーシステムとの互換性維持のために提供されている。現代では推奨されないが、既存システムとの相互運用性のために必要とされる場合がある。

**機能の利用シーン**：レガシーS/MIMEメッセージの復号、古いシステムとの互換性が必要なファイル暗号化、既存RC2ベースシステムとの連携処理などで利用される。

**主要な処理内容**：
1. RC2アルゴリズムを使用した暗号化オブジェクト（Encryptor）の生成
2. RC2アルゴリズムを使用した復号化オブジェクト（Decryptor）の生成
3. 可変長暗号鍵（40〜128ビット）の管理
4. 有効鍵長（EffectiveKeySize）の管理
5. 初期化ベクトル（IV）の生成と管理
6. 複数の暗号モード（CBC、ECB、CFB、OFB、CTS）のサポート

**関連システム・外部連携**：Windows CryptoAPI（advapi32.dll）を使用して暗号化処理を実行する。CryptoAPITransformクラスを介して実際の暗号化/復号化変換を行う。

**権限による制御**：特別な権限制御は実装されていない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Simply VB Unit Runner | 主機能 | テストスイート内のRC2テスト（RC2CryptoServiceProviderTests等）の実行 |
| 7 | File Encryption | 主機能 | RC2暗号化アルゴリズム（選択可能な対称暗号の1つ） |

## 機能種別

暗号化/復号化処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Key | Byte() | No | 暗号鍵（40〜128ビット） | 8ビット単位で指定 |
| IV | Byte() | No | 初期化ベクトル（64ビット固定） | 8バイト長であること |
| EffectiveKeySize | Long | No | 有効鍵長（ビット単位） | 40〜1024ビット |
| RgbKey | Byte() | No | 暗号化/復号化時の鍵 | RgbIVとセットで指定 |
| RgbIV | Byte() | No | 暗号化/復号化時のIV | RgbKeyとセットで指定 |

### 入力データソース

- ユーザーが指定する暗号鍵およびIV
- 未指定の場合は自動生成

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CreateEncryptor戻り値 | ICryptoTransform | 暗号化変換オブジェクト |
| CreateDecryptor戻り値 | ICryptoTransform | 復号化変換オブジェクト |
| Key | Byte() | 現在の暗号鍵 |
| IV | Byte() | 現在の初期化ベクトル |
| EffectiveKeySize | Long | 有効鍵長 |

### 出力先

暗号化/復号化変換オブジェクトを呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化
   └─ SymmetricAlgorithmBaseの設定（ブロックサイズ64ビット、鍵サイズ128ビット）
2. 暗号化/復号化オブジェクト生成要求
   └─ CreateEncryptor/CreateDecryptorメソッド呼び出し
3. パラメータ検証
   └─ RgbKeyとRgbIVの整合性チェック
4. CryptoAPITransformの初期化
   └─ CALG_RC2アルゴリズムで初期化
5. 有効鍵長の設定
   └─ EffectiveKeySizeをCryptoAPIに設定
6. 変換オブジェクト返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CreateEncryptor/CreateDecryptor呼び出し]
    B --> C{RgbKey指定あり?}
    C -->|Yes| D{RgbIV指定あり?}
    C -->|No| E{RgbIV指定あり?}
    D -->|No| F[例外:IVが必要]
    D -->|Yes| G[パラメータ使用]
    E -->|Yes| H[例外:Keyが必要]
    E -->|No| I[内部Key/IV使用]
    G --> J[CryptoAPITransform初期化]
    I --> J
    J --> K[EffectiveKeySize設定]
    K --> L[変換オブジェクト返却]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-52-01 | Key/IV同時指定 | RgbKeyとRgbIVは両方指定または両方省略 | 変換オブジェクト生成時 |
| BR-52-02 | 鍵長範囲 | 鍵サイズは40〜128ビット（8ビット単位） | 鍵設定時 |
| BR-52-03 | 有効鍵長範囲 | 有効鍵サイズは40〜1024ビット | EffectiveKeySize設定時 |
| BR-52-04 | CFBフィードバックサイズ | CFBモードではフィードバックサイズは8ビット固定 | CFBモード使用時 |

### 計算ロジック

- UseSaltプロパティがTrueの場合：ソルト値を使用して鍵を拡張
- EffectiveKeySizeは実際の暗号強度を決定（鍵サイズと異なる場合がある）

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ArgumentException | IVなしでKeyのみ指定 | IVも指定する |
| - | ArgumentException | KeyなしでIVのみ指定 | Keyも指定する |
| - | CryptographicException | CFBで8ビット以外のフィードバックサイズ | フィードバックサイズを8に設定 |
| - | CryptographicException | 無効な鍵サイズ | 有効範囲内の鍵サイズを指定 |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

Windows CryptoAPIを使用するため、ネイティブコードによる高速な暗号化処理を実現

## セキュリティ考慮事項

- RC2は現代のセキュリティ基準では推奨されない
- 新規開発ではAESの使用を強く推奨
- 有効鍵長が短い場合、暗号強度が低下する
- 暗号鍵とIVはClearメソッドで明示的にクリア可能

## 備考

- .NET Frameworkとの互換性を維持した実装
- SymmetricAlgorithmおよびRC2インターフェースを実装
- UseSaltプロパティでソルト使用を制御可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RC2.cls | `Source/CorLib/System.Security.Cryptography/RC2.cls` | RC2インターフェースの定義を理解 |

**読解のコツ**: EffectiveKeySizeプロパティがRC2固有の特徴であることに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RC2CryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/RC2CryptoServiceProvider.cls` | メインの実装クラス |

**主要処理フロー**:
1. **71-83行目**: EffectiveKeySizeプロパティ - 有効鍵長の管理
2. **209-211行目**: CreateEncryptor - 暗号化変換オブジェクト生成
3. **222-224行目**: CreateDecryptor - 復号化変換オブジェクト生成
4. **262-288行目**: CreateCipher - 実際の暗号変換オブジェクト生成ロジック

#### Step 3: 基盤クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SymmetricAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithmBase.cls` | 対称暗号の共通基盤 |
| 3-2 | CryptoAPITransform.cls | `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` | Windows CryptoAPIとの連携 |

### プログラム呼び出し階層図

```
RC2CryptoServiceProvider
    │
    ├─ SymmetricAlgorithmBase (mBase)
    │      ├─ Key/IV管理
    │      ├─ LegalBlockSizes/LegalKeySizes管理
    │      └─ Mode/Padding管理
    │
    ├─ CreateCipher (Private)
    │      ├─ パラメータ検証
    │      ├─ CALG_RC2アルゴリズム選択
    │      ├─ CryptoAPITransform.Init呼び出し
    │      └─ EffectiveKeySize設定
    │
    └─ UseSalt
           └─ ソルト使用の制御
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Key (Byte[])  ────────┐
                      │
IV (Byte[])   ────────┤
                      │
EffectiveKeySize ─────┤
                      ▼
              ┌─────────────────┐
              │ パラメータ検証   │
              └────────┬────────┘
                       ▼
              ┌─────────────────┐
              │ CreateCipher    │──────▶ ICryptoTransform
              │ (CryptoAPI呼出) │
              │ EffectiveKeySize│
              └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RC2CryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | メイン実装 |
| RC2.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | インターフェース定義 |
| SymmetricAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 対称暗号基盤クラス |
| CryptoAPITransform.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | CryptoAPI変換実装 |
| RC2CryptoServiceProvider.html | `Source/CorLib/DocIncludes/` | ドキュメント | APIドキュメント |
