# 機能設計書 53-RSACryptoServiceProvider

## 概要

本ドキュメントは、VBCorLibライブラリにおけるRSACryptoServiceProvider機能の設計仕様を記載する。本クラスはRSA非対称暗号化アルゴリズムのサービスプロバイダとして、公開鍵暗号化、デジタル署名の生成・検証機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：RSA（Rivest-Shamir-Adleman）は最も広く使用されている非対称暗号化アルゴリズムである。公開鍵と秘密鍵のペアを使用することで、鍵の事前共有なしにセキュアな通信やデジタル署名が可能となる。SSL/TLS証明書、コード署名、セキュアなメッセージングなど幅広い用途で使用される。

**機能の利用シーン**：SSL/TLS通信の鍵交換、デジタル証明書の署名と検証、コード署名、セキュアなデータ交換のための暗号化、電子署名の生成と検証などで利用される。

**主要な処理内容**：
1. RSA鍵ペアの生成と管理
2. 公開鍵を使用したデータ暗号化
3. 秘密鍵を使用したデータ復号化
4. ハッシュ値へのデジタル署名生成
5. デジタル署名の検証
6. 鍵のインポート・エクスポート

**関連システム・外部連携**：Windows CryptoAPI（advapi32.dll）を使用して暗号化処理を実行する。CSP（Cryptographic Service Provider）を介して実際の暗号化/復号化処理を行う。

**権限による制御**：秘密鍵へのアクセスには適切な権限が必要。エクスポート可能フラグにより秘密鍵のエクスポート可否を制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Simply VB Unit Runner | 主機能 | テストスイート内のRSAテスト（RSACryptoServiceProviderTests等）の実行 |

## 機能種別

非対称暗号化/復号化、デジタル署名処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| KeySize | Long | No | 鍵サイズ（ビット単位） | 384〜16384ビット |
| Rgb | Byte() | Yes | 暗号化/復号化対象データ | - |
| fOAEP | Boolean | No | OAEPパディング使用フラグ | - |
| RgbHash | Byte() | Yes | 署名対象ハッシュ値 | - |
| str | String | Yes | ハッシュアルゴリズム名 | "MD5", "SHA1"等 |
| Signature | Byte() | Yes | 検証対象署名 | - |

### 入力データソース

- ユーザーが指定する暗号化データ
- 署名対象のハッシュ値
- CspParametersによるCSP設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Encrypt戻り値 | Byte() | 暗号化されたデータ |
| Decrypt戻り値 | Byte() | 復号化されたデータ |
| SignHash戻り値 | Byte() | デジタル署名 |
| VerifyHash戻り値 | Boolean | 署名検証結果 |
| ExportParameters戻り値 | RSAParameters | 鍵パラメータ |

### 出力先

暗号化データ、署名、検証結果を呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化
   └─ CryptoAPIの初期化、鍵コンテナへのアクセス
2. 鍵生成または既存鍵のロード
   └─ 指定されたKeySizeで鍵ペアを生成またはインポート
3. 暗号化/復号化/署名操作
   └─ CryptoAPI関数を呼び出して処理実行
4. 結果返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{CspParameters指定?}
    B -->|Yes| C[指定CSP使用]
    B -->|No| D[デフォルトCSP使用]
    C --> E[鍵コンテナオープン]
    D --> E
    E --> F{既存鍵あり?}
    F -->|Yes| G[既存鍵ロード]
    F -->|No| H[新規鍵生成]
    G --> I[暗号化/署名操作]
    H --> I
    I --> J[結果返却]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-01 | 鍵サイズ制限 | 鍵サイズは384〜16384ビット、8の倍数 | 鍵生成時 |
| BR-53-02 | 秘密鍵アクセス制限 | 秘密鍵エクスポートにはエクスポート可能フラグが必要 | ExportParameters呼び出し時 |
| BR-53-03 | 復号時秘密鍵必須 | 復号化操作には秘密鍵へのアクセスが必要 | Decrypt呼び出し時 |
| BR-53-04 | 署名時秘密鍵必須 | 署名生成には秘密鍵へのアクセスが必要 | SignHash呼び出し時 |

### 計算ロジック

- OAEPパディング使用時：暗号化可能な最大データサイズ = 鍵サイズ - 42バイト
- PKCS#1 v1.5パディング使用時：暗号化可能な最大データサイズ = 鍵サイズ - 11バイト

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CryptographicException | 秘密鍵なしで復号化試行 | 秘密鍵を含む鍵をインポートする |
| - | CryptographicException | データサイズが鍵サイズを超過 | データを分割するか大きな鍵を使用 |
| - | CryptographicException | 無効な署名検証 | 正しいデータと署名を使用 |
| - | CryptographicException | エクスポート不可の秘密鍵エクスポート試行 | エクスポート可能な鍵を使用 |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

- RSA操作は計算コストが高いため、大量データには対称暗号との組み合わせを推奨
- 鍵サイズが大きいほど処理時間が増加

## セキュリティ考慮事項

- 2048ビット以上の鍵サイズを推奨
- 秘密鍵はPersistKeyInCspプロパティで永続化可否を制御
- 鍵コンテナ名の適切な管理が必要
- OAEPパディングはPKCS#1 v1.5より安全

## 備考

- .NET Frameworkとの互換性を維持した実装
- RSAインターフェースを実装
- XML形式での鍵インポート・エクスポートに対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RSAParameters.cls | `Source/CorLib/System.Security.Cryptography/RSAParameters.cls` | RSA鍵パラメータの構造を理解 |
| 1-2 | RSA.cls | `Source/CorLib/System.Security.Cryptography/RSA.cls` | RSAインターフェースの定義 |

**読解のコツ**: RSAParametersの各フィールド（D, DP, DQ, Exponent, InverseQ, Modulus, P, Q）の意味を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RSACryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/RSACryptoServiceProvider.cls` | メインの実装クラス |

**主要処理フロー**:
1. **クラス初期化**: CryptoAPIの初期化とデフォルトCSPへのアクセス
2. **Encryptメソッド**: 公開鍵暗号化（OAEPまたはPKCS#1 v1.5）
3. **Decryptメソッド**: 秘密鍵復号化
4. **SignHashメソッド**: ハッシュ値への署名生成
5. **VerifyHashメソッド**: 署名検証
6. **ExportParameters/ImportParameters**: 鍵のエクスポート/インポート

#### Step 3: 基盤クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CspParameters.cls | `Source/CorLib/System.Security.Cryptography/CspParameters.cls` | CSP設定パラメータ |
| 3-2 | CryptoAPIHash.cls | `Source/CorLib/System.Security.Cryptography/CryptoAPIHash.cls` | CryptoAPIハッシュ操作 |

### プログラム呼び出し階層図

```
RSACryptoServiceProvider
    │
    ├─ CryptoAPI関数呼び出し
    │      ├─ CryptAcquireContext (CSP取得)
    │      ├─ CryptGenKey (鍵生成)
    │      ├─ CryptExportKey (鍵エクスポート)
    │      ├─ CryptImportKey (鍵インポート)
    │      ├─ CryptEncrypt (暗号化)
    │      ├─ CryptDecrypt (復号化)
    │      ├─ CryptSignHash (署名)
    │      └─ CryptVerifySignature (署名検証)
    │
    ├─ RSAParameters
    │      └─ 鍵パラメータの保持
    │
    └─ CspParameters
           └─ CSP設定の保持
```

### データフロー図

```
[入力]                    [処理]                         [出力]

平文データ    ────────┐
                      ▼
              ┌─────────────────┐
公開鍵  ─────▶│    Encrypt     │──────▶ 暗号文
              └─────────────────┘

暗号文        ────────┐
                      ▼
              ┌─────────────────┐
秘密鍵  ─────▶│    Decrypt     │──────▶ 平文
              └─────────────────┘

ハッシュ値    ────────┐
                      ▼
              ┌─────────────────┐
秘密鍵  ─────▶│    SignHash    │──────▶ 署名
              └─────────────────┘

ハッシュ値    ────────┐
署名         ────────┤
                      ▼
              ┌─────────────────┐
公開鍵  ─────▶│   VerifyHash   │──────▶ Boolean
              └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RSACryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | メイン実装 |
| RSA.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | インターフェース定義 |
| RSAParameters.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 鍵パラメータ |
| CspParameters.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | CSP設定 |
| RSACryptoServiceProvider.html | `Source/CorLib/DocIncludes/` | ドキュメント | APIドキュメント |
