# 機能設計書 54-DSACryptoServiceProvider

## 概要

本ドキュメントは、VBCorLibライブラリにおけるDSACryptoServiceProvider機能の設計仕様を記載する。本クラスはDSA（Digital Signature Algorithm）のサービスプロバイダとして、デジタル署名の生成・検証機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：DSA（Digital Signature Algorithm）は、FIPS 186規格で定義されたデジタル署名専用の非対称暗号アルゴリズムである。RSAとは異なり暗号化機能は持たず、署名の生成と検証に特化している。政府機関や規制産業において、FIPS準拠が要求される場面で使用される。

**機能の利用シーン**：電子文書への署名、コード署名、認証プロトコル、改ざん検知が必要なデータの検証などで利用される。

**主要な処理内容**：
1. DSA鍵ペアの生成と管理
2. ハッシュ値へのデジタル署名生成
3. デジタル署名の検証
4. 鍵のインポート・エクスポート

**関連システム・外部連携**：Windows CryptoAPI（advapi32.dll）を使用して署名処理を実行する。CSP（Cryptographic Service Provider）を介して実際の署名生成/検証処理を行う。

**権限による制御**：秘密鍵へのアクセスには適切な権限が必要。エクスポート可能フラグにより秘密鍵のエクスポート可否を制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Simply VB Unit Runner | 主機能 | テストスイート内のDSAテスト（DSACryptoServiceProviderTests等）の実行 |

## 機能種別

デジタル署名処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| KeySize | Long | No | 鍵サイズ（ビット単位） | 512〜1024ビット |
| RgbHash | Byte() | Yes | 署名対象ハッシュ値 | SHA-1ハッシュ（20バイト） |
| str | String | Yes | ハッシュアルゴリズム名 | "SHA1" |
| RgbSignature | Byte() | Yes | 検証対象署名 | - |

### 入力データソース

- ユーザーが指定する署名対象データ
- CspParametersによるCSP設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SignHash戻り値 | Byte() | デジタル署名（40バイト固定） |
| VerifyHash戻り値 | Boolean | 署名検証結果 |
| SignData戻り値 | Byte() | データへの署名 |
| VerifyData戻り値 | Boolean | データ署名検証結果 |
| ExportParameters戻り値 | DSAParameters | 鍵パラメータ |

### 出力先

署名、検証結果を呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化
   └─ CryptoAPIの初期化、鍵コンテナへのアクセス
2. 鍵生成または既存鍵のロード
   └─ 指定されたKeySizeで鍵ペアを生成またはインポート
3. 署名操作
   └─ CryptoAPI関数を呼び出して署名生成/検証
4. 結果返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{CspParameters指定?}
    B -->|Yes| C[指定CSP使用]
    B -->|No| D[デフォルトCSP使用]
    C --> E[鍵コンテナオープン]
    D --> E
    E --> F{既存鍵あり?}
    F -->|Yes| G[既存鍵ロード]
    F -->|No| H[新規鍵生成]
    G --> I[署名操作]
    H --> I
    I --> J[結果返却]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-01 | 鍵サイズ制限 | 鍵サイズは512〜1024ビット、64の倍数 | 鍵生成時 |
| BR-54-02 | SHA-1ハッシュ必須 | DSAはSHA-1ハッシュのみサポート | 署名生成/検証時 |
| BR-54-03 | 秘密鍵アクセス制限 | 秘密鍵エクスポートにはエクスポート可能フラグが必要 | ExportParameters呼び出し時 |
| BR-54-04 | 署名時秘密鍵必須 | 署名生成には秘密鍵へのアクセスが必要 | SignHash呼び出し時 |

### 計算ロジック

- 署名サイズは常に40バイト（r: 20バイト + s: 20バイト）
- ハッシュサイズは常に20バイト（SHA-1）

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CryptographicException | 秘密鍵なしで署名試行 | 秘密鍵を含む鍵をインポートする |
| - | CryptographicException | SHA-1以外のハッシュアルゴリズム指定 | SHA-1を使用する |
| - | CryptographicException | 無効な署名検証 | 正しいデータと署名を使用 |
| - | CryptographicException | エクスポート不可の秘密鍵エクスポート試行 | エクスポート可能な鍵を使用 |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

- DSA署名生成は乱数生成を含むため、同じデータでも異なる署名が生成される
- 署名検証は署名生成より高速

## セキュリティ考慮事項

- SHA-1は衝突攻撃に対して脆弱性があり、新規システムではECDSA推奨
- 1024ビット鍵は現代のセキュリティ基準では不十分とされる
- 秘密鍵はPersistKeyInCspプロパティで永続化可否を制御
- 鍵コンテナ名の適切な管理が必要

## 備考

- .NET Frameworkとの互換性を維持した実装
- DSAインターフェースを実装
- XML形式での鍵インポート・エクスポートに対応
- RSAとは異なり暗号化機能は持たない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DSAParameters.cls | `Source/CorLib/System.Security.Cryptography/DSAParameters.cls` | DSA鍵パラメータの構造を理解 |
| 1-2 | DSA.cls | `Source/CorLib/System.Security.Cryptography/DSA.cls` | DSAインターフェースの定義 |

**読解のコツ**: DSAParametersの各フィールド（Counter, G, J, P, Q, Seed, X, Y）の意味を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DSACryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/DSACryptoServiceProvider.cls` | メインの実装クラス |

**主要処理フロー**:
1. **クラス初期化**: CryptoAPIの初期化とデフォルトCSPへのアクセス
2. **SignHashメソッド**: ハッシュ値への署名生成
3. **VerifyHashメソッド**: 署名検証
4. **SignDataメソッド**: データへの署名（内部でハッシュ計算）
5. **VerifyDataメソッド**: データ署名検証
6. **ExportParameters/ImportParameters**: 鍵のエクスポート/インポート

#### Step 3: 基盤クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CspParameters.cls | `Source/CorLib/System.Security.Cryptography/CspParameters.cls` | CSP設定パラメータ |

### プログラム呼び出し階層図

```
DSACryptoServiceProvider
    │
    ├─ CryptoAPI関数呼び出し
    │      ├─ CryptAcquireContext (CSP取得)
    │      ├─ CryptGenKey (鍵生成)
    │      ├─ CryptExportKey (鍵エクスポート)
    │      ├─ CryptImportKey (鍵インポート)
    │      ├─ CryptSignHash (署名)
    │      └─ CryptVerifySignature (署名検証)
    │
    ├─ DSAParameters
    │      └─ 鍵パラメータの保持
    │
    └─ CspParameters
           └─ CSP設定の保持
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ハッシュ値    ────────┐
                      ▼
              ┌─────────────────┐
秘密鍵  ─────▶│    SignHash    │──────▶ 署名(40バイト)
              └─────────────────┘

ハッシュ値    ────────┐
署名         ────────┤
                      ▼
              ┌─────────────────┐
公開鍵  ─────▶│   VerifyHash   │──────▶ Boolean
              └─────────────────┘

データ        ────────┐
                      ▼
              ┌─────────────────┐
秘密鍵  ─────▶│    SignData    │──────▶ 署名
              │  (SHA-1計算)   │
              └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DSACryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | メイン実装 |
| DSA.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | インターフェース定義 |
| DSAParameters.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 鍵パラメータ |
| CspParameters.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | CSP設定 |
| DSACryptoServiceProvider.html | `Source/CorLib/DocIncludes/` | ドキュメント | APIドキュメント |
