# 機能設計書 55-SHA1Managed

## 概要

本ドキュメントは、VBCorLibライブラリにおけるSHA1Managed機能の設計仕様を記載する。本クラスはSHA-1（Secure Hash Algorithm 1）ハッシュアルゴリズムのマネージド実装として、160ビットのハッシュ値計算機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：SHA-1はNISTによって1995年に公開された暗号学的ハッシュ関数である。任意長のメッセージを160ビット（20バイト）の固定長ダイジェストに変換する。データ完整性検証、デジタル署名、パスワードハッシュなど広範な用途で使用されてきた。ただし、2017年以降衝突攻撃が実証されており、新規システムではSHA-256以上の使用が推奨される。

**機能の利用シーン**：レガシーシステムとの互換性維持、Git等のバージョン管理システムとの連携、既存SHA-1ベースプロトコルとの相互運用などで利用される。

**主要な処理内容**：
1. バイト配列のSHA-1ハッシュ値計算
2. ストリームデータのSHA-1ハッシュ値計算
3. 増分ハッシュ計算（TransformBlock/TransformFinalBlock）
4. ハッシュ計算のリセット（Initialize）

**関連システム・外部連携**：純粋なVisual Basic実装であり、外部ライブラリへの依存がない。ICryptoTransformインターフェースを実装し、CryptoStreamと連携可能。

**権限による制御**：特別な権限制御は実装されていない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Simply VB Unit Runner | 主機能 | テストスイート内のSHA1テスト（SHA1ManagedTests等）の実行 |

## 機能種別

ハッシュ計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Source | Variant | Yes | ハッシュ対象データ（Byte配列またはStream） | - |
| Index | Variant | No | Byte配列の開始インデックス | 有効範囲内 |
| Count | Variant | No | 処理するバイト数 | 有効範囲内 |
| InputBuffer | Byte() | Yes | 増分計算用入力バッファ | - |
| InputOffset | Long | Yes | 入力開始位置 | - |
| InputCount | Long | Yes | 入力バイト数 | - |

### 入力データソース

- ユーザーが指定するバイト配列またはStreamオブジェクト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ComputeHash戻り値 | Byte() | 20バイトのハッシュ値 |
| Hash | Byte() | 計算済みハッシュ値プロパティ |
| HashSize | Long | 160（ビット単位） |

### 出力先

ハッシュ値を呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化
   └─ 内部状態の初期設定（5つの32ビットレジスタ）
2. データ入力
   └─ ComputeHashまたはTransformBlock呼び出し
3. ブロック処理
   └─ 64バイトブロック単位でTransform実行
4. 最終処理
   └─ パディングとメッセージ長追加
5. ハッシュ値出力
   └─ 20バイトのダイジェスト返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Initialize]
    B --> C{入力タイプ?}
    C -->|Byte配列| D[配列からブロック抽出]
    C -->|Stream| E[ストリームから読み込み]
    D --> F{64バイト以上?}
    E --> F
    F -->|Yes| G[Transform実行]
    G --> F
    F -->|No| H[残りデータをバッファ]
    H --> I[パディング追加]
    I --> J[メッセージ長追加]
    J --> K[最終Transform]
    K --> L[状態からハッシュ生成]
    L --> M[20バイトハッシュ返却]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-55-01 | ハッシュサイズ固定 | 出力は常に160ビット（20バイト） | 常時 |
| BR-55-02 | 初期状態リセット | TransformFinalBlock後は自動的にInitialize | ハッシュ計算完了後 |
| BR-55-03 | ブロックサイズ | 内部処理は64バイトブロック単位 | 常時 |
| BR-55-04 | エンディアン変換 | 出力はビッグエンディアン形式 | ハッシュ出力時 |

### 計算ロジック

- **初期ハッシュ値**:
  - H0 = 0x67452301
  - H1 = 0xEFCDAB89
  - H2 = 0x98BADCFE
  - H3 = 0x10325476
  - H4 = 0xC3D2E1F0

- **ラウンド定数**:
  - K0-19: 0x5A827999
  - K20-39: 0x6ED9EBA1
  - K40-59: 0x8F1BBCDC
  - K60-79: 0xCA62C1D6

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidOperationException | TransformFinalBlock前にHashプロパティアクセス | TransformFinalBlockを先に呼び出す |
| - | ArgumentException | 無効なインデックスまたはカウント | 有効な範囲を指定する |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

- 純粋なVisual Basic実装のため、CryptoAPI版（SHA1CryptoServiceProvider）より低速
- リリースビルドでは整数オーバーフローチェックを無効化して最適化

## セキュリティ考慮事項

- SHA-1は衝突攻撃に対して脆弱（2017年SHAttered攻撃）
- 新規システムではSHA-256以上の使用を推奨
- パスワードハッシュ用途にはbcrypt/scrypt/Argon2を推奨

## 備考

- .NET Frameworkとの互換性を維持した実装
- HashAlgorithm、SHA1、ICryptoTransformインターフェースを実装
- CanReuseTransform、CanTransformMultipleBlocksは常にTrue

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SHA1.cls | `Source/CorLib/System.Security.Cryptography/SHA1.cls` | SHA1インターフェースの定義 |
| 1-2 | HashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/HashAlgorithm.cls` | ハッシュアルゴリズム基底インターフェース |

**読解のコツ**: VB6でのインターフェース継承パターンを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SHA1Managed.cls | `Source/CorLib/System.Security.Cryptography/SHA1Managed.cls` | メインの実装クラス |

**主要処理フロー**:
1. **55-58行目**: メンバ変数宣言 - mBase, mW(0-79), mState(0-4)
2. **142-152行目**: Initialize - 初期ハッシュ値設定
3. **135-137行目**: ComputeHash - ハッシュ計算のエントリーポイント
4. **225-255行目**: HashFinal - パディングと最終ブロック処理
5. **259-326行目**: Transform(リリース版) - 80ラウンドの変換処理
6. **328-383行目**: Transform(デバッグ版) - 可読性重視の実装

#### Step 3: 基盤クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HashAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/HashAlgorithmBase.cls` | ハッシュ計算の共通基盤 |

### プログラム呼び出し階層図

```
SHA1Managed
    │
    ├─ HashAlgorithmBase (mBase)
    │      ├─ ComputeHash (ストリーム/配列処理)
    │      ├─ TransformBlock (増分計算)
    │      ├─ TransformFinalBlock (最終計算)
    │      └─ Hash (結果取得)
    │
    ├─ Initialize
    │      └─ mState配列の初期化
    │
    ├─ Transform (IHashAlgorithm_HashCore経由)
    │      ├─ メッセージスケジュール生成 (mW拡張)
    │      └─ 80ラウンド圧縮関数
    │
    └─ HashFinal (IHashAlgorithm_HashFinal経由)
           ├─ パディング追加
           ├─ メッセージ長追加
           └─ 最終ブロック処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

                    ┌─────────────────┐
メッセージ ─────────▶│   Initialize    │
                    │  (状態初期化)   │
                    └────────┬────────┘
                             ▼
                    ┌─────────────────┐
64バイトブロック ───▶│    Transform    │
(繰り返し)          │  (80ラウンド)   │
                    └────────┬────────┘
                             ▼
                    ┌─────────────────┐
残りデータ ─────────▶│   HashFinal     │──────▶ 20バイトハッシュ
                    │ (パディング)    │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SHA1Managed.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | メイン実装 |
| SHA1.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | インターフェース定義 |
| SHA1Static.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 静的ファクトリメソッド |
| HashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 基底インターフェース |
| HashAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 共通基盤実装 |
| IHashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | コールバックインターフェース |
| SHA1Managed.html | `Source/CorLib/DocIncludes/` | ドキュメント | APIドキュメント |
