# 機能設計書 56-SHA256Managed

## 概要

本ドキュメントは、VBCorLibライブラリにおけるSHA256Managed機能の設計仕様を記載する。本クラスはSHA-256（Secure Hash Algorithm 256-bit）ハッシュアルゴリズムのマネージド実装として、256ビットのハッシュ値計算機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：SHA-256はSHA-2ファミリーの一員であり、NISTによって2001年に公開された暗号学的ハッシュ関数である。任意長のメッセージを256ビット（32バイト）の固定長ダイジェストに変換する。SHA-1の後継として、現代の暗号システムで広く採用されている標準アルゴリズムである。

**機能の利用シーン**：デジタル署名、TLS証明書、ブロックチェーン、パスワードハッシュ（ソルト付き）、ファイル完整性検証などで利用される。

**主要な処理内容**：
1. バイト配列のSHA-256ハッシュ値計算
2. ストリームデータのSHA-256ハッシュ値計算
3. 増分ハッシュ計算（TransformBlock/TransformFinalBlock）
4. ハッシュ計算のリセット（Initialize）

**関連システム・外部連携**：純粋なVisual Basic実装であり、外部ライブラリへの依存がない。ICryptoTransformインターフェースを実装し、CryptoStreamと連携可能。

**権限による制御**：特別な権限制御は実装されていない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Simply VB Unit Runner | 主機能 | テストスイート内のSHA256テスト（SHA256ManagedTests等）の実行 |

## 機能種別

ハッシュ計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Source | Variant | Yes | ハッシュ対象データ（Byte配列またはStream） | - |
| Index | Variant | No | Byte配列の開始インデックス | 有効範囲内 |
| Count | Variant | No | 処理するバイト数 | 有効範囲内 |
| InputBuffer | Byte() | Yes | 増分計算用入力バッファ | - |
| InputOffset | Long | Yes | 入力開始位置 | - |
| InputCount | Long | Yes | 入力バイト数 | - |

### 入力データソース

- ユーザーが指定するバイト配列またはStreamオブジェクト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ComputeHash戻り値 | Byte() | 32バイトのハッシュ値 |
| Hash | Byte() | 計算済みハッシュ値プロパティ |
| HashSize | Long | 256（ビット単位） |

### 出力先

ハッシュ値を呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化
   └─ 内部状態の初期設定（8つの32ビットレジスタ）
2. データ入力
   └─ ComputeHashまたはTransformBlock呼び出し
3. ブロック処理
   └─ 64バイトブロック単位でTransform実行
4. 最終処理
   └─ パディングとメッセージ長追加
5. ハッシュ値出力
   └─ 32バイトのダイジェスト返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Initialize]
    B --> C{入力タイプ?}
    C -->|Byte配列| D[配列からブロック抽出]
    C -->|Stream| E[ストリームから読み込み]
    D --> F{64バイト以上?}
    E --> F
    F -->|Yes| G[Transform実行]
    G --> F
    F -->|No| H[残りデータをバッファ]
    H --> I[パディング追加]
    I --> J[メッセージ長追加]
    J --> K[最終Transform]
    K --> L[状態からハッシュ生成]
    L --> M[32バイトハッシュ返却]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-56-01 | ハッシュサイズ固定 | 出力は常に256ビット（32バイト） | 常時 |
| BR-56-02 | 初期状態リセット | TransformFinalBlock後は自動的にInitialize | ハッシュ計算完了後 |
| BR-56-03 | ブロックサイズ | 内部処理は64バイトブロック単位 | 常時 |
| BR-56-04 | エンディアン変換 | 出力はビッグエンディアン形式 | ハッシュ出力時 |

### 計算ロジック

- **初期ハッシュ値**（最初の8つの素数の平方根の小数部）:
  - H0 = 0x6A09E667
  - H1 = 0xBB67AE85
  - H2 = 0x3C6EF372
  - H3 = 0xA54FF53A
  - H4 = 0x510E527F
  - H5 = 0x9B05688C
  - H6 = 0x1F83D9AB
  - H7 = 0x5BE0CD19

- **ラウンド定数K（64個）**: 最初の64個の素数の立方根の小数部

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidOperationException | TransformFinalBlock前にHashプロパティアクセス | TransformFinalBlockを先に呼び出す |
| - | ArgumentException | 無効なインデックスまたはカウント | 有効な範囲を指定する |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

- 純粋なVisual Basic実装のため、ネイティブ実装より低速
- リリースビルドでは整数オーバーフローチェックを無効化して最適化
- 64ラウンドの圧縮関数を実行

## セキュリティ考慮事項

- SHA-256は現時点で安全とされている
- 量子コンピュータに対する耐性は限定的（Groverのアルゴリズム）
- パスワードハッシュ用途には適切なソルトとストレッチングが必要

## 備考

- .NET Frameworkとの互換性を維持した実装
- HashAlgorithm、SHA256、ICryptoTransformインターフェースを実装
- CanReuseTransform、CanTransformMultipleBlocksは常にTrue

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SHA256.cls | `Source/CorLib/System.Security.Cryptography/SHA256.cls` | SHA256インターフェースの定義 |
| 1-2 | HashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/HashAlgorithm.cls` | ハッシュアルゴリズム基底インターフェース |

**読解のコツ**: SHA-1との違い（状態変数8個、64ラウンド）を意識する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SHA256Managed.cls | `Source/CorLib/System.Security.Cryptography/SHA256Managed.cls` | メインの実装クラス |

**主要処理フロー**:
1. **52-55行目**: メンバ変数宣言 - mBase, mW(0-79), mK(0-63), mState(0-7)
2. **140-153行目**: Initialize - 8つの初期ハッシュ値設定
3. **133-135行目**: ComputeHash - ハッシュ計算のエントリーポイント
4. **226-256行目**: HashFinal - パディングと最終ブロック処理
5. **260-330行目**: Transform(リリース版) - 64ラウンドの変換処理
6. **332-396行目**: Transform(デバッグ版) - 可読性重視の実装

#### Step 3: 基盤クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HashAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/HashAlgorithmBase.cls` | ハッシュ計算の共通基盤 |
| 3-2 | Statics.cls | `Source/CorLib/` | SHA256.KPtr（定数テーブル）の参照 |

### プログラム呼び出し階層図

```
SHA256Managed
    │
    ├─ HashAlgorithmBase (mBase)
    │      ├─ ComputeHash (ストリーム/配列処理)
    │      ├─ TransformBlock (増分計算)
    │      ├─ TransformFinalBlock (最終計算)
    │      └─ Hash (結果取得)
    │
    ├─ Initialize
    │      └─ mState配列の初期化（8要素）
    │
    ├─ Transform (IHashAlgorithm_HashCore経由)
    │      ├─ メッセージスケジュール生成 (mW拡張、64ワード)
    │      ├─ Sigma0/Sigma1関数
    │      ├─ Choice/Majority関数
    │      └─ 64ラウンド圧縮関数
    │
    └─ HashFinal (IHashAlgorithm_HashFinal経由)
           ├─ パディング追加
           ├─ メッセージ長追加
           └─ 最終ブロック処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

                    ┌─────────────────┐
メッセージ ─────────▶│   Initialize    │
                    │  (状態初期化)   │
                    └────────┬────────┘
                             ▼
                    ┌─────────────────┐
64バイトブロック ───▶│    Transform    │
(繰り返し)          │  (64ラウンド)   │
                    └────────┬────────┘
                             ▼
                    ┌─────────────────┐
残りデータ ─────────▶│   HashFinal     │──────▶ 32バイトハッシュ
                    │ (パディング)    │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SHA256Managed.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | メイン実装 |
| SHA256.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | インターフェース定義 |
| SHA256Static.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 静的ファクトリメソッド |
| HashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 基底インターフェース |
| HashAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 共通基盤実装 |
| IHashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | コールバックインターフェース |
| SHA256Managed.html | `Source/CorLib/DocIncludes/` | ドキュメント | APIドキュメント |
