# 機能設計書 57-SHA384Managed

## 概要

本ドキュメントは、VBCorLibライブラリにおけるSHA384Managed機能の設計仕様を記載する。本クラスはSHA-384（Secure Hash Algorithm 384-bit）ハッシュアルゴリズムのマネージド実装として、384ビットのハッシュ値計算機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：SHA-384はSHA-2ファミリーの一員であり、SHA-512の切り詰め版として設計された暗号学的ハッシュ関数である。任意長のメッセージを384ビット（48バイト）の固定長ダイジェストに変換する。SHA-256より高いセキュリティレベルが要求される場面や、64ビットアーキテクチャで効率的に動作させたい場合に使用される。

**機能の利用シーン**：高セキュリティが要求されるデジタル署名、TLS 1.2/1.3での鍵導出、HMAC-SHA384、ファイル完整性検証などで利用される。

**主要な処理内容**：
1. バイト配列のSHA-384ハッシュ値計算
2. ストリームデータのSHA-384ハッシュ値計算
3. 増分ハッシュ計算（TransformBlock/TransformFinalBlock）
4. ハッシュ計算のリセット（Initialize）

**関連システム・外部連携**：内部的にSHA512Managedを使用し、出力を48バイトに切り詰める。ICryptoTransformインターフェースを実装し、CryptoStreamと連携可能。

**権限による制御**：特別な権限制御は実装されていない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Simply VB Unit Runner | 主機能 | テストスイート内のSHA384テスト（SHA384ManagedTests等）の実行 |

## 機能種別

ハッシュ計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Source | Variant | Yes | ハッシュ対象データ（Byte配列またはStream） | - |
| Index | Variant | No | Byte配列の開始インデックス | 有効範囲内 |
| Count | Variant | No | 処理するバイト数 | 有効範囲内 |
| InputBuffer | Byte() | Yes | 増分計算用入力バッファ | - |
| InputOffset | Long | Yes | 入力開始位置 | - |
| InputCount | Long | Yes | 入力バイト数 | - |

### 入力データソース

- ユーザーが指定するバイト配列またはStreamオブジェクト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ComputeHash戻り値 | Byte() | 48バイトのハッシュ値 |
| Hash | Byte() | 計算済みハッシュ値プロパティ |
| HashSize | Long | 384（ビット単位） |

### 出力先

ハッシュ値を呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化
   └─ SHA512Managedの初期化（SHA-384用初期値で）
2. データ入力
   └─ ComputeHashまたはTransformBlock呼び出し
3. SHA-512処理の委譲
   └─ SHA512Managedに処理を委譲
4. 出力切り詰め
   └─ 64バイト出力を48バイトに切り詰め
5. ハッシュ値出力
   └─ 48バイトのダイジェスト返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Initialize]
    B --> C[SHA512Managed.Init with SHA384 state]
    C --> D{入力タイプ?}
    D -->|Byte配列| E[配列処理]
    D -->|Stream| F[ストリーム処理]
    E --> G[SHA512Managed.ComputeHash]
    F --> G
    G --> H[64バイト結果取得]
    H --> I[48バイトに切り詰め]
    I --> J[48バイトハッシュ返却]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-57-01 | ハッシュサイズ固定 | 出力は常に384ビット（48バイト） | 常時 |
| BR-57-02 | SHA-512ベース | 内部処理はSHA-512と同じだが初期値が異なる | 常時 |
| BR-57-03 | 出力切り詰め | SHA-512の64バイト出力を48バイトに切り詰め | ハッシュ出力時 |
| BR-57-04 | ブロックサイズ | 内部処理は128バイトブロック単位 | 常時 |

### 計算ロジック

- **初期ハッシュ値**（SHA-384固有、9〜16番目の素数の平方根の小数部）:
  - 異なる初期値を使用することでSHA-512とは異なるハッシュを生成
  - 初期値はStatics.SHA384.StatePtrから取得

- **処理構造**:
  - SHA-512と同じ80ラウンドの圧縮関数
  - 同じラウンド定数K（80個）
  - 最終出力のみ48バイトに切り詰め

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidOperationException | TransformFinalBlock前にHashプロパティアクセス | TransformFinalBlockを先に呼び出す |
| - | ArgumentException | 無効なインデックスまたはカウント | 有効な範囲を指定する |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

- SHA512Managedを内部で使用するため、同等のパフォーマンス特性
- 64ビットアーキテクチャでSHA-256より効率的に動作する可能性がある
- 128バイトブロック、80ラウンドの処理

## セキュリティ考慮事項

- SHA-384は現時点で安全とされている
- SHA-256より長いハッシュ長で、より高い衝突耐性を提供
- 192ビットのセキュリティレベル（誕生日攻撃に対して）

## 備考

- .NET Frameworkとの互換性を維持した実装
- HashAlgorithm、SHA384、ICryptoTransformインターフェースを実装
- SHA512Managedのラッパー実装
- 定数HashSizeInBytes = 48で出力サイズを定義

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SHA384.cls | `Source/CorLib/System.Security.Cryptography/SHA384.cls` | SHA384インターフェースの定義 |
| 1-2 | SHA512Managed.cls | `Source/CorLib/System.Security.Cryptography/SHA512Managed.cls` | ベース実装（SHA-512） |

**読解のコツ**: SHA384はSHA512のラッパーであり、初期値と出力サイズが異なるのみ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SHA384Managed.cls | `Source/CorLib/System.Security.Cryptography/SHA384Managed.cls` | メインの実装クラス |

**主要処理フロー**:
1. **51行目**: HashSizeInBytes = 48 定数定義
2. **53行目**: mBase As SHA512Managed - 委譲先
3. **81-85行目**: Hash - 64バイトを48バイトに切り詰め
4. **93-95行目**: HashSize = 384
5. **133-138行目**: ComputeHash - 結果を48バイトに切り詰め
6. **218-220行目**: Class_Initialize - SHA384用初期値で初期化

#### Step 3: 基盤クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SHA512Managed.cls | `Source/CorLib/System.Security.Cryptography/SHA512Managed.cls` | 実際の計算処理 |
| 3-2 | Statics.cls | `Source/CorLib/` | SHA384.StatePtr（初期値）の参照 |

### プログラム呼び出し階層図

```
SHA384Managed
    │
    └─ SHA512Managed (mBase)
           │
           ├─ Init(StatePtr)
           │      └─ SHA384用初期値で初期化
           │
           ├─ ComputeHash
           │      └─ 64バイトハッシュ計算
           │
           ├─ TransformBlock
           │      └─ 増分計算
           │
           └─ TransformFinalBlock
                  └─ 最終計算
                         ↓
              ┌─────────────────┐
              │ 48バイトに切り詰め │
              └─────────────────┘
```

### データフロー図

```
[入力]                    [処理]                         [出力]

                    ┌─────────────────┐
メッセージ ─────────▶│ SHA512Managed   │
                    │  (SHA384初期値) │
                    └────────┬────────┘
                             ▼
                    ┌─────────────────┐
                    │  64バイト結果    │
                    └────────┬────────┘
                             ▼
                    ┌─────────────────┐
                    │ ReDim Preserve  │──────▶ 48バイトハッシュ
                    │  (0 To 47)      │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SHA384Managed.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | メイン実装（ラッパー） |
| SHA384.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | インターフェース定義 |
| SHA512Managed.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 実際の計算処理 |
| HashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 基底インターフェース |
| Statics.cls | `Source/CorLib/` | ソース | SHA384初期値の提供 |
