# 機能設計書 58-SHA512Managed

## 概要

本ドキュメントは、VBCorLibライブラリにおけるSHA512Managed機能の設計仕様を記載する。本クラスはSHA-512（Secure Hash Algorithm 512-bit）ハッシュアルゴリズムのマネージド実装として、512ビットのハッシュ値計算機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：SHA-512はSHA-2ファミリーの最大ハッシュ長を持つ暗号学的ハッシュ関数である。任意長のメッセージを512ビット（64バイト）の固定長ダイジェストに変換する。最高レベルのセキュリティが要求される場面や、64ビットアーキテクチャでの効率的な処理が求められる場合に使用される。

**機能の利用シーン**：高セキュリティデジタル署名、HMAC-SHA512、パスワードハッシュ（PBKDF2等）、ファイル完整性検証、ブロックチェーンなどで利用される。

**主要な処理内容**：
1. バイト配列のSHA-512ハッシュ値計算
2. ストリームデータのSHA-512ハッシュ値計算
3. 増分ハッシュ計算（TransformBlock/TransformFinalBlock）
4. ハッシュ計算のリセット（Initialize）
5. SHA-384用の初期化（Init）

**関連システム・外部連携**：純粋なVisual Basic実装であり、外部ライブラリへの依存がない。ICryptoTransformインターフェースを実装し、CryptoStreamと連携可能。SHA384Managedの基盤実装としても使用される。

**権限による制御**：特別な権限制御は実装されていない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Simply VB Unit Runner | 主機能 | テストスイート内のSHA512テスト（SHA512ManagedTests等）の実行 |

## 機能種別

ハッシュ計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Source | Variant | Yes | ハッシュ対象データ（Byte配列またはStream） | - |
| Index | Variant | No | Byte配列の開始インデックス | 有効範囲内 |
| Count | Variant | No | 処理するバイト数 | 有効範囲内 |
| InputBuffer | Byte() | Yes | 増分計算用入力バッファ | - |
| InputOffset | Long | Yes | 入力開始位置 | - |
| InputCount | Long | Yes | 入力バイト数 | - |

### 入力データソース

- ユーザーが指定するバイト配列またはStreamオブジェクト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ComputeHash戻り値 | Byte() | 64バイトのハッシュ値 |
| Hash | Byte() | 計算済みハッシュ値プロパティ |
| HashSize | Long | 512（ビット単位） |

### 出力先

ハッシュ値を呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化
   └─ 内部状態の初期設定（8つの64ビットレジスタを32ビットペアで管理）
2. データ入力
   └─ ComputeHashまたはTransformBlock呼び出し
3. ブロック処理
   └─ 128バイトブロック単位でTransform実行
4. 最終処理
   └─ パディングとメッセージ長追加
5. ハッシュ値出力
   └─ 64バイトのダイジェスト返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Initialize]
    B --> C{入力タイプ?}
    C -->|Byte配列| D[配列からブロック抽出]
    C -->|Stream| E[ストリームから読み込み]
    D --> F{128バイト以上?}
    E --> F
    F -->|Yes| G[Transform実行]
    G --> F
    F -->|No| H[残りデータをバッファ]
    H --> I[パディング追加]
    I --> J[メッセージ長追加]
    J --> K[最終Transform]
    K --> L[状態からハッシュ生成]
    L --> M[64バイトハッシュ返却]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-58-01 | ハッシュサイズ固定 | 出力は常に512ビット（64バイト） | 常時 |
| BR-58-02 | 初期状態リセット | TransformFinalBlock後は自動的にInitialize | ハッシュ計算完了後 |
| BR-58-03 | ブロックサイズ | 内部処理は128バイトブロック単位 | 常時 |
| BR-58-04 | 64ビット演算 | 32ビットペア（High/Low）で64ビット演算をエミュレート | 常時 |

### 計算ロジック

- **初期ハッシュ値**（最初の8つの素数の平方根の小数部、64ビット）:
  - 8つの64ビット値を16個の32ビット値（mStateH/mStateL）で管理
  - 初期値はStatics.SHA512.StatePtrから取得

- **ラウンド定数K**:
  - 80個の64ビット定数（最初の80個の素数の立方根の小数部）
  - mKh/mKl配列で管理

- **メッセージスケジュール**:
  - 16ワード（各64ビット）を80ワードに拡張
  - sigma0、sigma1関数を使用

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidOperationException | TransformFinalBlock前にHashプロパティアクセス | TransformFinalBlockを先に呼び出す |
| - | ArgumentException | 無効なインデックスまたはカウント | 有効な範囲を指定する |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

- 64ビット演算を32ビットペアでエミュレートするため、ネイティブ64ビット実装より低速
- リリースビルドでは整数オーバーフローチェックを無効化して最適化
- 128バイトブロック、80ラウンドの処理

## セキュリティ考慮事項

- SHA-512は現時点で安全とされている
- 256ビットのセキュリティレベル（誕生日攻撃に対して）
- 量子コンピュータに対してはGroverのアルゴリズムで128ビット相当に低下

## 備考

- .NET Frameworkとの互換性を維持した実装
- HashAlgorithm、SHA512、ICryptoTransform、IHashAlgorithmインターフェースを実装
- SHA384ManagedからInit()で初期値を差し替えて再利用される
- VB6の32ビット制限のため、64ビット演算はHigh/Lowペアで実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SHA512.cls | `Source/CorLib/System.Security.Cryptography/SHA512.cls` | SHA512インターフェースの定義 |
| 1-2 | DLong型 | `Source/CorLib/System/` | 64ビット整数の32ビットペア表現 |

**読解のコツ**: 64ビット演算が32ビットのHigh/Lowペアで実装されていることを意識する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SHA512Managed.cls | `Source/CorLib/System.Security.Cryptography/SHA512Managed.cls` | メインの実装クラス |

**主要処理フロー**:
1. **52-59行目**: メンバ変数宣言 - mBase, mWh/mWl(0-79), mStateH/mStateL(0-7), mKh/mKl(0-79)
2. **143-151行目**: Initialize - 初期ハッシュ値をStaticsから読み込み
3. **136-138行目**: ComputeHash - ハッシュ計算のエントリーポイント
4. **244-275行目**: HashFinal - パディングと最終ブロック処理
5. **279-445行目**: Transform(リリース版) - 80ラウンドの変換処理
6. **447-530行目**: Transform(デバッグ版) - 可読性重視の実装
7. **532-604行目**: 64ビット演算ヘルパー関数

#### Step 3: 64ビット演算を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SHA512Managed.cls | `Source/CorLib/System.Security.Cryptography/SHA512Managed.cls` | UAdd64, RRotateHi/Lo等 |

**主要ヘルパー関数**:
- **532-534行目**: UAdd64 - 64ビット加算
- **536-548行目**: RShiftHi/Lo - 64ビット右シフト
- **550-564行目**: RRotateHi/Lo - 64ビット右回転
- **566-572行目**: Choice/Maj - ブール関数
- **574-604行目**: BigSIG0/1, LilSig0/1 - SHA-512固有の関数

### プログラム呼び出し階層図

```
SHA512Managed
    │
    ├─ HashAlgorithmBase (mBase)
    │      ├─ ComputeHash (ストリーム/配列処理)
    │      ├─ TransformBlock (増分計算)
    │      ├─ TransformFinalBlock (最終計算)
    │      └─ Hash (結果取得)
    │
    ├─ Initialize
    │      ├─ mStateH/mStateL配列の初期化（8要素×2）
    │      └─ mKh/mKl定数の読み込み（80要素×2）
    │
    ├─ Transform (IHashAlgorithm_HashCore経由)
    │      ├─ メッセージスケジュール生成 (mWh/mWl拡張、80ワード)
    │      ├─ LilSig0/LilSig1関数
    │      ├─ BigSIG0/BigSIG1関数
    │      ├─ Choice/Majority関数
    │      └─ 80ラウンド圧縮関数
    │
    ├─ HashFinal (IHashAlgorithm_HashFinal経由)
    │      ├─ パディング追加
    │      ├─ メッセージ長追加
    │      └─ 最終ブロック処理
    │
    └─ Init (Friend)
           └─ SHA384用初期値での再初期化
```

### データフロー図

```
[入力]                    [処理]                         [出力]

                    ┌─────────────────┐
メッセージ ─────────▶│   Initialize    │
                    │ (状態初期化)    │
                    │ mStateH/mStateL │
                    └────────┬────────┘
                             ▼
                    ┌─────────────────┐
128バイトブロック ──▶│    Transform    │
(繰り返し)          │  (80ラウンド)   │
                    │ 64ビットペア演算│
                    └────────┬────────┘
                             ▼
                    ┌─────────────────┐
残りデータ ─────────▶│   HashFinal     │──────▶ 64バイトハッシュ
                    │ (パディング)    │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SHA512Managed.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | メイン実装 |
| SHA512.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | インターフェース定義 |
| SHA512Static.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 静的ファクトリメソッド |
| SHA384Managed.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | SHA384ラッパー（利用者） |
| HashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 基底インターフェース |
| HashAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 共通基盤実装 |
| IHashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | コールバックインターフェース |
| Statics.cls | `Source/CorLib/` | ソース | 初期値・定数テーブル |
| Helper.cls | `Source/CorLib/` | ソース | UAdd64等のヘルパー |
