# 機能設計書 59-MD5CryptoServiceProvider

## 概要

本ドキュメントは、VBCorLibライブラリにおけるMD5CryptoServiceProvider機能の設計仕様を記載する。本クラスはMD5（Message Digest Algorithm 5）ハッシュアルゴリズムのサービスプロバイダ実装として、Windows CryptoAPIを使用した128ビットのハッシュ値計算機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：MD5はRonald Rivestによって1991年に設計された暗号学的ハッシュ関数である。任意長のメッセージを128ビット（16バイト）の固定長ダイジェストに変換する。かつては広く使用されていたが、2004年以降衝突攻撃が実証されており、セキュリティ用途では使用が推奨されない。ただし、レガシーシステムとの互換性やチェックサム用途では依然として使用されている。

**機能の利用シーン**：レガシーシステムとの互換性維持、ファイルチェックサム計算、非セキュリティ用途でのデータ整合性確認などで利用される。

**主要な処理内容**：
1. バイト配列のMD5ハッシュ値計算
2. ストリームデータのMD5ハッシュ値計算
3. 増分ハッシュ計算（TransformBlock/TransformFinalBlock）
4. ハッシュ計算のリセット（Initialize）

**関連システム・外部連携**：Windows CryptoAPI（advapi32.dll）を使用してハッシュ処理を実行する。CALG_MD5アルゴリズムを指定してCryptoAPIHashを介して計算を行う。

**権限による制御**：特別な権限制御は実装されていない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Simply VB Unit Runner | 主機能 | テストスイート内のMD5テスト（MD5CryptoServiceProviderTests等）の実行 |

## 機能種別

ハッシュ計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Source | Variant | Yes | ハッシュ対象データ（Byte配列またはStream） | - |
| Index | Variant | No | Byte配列の開始インデックス | 有効範囲内 |
| Count | Variant | No | 処理するバイト数 | 有効範囲内 |
| InputBuffer | Byte() | Yes | 増分計算用入力バッファ | - |
| InputOffset | Long | Yes | 入力開始位置 | - |
| InputCount | Long | Yes | 入力バイト数 | - |

### 入力データソース

- ユーザーが指定するバイト配列またはStreamオブジェクト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ComputeHash戻り値 | Byte() | 16バイトのハッシュ値 |
| Hash | Byte() | 計算済みハッシュ値プロパティ |
| HashSize | Long | 128（ビット単位） |

### 出力先

ハッシュ値を呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化
   └─ CryptoAPIHashの初期化（CALG_MD5）
2. データ入力
   └─ ComputeHashまたはTransformBlock呼び出し
3. CryptoAPI呼び出し
   └─ CryptHashDataでデータを処理
4. 最終処理
   └─ CryptGetHashParamでハッシュ値取得
5. ハッシュ値出力
   └─ 16バイトのダイジェスト返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CryptoAPIHash初期化]
    B --> C[CALG_MD5アルゴリズム指定]
    C --> D{入力タイプ?}
    D -->|Byte配列| E[配列データ処理]
    D -->|Stream| F[ストリーム読み込み]
    E --> G[CryptHashData呼び出し]
    F --> G
    G --> H[CryptGetHashParam呼び出し]
    H --> I[16バイトハッシュ取得]
    I --> J[ハッシュ値返却]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-59-01 | ハッシュサイズ固定 | 出力は常に128ビット（16バイト） | 常時 |
| BR-59-02 | CryptoAPI依存 | Windows CryptoAPIを使用 | 常時 |
| BR-59-03 | 初期状態リセット | TransformFinalBlock後は自動的にInitialize | ハッシュ計算完了後 |

### 計算ロジック

- CryptoAPIのCALG_MD5アルゴリズムを使用
- 実際の計算はWindows OSのネイティブコードで実行

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidOperationException | TransformFinalBlock前にHashプロパティアクセス | TransformFinalBlockを先に呼び出す |
| - | CryptographicException | CryptoAPI呼び出し失敗 | システム環境を確認 |
| - | ArgumentException | 無効なインデックスまたはカウント | 有効な範囲を指定する |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

- Windows CryptoAPIを使用するため、ネイティブコードによる高速な処理
- マネージド実装（純粋VB6）より高速

## セキュリティ考慮事項

- MD5は衝突攻撃に対して脆弱（2004年以降実証済み）
- セキュリティ用途（デジタル署名、証明書など）では使用禁止
- パスワードハッシュ用途には使用禁止
- 非セキュリティ用途（チェックサム等）のみで使用可
- 新規システムではSHA-256以上を使用すべき

## 備考

- .NET Frameworkとの互換性を維持した実装
- HashAlgorithm、MD5、ICryptoTransformインターフェースを実装
- CanReuseTransform、CanTransformMultipleBlocksは常にTrue
- CryptoAPIHashを内部で使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MD5.cls | `Source/CorLib/System.Security.Cryptography/MD5.cls` | MD5インターフェースの定義 |
| 1-2 | HashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/HashAlgorithm.cls` | ハッシュアルゴリズム基底インターフェース |

**読解のコツ**: CryptoServiceProviderパターン（CryptoAPIを使用する実装）を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MD5CryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/MD5CryptoServiceProvider.cls` | メインの実装クラス |

**主要処理フロー**:
1. **47-48行目**: メンバ変数宣言 - mCore As IHashAlgorithm, mBase As HashAlgorithmBase
2. **85-87行目**: HashSize = 128
3. **124-126行目**: ComputeHash - ハッシュ計算のエントリーポイント
4. **131-133行目**: Initialize - CryptoAPIハッシュの初期化
5. **207-211行目**: Class_Initialize - CALG_MD5でCryptoAPIHash初期化

#### Step 3: CryptoAPI連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CryptoAPIHash.cls | `Source/CorLib/System.Security.Cryptography/CryptoAPIHash.cls` | CryptoAPIとの連携 |
| 3-2 | CryptoAPI.bas | `Source/CorLib/System.Security.Cryptography/` | CryptoAPI関数宣言 |

### プログラム呼び出し階層図

```
MD5CryptoServiceProvider
    │
    ├─ HashAlgorithmBase (mBase)
    │      ├─ ComputeHash (ストリーム/配列処理)
    │      ├─ TransformBlock (増分計算)
    │      ├─ TransformFinalBlock (最終計算)
    │      └─ Hash (結果取得)
    │
    └─ CryptoAPIHash (mCore via IHashAlgorithm)
           │
           ├─ Initialize
           │      └─ CryptCreateHash(CALG_MD5)
           │
           ├─ HashCore
           │      └─ CryptHashData
           │
           └─ HashFinal
                  └─ CryptGetHashParam(HP_HASHVAL)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

                    ┌─────────────────┐
                    │ Class_Initialize│
                    │ CALG_MD5指定    │
                    └────────┬────────┘
                             ▼
                    ┌─────────────────┐
メッセージ ─────────▶│ CryptHashData   │
(繰り返し可能)      │ (CryptoAPI)     │
                    └────────┬────────┘
                             ▼
                    ┌─────────────────┐
                    │CryptGetHashParam│──────▶ 16バイトハッシュ
                    │ (HP_HASHVAL)    │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MD5CryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | メイン実装 |
| MD5.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | インターフェース定義 |
| MD5Static.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 静的ファクトリメソッド |
| CryptoAPIHash.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | CryptoAPI連携 |
| HashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 基底インターフェース |
| HashAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 共通基盤実装 |
| CryptoAPI.bas | `Source/CorLib/System.Security.Cryptography/` | ソース | API宣言 |
