# 機能設計書 6-Guid

## 概要

本ドキュメントは、VBCorLibライブラリにおけるGUID機能（Guid）の設計を記述する。Guidクラスは、.NET Frameworkの`System.Guid`構造体に相当するグローバル一意識別子（Globally Unique Identifier）の生成・操作機能を提供するクラスである。

### 本機能の処理概要

Guidクラスは、128ビット（16バイト）の一意識別子を表現し、文字列・バイト配列との変換、比較、書式設定などの機能を提供する。

**業務上の目的・背景**：データベースの主キー、COM/OLEオブジェクトの識別、分散システムでの一意識別など、重複のない識別子が必要な場面は多い。Guidは.NET Frameworkと互換性のあるGUID操作をVB6/VBA環境で実現し、標準化されたAPIでGUIDを扱えるようにする。

**機能の利用シーン**：一意識別子を必要とする場面で利用される。具体的には、データベースレコードの識別子、COMオブジェクトのCLSID/IID、ファイルやセッションの識別、トランザクションID、メッセージIDなどの場面で活用される。

**主要な処理内容**：
1. GUID値の取得（Handle、ToByteArray）
2. 読み取り専用状態の確認（IsReadOnly）
3. 文字列への変換（ToString - D/B/P/N/X形式）
4. 比較（CompareTo、Equals）
5. ハッシュコード生成（GetHashCode）

**関連システム・外部連携**：Windows APIのIsEqualGUID関数を使用した比較、VB6のGUID構造体との相互運用を提供。

**権限による制御**：権限による制御は行わない。全てのメソッドは同一の動作を行う。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラスである |

## 機能種別

計算処理 / データ操作ユーティリティ / 識別子処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Value | String/Byte()/Long | Yes | GUID値（文字列、バイト配列、ポインタ） | 形式チェック |
| Format | String | No | 書式指定（D/B/P/N/X） | 1文字 |
| Provider | IFormatProvider | No | 書式プロバイダ | なし |

### 入力データソース

コンストラクタまたはGuidStaticのファクトリメソッド経由で作成されるインスタンス

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ハンドル | Long | Handleプロパティ（内部構造体へのポインタ） |
| 読み取り専用 | Boolean | IsReadOnlyプロパティ |
| バイト配列 | Byte() | ToByteArrayの戻り値（16バイト） |
| 比較結果 | Long | CompareToの戻り値（-1/0/1） |
| 等価判定 | Boolean | Equalsの戻り値 |
| 書式化文字列 | String | ToStringの戻り値 |
| ハッシュコード | Long | GetHashCodeの戻り値 |

### 出力先

呼び出し元への戻り値

## 処理フロー

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|文字列変換| C{書式指定}
    C -->|D| D1[00000000-0000-0000-0000-000000000000]
    C -->|B| D2[{00000000-0000-0000-0000-000000000000}]
    C -->|P| D3[(00000000-0000-0000-0000-000000000000)]
    C -->|N| D4[00000000000000000000000000000000]
    C -->|X| D5[{0x...,0x...,...}]
    B -->|比較| E[InternalCompare]
    B -->|バイト配列| F[CopyMemory]
    D1 --> G[終了]
    D2 --> G
    D3 --> G
    D4 --> G
    D5 --> G
    E --> G
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 不変オブジェクト | 初期化後は読み取り専用 | mIsReadOnly = True |
| BR-02 | デフォルト書式 | 書式未指定時は"D"形式 | ToString |
| BR-03 | 比較順序 | Data1→Data2→Data3→Data4の順で比較 | CompareTo |

### 計算ロジック

**GUID構造**
```
Data1: 4バイト (Long)
Data2: 2バイト (Integer)
Data3: 2バイト (Integer)
Data4: 8バイト (Byte配列)
合計: 16バイト
```

**書式形式**
- D: `00000000-0000-0000-0000-000000000000`
- B: `{00000000-0000-0000-0000-000000000000}`
- P: `(00000000-0000-0000-0000-000000000000)`
- N: `00000000000000000000000000000000`
- X: `{0x00000000,0x0000,0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}`

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FormatException | 書式エラー | 無効な書式指定 | D/B/P/N/Xを使用 |
| ArgumentException | 引数エラー | 無効なGUID文字列 | 正しい形式を使用 |
| ArgumentException | 引数エラー | バイト配列が16バイトでない | 16バイトの配列を使用 |
| ArgumentException | 引数エラー | CompareToでGuid以外が渡された | Guidを渡す |

## 備考

- VB6の隠しGuid型と名前が競合するため、CorLib.Guidとして参照推奨
- IObject、IComparable、IFormattableインターフェースを実装
- 永続化可能（Persistable = 1）

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Guid.cls | `Source/CorLib/System/Guid.cls` | 80-83行目: 内部変数（mGuid、mIsReadOnly） |
| 1-2 | Guid.cls | `Source/CorLib/System/Guid.cls` | 95-102行目: Handleプロパティ |
| 1-3 | Guid.cls | `Source/CorLib/System/Guid.cls` | 118-123行目: ToByteArray |
| 1-4 | Guid.cls | `Source/CorLib/System/Guid.cls` | 131-146行目: CompareTo |
| 1-5 | Guid.cls | `Source/CorLib/System/Guid.cls` | 164-190行目: ToString |
| 1-6 | Guid.cls | `Source/CorLib/System/Guid.cls` | 198-206行目: Equals |
| 1-7 | Guid.cls | `Source/CorLib/System/Guid.cls` | 212-216行目: GetHashCode |
| 1-8 | Guid.cls | `Source/CorLib/System/Guid.cls` | 238-251行目: Init |
| 1-9 | Guid.cls | `Source/CorLib/System/Guid.cls` | 309-350行目: ToStandardString |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Guid.cls | `Source/CorLib/System/Guid.cls` | ソース | GUIDのメインクラス |
| GuidStatic.cls | `Source/CorLib/System/GuidStatic.cls` | ソース | GUIDの静的メソッド |
| GuidParser.cls | `Source/CorLib/System/GuidParser.cls` | ソース | GUID文字列パーサー |
