# 機能設計書 60-RIPEMD160Managed

## 概要

本ドキュメントは、VBCorLibライブラリにおけるRIPEMD160Managed機能の設計仕様を記載する。本クラスはRIPEMD-160（RACE Integrity Primitives Evaluation Message Digest）ハッシュアルゴリズムのマネージド実装として、160ビットのハッシュ値計算機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：RIPEMD-160は1996年にベルギーのKatholieke Universiteit Leuvenで開発された暗号学的ハッシュ関数である。任意長のメッセージを160ビット（20バイト）の固定長ダイジェストに変換する。MD4/MD5とは異なる設計思想で開発され、特にヨーロッパで広く使用されてきた。Bitcoinのアドレス生成（SHA-256と組み合わせ）でも使用される。

**機能の利用シーン**：暗号通貨アドレス生成、PGP/OpenPGPフィンガープリント、レガシーシステムとの互換性維持などで利用される。

**主要な処理内容**：
1. バイト配列のRIPEMD-160ハッシュ値計算
2. ストリームデータのRIPEMD-160ハッシュ値計算
3. 増分ハッシュ計算（TransformBlock/TransformFinalBlock）
4. ハッシュ計算のリセット（Initialize）

**関連システム・外部連携**：純粋なVisual Basic実装であり、外部ライブラリへの依存がない。ICryptoTransformインターフェースを実装し、CryptoStreamと連携可能。

**権限による制御**：特別な権限制御は実装されていない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Simply VB Unit Runner | 主機能 | テストスイート内のRIPEMD160テスト（RIPEMD160ManagedTests等）の実行 |

## 機能種別

ハッシュ計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Source | Variant | Yes | ハッシュ対象データ（Byte配列またはStream） | - |
| Index | Variant | No | Byte配列の開始インデックス | 有効範囲内 |
| Count | Variant | No | 処理するバイト数 | 有効範囲内 |
| InputBuffer | Byte() | Yes | 増分計算用入力バッファ | - |
| InputOffset | Long | Yes | 入力開始位置 | - |
| InputCount | Long | Yes | 入力バイト数 | - |

### 入力データソース

- ユーザーが指定するバイト配列またはStreamオブジェクト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ComputeHash戻り値 | Byte() | 20バイトのハッシュ値 |
| Hash | Byte() | 計算済みハッシュ値プロパティ |
| HashSize | Long | 160（ビット単位） |

### 出力先

ハッシュ値を呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化
   └─ 内部状態の初期設定（5つの32ビットレジスタ）
2. データ入力
   └─ ComputeHashまたはTransformBlock呼び出し
3. ブロック処理
   └─ 64バイトブロック単位でTransform実行（左右並列処理）
4. 最終処理
   └─ パディングとメッセージ長追加
5. ハッシュ値出力
   └─ 20バイトのダイジェスト返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Initialize]
    B --> C{入力タイプ?}
    C -->|Byte配列| D[配列からブロック抽出]
    C -->|Stream| E[ストリームから読み込み]
    D --> F{64バイト以上?}
    E --> F
    F -->|Yes| G[Transform実行-左右並列]
    G --> F
    F -->|No| H[残りデータをバッファ]
    H --> I[パディング追加]
    I --> J[メッセージ長追加]
    J --> K[最終Transform]
    K --> L[左右の結果を結合]
    L --> M[20バイトハッシュ返却]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-60-01 | ハッシュサイズ固定 | 出力は常に160ビット（20バイト） | 常時 |
| BR-60-02 | 並列構造 | 左右2つの独立した処理パスを持つ | 常時 |
| BR-60-03 | ブロックサイズ | 内部処理は64バイトブロック単位 | 常時 |
| BR-60-04 | リトルエンディアン | 出力はリトルエンディアン形式 | ハッシュ出力時 |

### 計算ロジック

- **初期ハッシュ値**（MD4/MD5と同じ）:
  - H0 = 0x67452301
  - H1 = 0xEFCDAB89
  - H2 = 0x98BADCFE
  - H3 = 0x10325476
  - H4 = 0xC3D2E1F0

- **並列処理構造**:
  - 左側（L）: aa, bb, cc, dd, ee
  - 右側（R）: aaa, bbb, ccc, ddd, eee
  - 各80ラウンド（16ラウンド×5グループ）

- **ブール関数（5種類）**:
  - FF: x XOR y XOR z
  - GG: (x AND y) OR ((NOT x) AND z)
  - HH: (x OR (NOT y)) XOR z
  - II: (x AND z) OR (y AND (NOT z))
  - JJ: x XOR (y OR (NOT z))

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidOperationException | TransformFinalBlock前にHashプロパティアクセス | TransformFinalBlockを先に呼び出す |
| - | ArgumentException | 無効なインデックスまたはカウント | 有効な範囲を指定する |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

- 純粋なVisual Basic実装のため、CryptoAPI版より低速
- リリースビルドでは整数オーバーフローチェックを無効化して最適化
- 並列処理構造のため、SHA-1より若干計算量が多い

## セキュリティ考慮事項

- RIPEMD-160は現時点で実用上安全とされている
- ただし、SHA-256等と比較すると研究が少なく、長期的な安全性は不確定
- 新規システムではSHA-256以上の使用を推奨
- Bitcoinでは二重ハッシュ（SHA-256 + RIPEMD-160）で使用

## 備考

- .NET Frameworkとの互換性を維持した実装
- HashAlgorithm、RIPEMD160、ICryptoTransform、IHashAlgorithmインターフェースを実装
- CanReuseTransform、CanTransformMultipleBlocksは常にTrue
- 左右並列処理という独自の設計が特徴

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RIPEMD160.cls | `Source/CorLib/System.Security.Cryptography/RIPEMD160.cls` | RIPEMD160インターフェースの定義 |
| 1-2 | HashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/HashAlgorithm.cls` | ハッシュアルゴリズム基底インターフェース |

**読解のコツ**: RIPEMD-160の並列処理構造（左側aa-ee、右側aaa-eee）を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RIPEMD160Managed.cls | `Source/CorLib/System.Security.Cryptography/RIPEMD160Managed.cls` | メインの実装クラス |

**主要処理フロー**:
1. **50-52行目**: メンバ変数宣言 - mBase, mState(0-4), mX(0-15)
2. **136-144行目**: Initialize - 初期ハッシュ値設定（5つの32ビット値）
3. **129-131行目**: ComputeHash - ハッシュ計算のエントリーポイント
4. **217-237行目**: HashFinal - パディングと最終ブロック処理
5. **241行目以降**: Transform - 並列処理構造（左側/右側各80ラウンド）

#### Step 3: 並列処理構造を理解する

Transform関数内の構造:
- **左側処理（aa, bb, cc, dd, ee）**: fnFF, fnGG, fnHH, fnII, fnJJ順
- **右側処理（aaa, bbb, ccc, ddd, eee）**: fnJJJ, fnIII, fnHHH, fnGGG, fnFFF順
- **最終結合**: 左右の結果を特殊な方法で結合

### プログラム呼び出し階層図

```
RIPEMD160Managed
    │
    ├─ HashAlgorithmBase (mBase)
    │      ├─ ComputeHash (ストリーム/配列処理)
    │      ├─ TransformBlock (増分計算)
    │      ├─ TransformFinalBlock (最終計算)
    │      └─ Hash (結果取得)
    │
    ├─ Initialize
    │      └─ mState配列の初期化（5要素）
    │
    ├─ Transform (IHashAlgorithm_HashCore経由)
    │      │
    │      ├─ 左側処理 (aa, bb, cc, dd, ee)
    │      │      ├─ fnFF (16ラウンド)
    │      │      ├─ fnGG (16ラウンド)
    │      │      ├─ fnHH (16ラウンド)
    │      │      ├─ fnII (16ラウンド)
    │      │      └─ fnJJ (16ラウンド)
    │      │
    │      ├─ 右側処理 (aaa, bbb, ccc, ddd, eee)
    │      │      ├─ fnJJJ (16ラウンド)
    │      │      ├─ fnIII (16ラウンド)
    │      │      ├─ fnHHH (16ラウンド)
    │      │      ├─ fnGGG (16ラウンド)
    │      │      └─ fnFFF (16ラウンド)
    │      │
    │      └─ 左右結合
    │
    └─ HashFinal (IHashAlgorithm_HashFinal経由)
           ├─ パディング追加
           ├─ メッセージ長追加
           └─ 最終ブロック処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

                    ┌─────────────────┐
メッセージ ─────────▶│   Initialize    │
                    │  (状態初期化)   │
                    └────────┬────────┘
                             ▼
              ┌──────────────┴──────────────┐
              │         Transform            │
              │  ┌────────┐    ┌────────┐   │
64バイト     │  │  左側  │    │  右側  │   │
ブロック ────▶│  │ 80round│    │ 80round│   │
(繰り返し)    │  └────┬───┘    └────┬───┘   │
              │       └──────┬──────┘       │
              │              ▼              │
              │         左右結合            │
              └──────────────┬──────────────┘
                             ▼
                    ┌─────────────────┐
残りデータ ─────────▶│   HashFinal     │──────▶ 20バイトハッシュ
                    │ (パディング)    │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RIPEMD160Managed.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | メイン実装 |
| RIPEMD160.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | インターフェース定義 |
| RIPEMD160Static.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 静的ファクトリメソッド |
| HashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 基底インターフェース |
| HashAlgorithmBase.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | 共通基盤実装 |
| IHashAlgorithm.cls | `Source/CorLib/System.Security.Cryptography/` | ソース | コールバックインターフェース |
