# 機能設計書 65-HMACMD5

## 概要

本ドキュメントは、VBCorLibライブラリにおけるHMACMD5クラスの機能設計を記述する。HMACMD5は、MD5ハッシュアルゴリズムを使用したHash-based Message Authentication Code（HMAC）の実装を提供するクラスである。

### 本機能の処理概要

HMACMD5クラスは、メッセージの認証と完全性検証のための暗号学的ハッシュ関数を提供する。秘密鍵とメッセージを組み合わせて固定長のハッシュ値（128ビット/16バイト）を生成する。MD5自体には脆弱性があるが、HMACとして使用する場合は鍵の秘匿性により一定のセキュリティを維持できる。

**業務上の目的・背景**：レガシーシステムとの互換性維持や、既存プロトコルとの相互運用が必要な場合に使用される。新規開発ではHMACSHA256以上の使用が推奨されるが、特定のレガシープロトコルではHMACMD5が要求される場合がある。

**機能の利用シーン**：
- レガシーシステムとの互換性維持
- CHAP（Challenge Handshake Authentication Protocol）認証
- 一部のVPNプロトコル
- 旧式のデータ検証システム
- 低リソース環境での高速ハッシュ

**主要な処理内容**：
1. 秘密鍵の設定と内部パディング処理（ipad/opad生成）
2. 入力データのブロック単位での処理（TransformBlock）
3. 最終ブロックの処理とハッシュ値の算出（TransformFinalBlock）
4. バイト配列またはストリームからの一括ハッシュ計算（ComputeHash）

**関連システム・外部連携**：
- MD5CryptoServiceProvider: 内部で使用するハッシュアルゴリズム
- HMACBase: HMAC処理の基盤クラス
- CryptoStream: ストリーム暗号化との連携

**権限による制御**：特になし。Windowsの暗号化サービスプロバイダー（CSP）へのアクセスが必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに記載なし |

## 機能種別

計算処理 / 暗号化処理 / データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Key | Byte() | No | HMAC計算に使用する秘密鍵 | Nullの場合は64バイトのランダム鍵を自動生成 |
| Source | Variant | Yes | ハッシュ計算対象（Byte配列またはStream） | Byte配列またはStreamオブジェクトであること |
| Index | Long | No | Byte配列の開始インデックス | 0以上かつ配列範囲内 |
| Count | Long | No | 処理するバイト数 | 0以上かつ配列範囲内 |

### 入力データソース

- アプリケーションから直接渡されるバイト配列
- Streamインターフェースを実装したオブジェクト（FileStream、MemoryStreamなど）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Hash | Byte()(16バイト) | 計算されたHMAC-MD5ハッシュ値（128ビット） |
| HashSize | Long | ハッシュサイズ（常に128ビット） |
| TransformBlock戻り値 | Long | 処理されたバイト数 |
| TransformFinalBlock戻り値 | Byte() | 処理された入力データのコピー |

### 出力先

- 呼び出し元アプリケーションへの戻り値として返却
- OutputBufferパラメータへのデータコピー（TransformBlock使用時）

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化（Class_Initialize）
   └─ HMACBaseオブジェクトをMD5CryptoServiceProviderで初期化（ブロックサイズ64バイト）

2. 鍵の設定（Key Letプロパティ / Init）
   └─ 鍵を設定し、必要に応じてパディングまたはハッシュ化

3. ハッシュ計算開始（StartHash - HMACBase内部）
   └─ 鍵をipad（0x36でXOR）とopad（0x5CでXOR）で拡張
   └─ ipadを最初にハッシュ処理

4. データ処理（TransformBlock / ComputeHash）
   └─ 入力データをブロック単位で処理
   └─ 内部MD5アルゴリズムにデータを渡す

5. 最終処理（TransformFinalBlock / EndHash）
   └─ 残りのデータを処理
   └─ opadと中間ハッシュを結合して最終ハッシュを計算

6. ハッシュ取得（Hash Get）
   └─ 16バイトのハッシュ値を返却
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-65-01 | 鍵長正規化 | 64バイト未満の鍵はゼロパディング、64バイト超の鍵はMD5でハッシュ化して64バイトに | 鍵設定時 |
| BR-65-02 | 自動鍵生成 | 鍵が未設定の場合、64バイトのランダム鍵を生成 | GetKeyまたはハッシュ計算開始時 |
| BR-65-03 | ハッシュ開始後の鍵変更禁止 | ハッシュ計算開始後は鍵を変更できない | Key設定時にmHashStartedがTrueの場合 |
| BR-65-04 | 再利用可能 | CanReuseTransformは常にTrue | - |

### 計算ロジック

**HMAC-MD5アルゴリズム（RFC 2104準拠）**:
```
HMAC(K, M) = MD5((K XOR opad) || MD5((K XOR ipad) || M))

ここで:
- K: 秘密鍵（64バイトに正規化）
- M: メッセージ
- ipad: 0x36を64回繰り返したバイト列
- opad: 0x5Cを64回繰り返したバイト列
- ||: 連結演算子
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CryptographicException | 暗号例外 | ハッシュ開始後に鍵を変更しようとした場合 | Initializeを呼び出してリセット後に鍵を設定 |
| ArgumentNullException | 引数Null例外 | 鍵にNull配列を設定した場合 | 有効なByte配列を渡す |
| InvalidOperationException | 無効操作例外 | TransformFinalBlock前にHashプロパティにアクセス | TransformFinalBlockを先に呼び出す |
| ObjectDisposedException | 破棄済み例外 | Clear後にメソッドを呼び出した場合 | 新しいインスタンスを作成 |

### リトライ仕様

エラー発生時のリトライは行わない。

## トランザクション仕様

本機能はトランザクション管理を行わない（メモリ内処理のみ）。

## パフォーマンス要件

- MD5は最も高速なハッシュアルゴリズムの1つ
- 128ビットの短いハッシュ長により、メモリ効率が良い
- CSPベースの実装によりハードウェアアクセラレーションの恩恵を受ける可能性

## セキュリティ考慮事項

- **警告**: MD5には既知の脆弱性があり、新規開発での使用は非推奨
- HMACとして使用する場合でも、SHA-256以上の使用を強く推奨
- レガシーシステムとの互換性が必須の場合のみ使用
- 秘密鍵は安全に管理し、ログ出力や永続化を避ける
- Clear()メソッドで使用後に鍵情報を消去する

## 備考

- .NET FrameworkのSystem.Security.Cryptography.HMACMD5クラスと互換性のあるAPI設計
- RFC 2104（HMAC）およびRFC 1321（MD5）に準拠
- MD5CryptoServiceProviderを使用（CSPベース実装）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: HMACMD5クラスの構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HMACMD5.cls | `Source/CorLib/System.Security.Cryptography/HMACMD5.cls` | メインクラスの構造 |

**主要処理フロー**:
1. **247-249行目**: Class_Initialize - HMACBaseをMD5CryptoServiceProviderで初期化、ブロックサイズ64バイト
2. **251-253行目**: Init - 鍵の初期化
3. **126-128行目**: HashSize = 128 - MD5の出力サイズ
4. **166-168行目**: ComputeHash - 一括ハッシュ計算の委譲

#### Step 2: 依存コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MD5CryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/MD5CryptoServiceProvider.cls` | CSPベースのMD5実装 |
| 2-2 | HMACBase.cls | `Source/CorLib/System.Security.Cryptography/HMACBase.cls` | HMAC処理基盤 |

### プログラム呼び出し階層図

```
HMACMD5
    │
    ├─ HMACBase
    │      ├─ SetKey() → 鍵のバリデーションと保存
    │      ├─ ExpandKey() → ipad/opad生成（64バイト）
    │      │      └─ MD5.ComputeHash() [鍵が64バイト超の場合]
    │      └─ (以下、他のHMACクラスと同様)
    │
    └─ MD5CryptoServiceProvider
           └─ CryptoAPI (Windows暗号化サービス)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HMACMD5.cls | `Source/CorLib/System.Security.Cryptography/HMACMD5.cls` | ソース | メインクラス |
| HMACBase.cls | `Source/CorLib/System.Security.Cryptography/HMACBase.cls` | ソース | HMAC処理基盤 |
| MD5CryptoServiceProvider.cls | `Source/CorLib/System.Security.Cryptography/MD5CryptoServiceProvider.cls` | ソース | CSPベースMD5実装 |
| HMAC.cls | `Source/CorLib/System.Security.Cryptography/HMAC.cls` | ソース | HMACインターフェース |
