# 機能設計書 66-HMACRIPEMD160

## 概要

本ドキュメントは、VBCorLibライブラリにおけるHMACRIPEMD160クラスの機能設計を記述する。HMACRIPEMD160は、RIPEMD-160ハッシュアルゴリズムを使用したHash-based Message Authentication Code（HMAC）の実装を提供するクラスである。

### 本機能の処理概要

HMACRIPEMD160クラスは、メッセージの認証と完全性検証のための暗号学的ハッシュ関数を提供する。秘密鍵とメッセージを組み合わせて固定長のハッシュ値（160ビット/20バイト）を生成する。RIPEMD-160は、欧州で開発されたハッシュ関数で、特にビットコインのアドレス生成などで使用されている。

**業務上の目的・背景**：RIPEMD-160はSHA-1と同じ160ビットのハッシュ長を持つが、異なる設計原理に基づいている。特定のプロトコルやシステムでRIPEMD-160が指定されている場合に使用される。

**機能の利用シーン**：
- 暗号通貨（ビットコインアドレス生成等）
- PGP/GPGキーフィンガープリント
- 特定の欧州システムとの互換性
- SHA-1に代わる代替ハッシュ

**主要な処理内容**：
1. 秘密鍵の設定と内部パディング処理（ipad/opad生成）
2. 入力データのブロック単位での処理（TransformBlock）
3. 最終ブロックの処理とハッシュ値の算出（TransformFinalBlock）
4. バイト配列またはストリームからの一括ハッシュ計算（ComputeHash）

**関連システム・外部連携**：
- RIPEMD160Managed: 内部で使用するハッシュアルゴリズム（マネージド実装）
- HMACBase: HMAC処理の基盤クラス
- CryptoStream: ストリーム暗号化との連携

**権限による制御**：特になし。マネージド実装のみ使用するため、CSPへのアクセスは不要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに記載なし |

## 機能種別

計算処理 / 暗号化処理 / データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Key | Byte() | No | HMAC計算に使用する秘密鍵 | Nullの場合は64バイトのランダム鍵を自動生成 |
| Source | Variant | Yes | ハッシュ計算対象（Byte配列またはStream） | Byte配列またはStreamオブジェクトであること |
| Index | Long | No | Byte配列の開始インデックス | 0以上かつ配列範囲内 |
| Count | Long | No | 処理するバイト数 | 0以上かつ配列範囲内 |

### 入力データソース

- アプリケーションから直接渡されるバイト配列
- Streamインターフェースを実装したオブジェクト（FileStream、MemoryStreamなど）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Hash | Byte()(20バイト) | 計算されたHMAC-RIPEMD160ハッシュ値（160ビット） |
| HashSize | Long | ハッシュサイズ（常に160ビット） |
| TransformBlock戻り値 | Long | 処理されたバイト数 |
| TransformFinalBlock戻り値 | Byte() | 処理された入力データのコピー |

### 出力先

- 呼び出し元アプリケーションへの戻り値として返却
- OutputBufferパラメータへのデータコピー（TransformBlock使用時）

## 処理フロー

### 処理シーケンス

```
1. インスタンス初期化（Class_Initialize）
   └─ HMACBaseオブジェクトをRIPEMD160Managedで初期化（ブロックサイズ64バイト）

2. 鍵の設定（Key Letプロパティ / Init）
   └─ 鍵を設定し、必要に応じてパディングまたはハッシュ化

3. ハッシュ計算開始（StartHash - HMACBase内部）
   └─ 鍵をipad（0x36でXOR）とopad（0x5CでXOR）で拡張
   └─ ipadを最初にハッシュ処理

4. データ処理（TransformBlock / ComputeHash）
   └─ 入力データをブロック単位で処理
   └─ 内部RIPEMD160アルゴリズムにデータを渡す

5. 最終処理（TransformFinalBlock / EndHash）
   └─ 残りのデータを処理
   └─ opadと中間ハッシュを結合して最終ハッシュを計算

6. ハッシュ取得（Hash Get）
   └─ 20バイトのハッシュ値を返却
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-66-01 | 鍵長正規化 | 64バイト未満の鍵はゼロパディング、64バイト超の鍵はRIPEMD160でハッシュ化して64バイトに | 鍵設定時 |
| BR-66-02 | 自動鍵生成 | 鍵が未設定の場合、64バイトのランダム鍵を生成 | GetKeyまたはハッシュ計算開始時 |
| BR-66-03 | ハッシュ開始後の鍵変更禁止 | ハッシュ計算開始後は鍵を変更できない | Key設定時にmHashStartedがTrueの場合 |
| BR-66-04 | 再利用可能 | CanReuseTransformは常にTrue | - |

### 計算ロジック

**HMAC-RIPEMD160アルゴリズム（RFC 2104準拠）**:
```
HMAC(K, M) = RIPEMD160((K XOR opad) || RIPEMD160((K XOR ipad) || M))

ここで:
- K: 秘密鍵（64バイトに正規化）
- M: メッセージ
- ipad: 0x36を64回繰り返したバイト列
- opad: 0x5Cを64回繰り返したバイト列
- ||: 連結演算子
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CryptographicException | 暗号例外 | ハッシュ開始後に鍵を変更しようとした場合 | Initializeを呼び出してリセット後に鍵を設定 |
| ArgumentNullException | 引数Null例外 | 鍵にNull配列を設定した場合 | 有効なByte配列を渡す |
| InvalidOperationException | 無効操作例外 | TransformFinalBlock前にHashプロパティにアクセス | TransformFinalBlockを先に呼び出す |
| ObjectDisposedException | 破棄済み例外 | Clear後にメソッドを呼び出した場合 | 新しいインスタンスを作成 |

### リトライ仕様

エラー発生時のリトライは行わない。

## トランザクション仕様

本機能はトランザクション管理を行わない（メモリ内処理のみ）。

## パフォーマンス要件

- マネージド実装のため、CSPベースの実装より若干遅い可能性
- 160ビットの短いハッシュ長により、メモリ効率が良い
- SHA-1と同等のパフォーマンス特性

## セキュリティ考慮事項

- RIPEMD-160は現在も安全なハッシュアルゴリズムと考えられている
- ただし、160ビットのハッシュ長は将来的には不十分になる可能性
- 新規開発では256ビット以上のハッシュアルゴリズムを推奨
- 秘密鍵は安全に管理し、ログ出力や永続化を避ける
- Clear()メソッドで使用後に鍵情報を消去する

## 備考

- .NET FrameworkのSystem.Security.Cryptography.HMACRIPEMD160クラスと互換性のあるAPI設計
- RFC 2104（HMAC）に準拠
- RIPEMD160Managedを使用（マネージド実装）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: HMACRIPEMD160クラスの構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HMACRIPEMD160.cls | `Source/CorLib/System.Security.Cryptography/HMACRIPEMD160.cls` | メインクラスの構造 |

**主要処理フロー**:
1. **247-249行目**: Class_Initialize - HMACBaseをRIPEMD160Managedで初期化、ブロックサイズ64バイト
2. **251-253行目**: Init - 鍵の初期化
3. **126-128行目**: HashSize = 160 - RIPEMD160の出力サイズ
4. **166-168行目**: ComputeHash - 一括ハッシュ計算の委譲

#### Step 2: 依存コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RIPEMD160Managed.cls | `Source/CorLib/System.Security.Cryptography/RIPEMD160Managed.cls` | マネージドRIPEMD160実装 |
| 2-2 | HMACBase.cls | `Source/CorLib/System.Security.Cryptography/HMACBase.cls` | HMAC処理基盤 |

### プログラム呼び出し階層図

```
HMACRIPEMD160
    │
    ├─ HMACBase
    │      ├─ SetKey() → 鍵のバリデーションと保存
    │      ├─ ExpandKey() → ipad/opad生成（64バイト）
    │      │      └─ RIPEMD160.ComputeHash() [鍵が64バイト超の場合]
    │      └─ (以下、他のHMACクラスと同様)
    │
    └─ RIPEMD160Managed
           └─ マネージドRIPEMD-160実装
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HMACRIPEMD160.cls | `Source/CorLib/System.Security.Cryptography/HMACRIPEMD160.cls` | ソース | メインクラス |
| HMACBase.cls | `Source/CorLib/System.Security.Cryptography/HMACBase.cls` | ソース | HMAC処理基盤 |
| RIPEMD160Managed.cls | `Source/CorLib/System.Security.Cryptography/RIPEMD160Managed.cls` | ソース | マネージドRIPEMD160実装 |
| HMAC.cls | `Source/CorLib/System.Security.Cryptography/HMAC.cls` | ソース | HMACインターフェース |
