# 機能設計書 7-Version

## 概要

本ドキュメントは、VBCorLibライブラリにおけるバージョン番号機能（Version）の設計を記述する。Versionクラスは、.NET Frameworkの`System.Version`クラスに相当するバージョン番号（Major.Minor.Build.Revision）の表現・比較機能を提供するクラスである。

### 本機能の処理概要

Versionクラスは、ソフトウェアのバージョン番号を`Major.Minor[.Build[.Revision]]`の形式で表現し、バージョン間の比較、文字列変換などの機能を提供する。

**業務上の目的・背景**：ソフトウェアのバージョン管理、依存関係の検証、互換性チェックなど、バージョン番号を扱う場面は多い。Versionは.NET Frameworkと互換性のあるバージョン番号操作をVB6/VBA環境で実現し、標準化されたAPIでバージョン比較を行えるようにする。

**機能の利用シーン**：バージョン番号の比較・管理を必要とする場面で利用される。具体的には、アプリケーションのバージョンチェック、ライブラリの互換性確認、アップデート判定、OSバージョンの判定（OperatingSystemクラスで使用）などの場面で活用される。

**主要な処理内容**：
1. バージョン要素の取得（Major、Minor、Build、Revision）
2. リビジョン詳細の取得（MajorRevision、MinorRevision）
3. バージョン比較（CompareTo、EqualTo、LessThan、GreaterThan等）
4. 文字列変換（ToString）
5. クローン生成（Clone）
6. ハッシュコード生成（GetHashCode）

**関連システム・外部連携**：OperatingSystemクラスでOSバージョンを表現するために使用される。

**権限による制御**：権限による制御は行わない。全てのメソッドは同一の動作を行う。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラスである |

## 機能種別

計算処理 / データ操作ユーティリティ / バージョン管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Major | Long | Yes | メジャーバージョン | 0以上 |
| Minor | Long | Yes | マイナーバージョン | 0以上 |
| Build | Long | No | ビルド番号 | 0以上（省略可） |
| Revision | Long | No | リビジョン番号 | 0以上（省略可、Buildが必要） |
| FieldCount | Long | No | ToString時の出力要素数 | 0-4 |

### 入力データソース

コンストラクタまたはVersionStaticのファクトリメソッド経由で作成されるインスタンス

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| メジャー | Long | Majorプロパティ |
| マイナー | Long | Minorプロパティ |
| ビルド | Long | Buildプロパティ（未定義時は-1） |
| リビジョン | Long | Revisionプロパティ（未定義時は-1） |
| メジャーリビジョン | Integer | MajorRevisionプロパティ（上位16ビット） |
| マイナーリビジョン | Integer | MinorRevisionプロパティ（下位16ビット） |
| 比較結果 | Long | CompareToの戻り値（-1/0/1） |
| 比較結果 | Boolean | EqualTo/LessThan/GreaterThan等の戻り値 |
| 書式化文字列 | String | ToStringの戻り値 |
| クローン | Version | Cloneの戻り値 |

### 出力先

呼び出し元への戻り値

## 処理フロー

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|比較| C[CompareTo]
    C --> D{Major比較}
    D -->|異なる| E[結果返却]
    D -->|同じ| F{Minor比較}
    F -->|異なる| E
    F -->|同じ| G{Build比較}
    G -->|異なる| E
    G -->|同じ| H{Revision比較}
    H --> E
    B -->|文字列変換| I[FieldCount判定]
    I --> J[要素を連結]
    J --> K[文字列返却]
    E --> L[終了]
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 未定義コンポーネント | Build/Revisionは省略可能（-1で表現） | コンストラクタ |
| BR-02 | 依存関係 | RevisionにはBuildが必要 | コンストラクタ |
| BR-03 | 比較優先順位 | Major→Minor→Build→Revisionの順で比較 | CompareTo |
| BR-04 | 未定義は古い | 未定義コンポーネントは定義済みより古い | CompareTo |

### 計算ロジック

**バージョン形式**
```
Major.Minor           (最小形式)
Major.Minor.Build
Major.Minor.Build.Revision (完全形式)
```

**比較ロジック**
1. Majorを比較
2. 同じ場合、Minorを比較
3. 同じ場合、Buildを比較
4. 同じ場合、Revisionを比較
5. 未定義(-1)は定義済み値より小さいとみなす

**MaxFieldCountの決定**
- Build未定義: 2
- Revision未定義: 3
- 全て定義: 4

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentOutOfRangeException | 範囲エラー | Major/Minor/Build/Revisionが負 | 0以上の値を使用 |
| ArgumentException | 引数エラー | Revision指定時にBuild未指定 | Buildも指定する |
| ArgumentException | 引数エラー | FieldCountが不正 | 0-MaxFieldCountの範囲を指定 |

## 備考

- IObject、ICloneable、IComparableインターフェースを実装
- 永続化可能（Persistable = 1）
- OperatingSystem.Versionで使用される

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Version.cls | `Source/CorLib/System/Version.cls` | 54-63行目: 定数と内部変数 |
| 1-2 | Version.cls | `Source/CorLib/System/Version.cls` | 70-98行目: プロパティ（Major/Minor/Build/Revision） |
| 1-3 | Version.cls | `Source/CorLib/System/Version.cls` | 104-114行目: MajorRevision/MinorRevision |
| 1-4 | Version.cls | `Source/CorLib/System/Version.cls` | 120-123行目: Clone |
| 1-5 | Version.cls | `Source/CorLib/System/Version.cls` | 157-167行目: CompareTo |
| 1-6 | Version.cls | `Source/CorLib/System/Version.cls` | 211-236行目: ToString |
| 1-7 | Version.cls | `Source/CorLib/System/Version.cls` | 259-265行目: GetHashCode |
| 1-8 | Version.cls | `Source/CorLib/System/Version.cls` | 272-319行目: 比較メソッド群 |
| 1-9 | Version.cls | `Source/CorLib/System/Version.cls` | 330-357行目: Init |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Version.cls | `Source/CorLib/System/Version.cls` | ソース | バージョンのメインクラス |
| VersionStatic.cls | `Source/CorLib/System/VersionStatic.cls` | ソース | バージョンの静的メソッド |
| OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | ソース | OSバージョンで使用 |
