# 機能設計書 73-CultureInfo

## 概要

本ドキュメントは、VBCorLibライブラリにおけるCultureInfoクラスの機能設計を記載する。CultureInfoは、カルチャ（言語、国・地域）に関する情報を提供し、数値や日付の書式設定、カレンダー情報へのアクセスを可能にするクラスである。

### 本機能の処理概要

CultureInfoは、特定のカルチャ（ロケール）に関する情報を表現するクラスである。言語コード、国・地域コード、日付時刻フォーマット、数値フォーマット、カレンダー情報など、国際化対応に必要な情報を一元管理する。IFormatProviderインターフェースを実装し、書式設定オブジェクトの取得を可能にする。

**業務上の目的・背景**：グローバルなアプリケーション開発において、各国・地域のユーザーに適切なフォーマットでデータを表示することは重要な要件である。日付表示（年月日の順序、区切り文字）、数値表示（小数点、桁区切り）、通貨表示は国・地域によって異なる。CultureInfoクラスは、これらの地域固有の設定を統一的に管理し、.NET Frameworkとの互換性を持つVB6実装を提供することで、既存資産の移植性を向上させる。

**機能の利用シーン**：多言語対応アプリケーションの開発、国際的なデータ交換システム、レポート出力における地域固有フォーマット適用、ユーザーインターフェースのローカライズなどで利用される。特にCorDateTimeやNumberFormatInfoと組み合わせることで、カルチャに応じた書式設定が実現できる。

**主要な処理内容**：
1. LCID（Locale ID）またはカルチャ名によるカルチャ情報のロード
2. 日付時刻フォーマット情報（DateTimeFormatInfo）の提供
3. 数値フォーマット情報（NumberFormatInfo）の提供
4. カレンダー情報（Calendar）の提供
5. カルチャの親子関係の管理（親カルチャの取得）
6. IFormatProviderインターフェースによる書式プロバイダ機能

**関連システム・外部連携**：CultureTableクラスを介してシステムのカルチャ情報を取得する。DateTimeFormatInfo、NumberFormatInfo、各種Calendarクラスと連携して書式設定機能を提供する。

**権限による制御**：特になし。ただし、ReadOnlyフラグにより変更不可のインスタンスを作成可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラス |

## 機能種別

データ提供処理（カルチャ情報管理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| NameOrLCID | Variant | Yes | カルチャ名（"en-US"等）またはLCID（数値） | 文字列または整数型であること |
| UseUserOverride | Boolean | No | ユーザー設定を使用するかどうか | デフォルトはTrue |

### 入力データソース

- CultureTableクラスからロードされるカルチャ定義データ
- Windows APIから取得されるシステムロケール情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| LCID | Long | ロケール識別子（32ビット） |
| Name | String | カルチャ名（RFC 1766形式：例 "en-US"） |
| EnglishName | String | 英語でのカルチャ名 |
| DisplayName | String | 表示用カルチャ名 |
| NativeName | String | ネイティブ言語でのカルチャ名 |
| ThreeLetterISOLanguageName | String | ISO 639-2 3文字言語コード |
| TwoLetterISOLanguageName | String | ISO 639-1 2文字言語コード |
| ThreeLetterWindowsLanguageName | String | Windows用3文字言語コード |
| IsNeutralCulture | Boolean | ニュートラルカルチャかどうか |
| IsReadOnly | Boolean | 読み取り専用かどうか |
| DateTimeFormat | DateTimeFormatInfo | 日付時刻書式情報 |
| NumberFormat | NumberFormatInfo | 数値書式情報 |
| Calendar | Calendar | デフォルトカレンダー |
| OptionalCalendars | Calendar() | オプションカレンダー配列 |
| Parent | CultureInfo | 親カルチャ |

### 出力先

プロパティを介してアプリケーションに提供される。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタによる初期化
   └─ NameOrLCIDからLCIDを解決
2. カルチャ情報のロード
   └─ CultureTableからプロパティを取得
3. 遅延ロード（必要時）
   ├─ DateTimeFormatInfoの生成
   ├─ NumberFormatInfoの生成
   └─ Calendarの生成
4. IFormatProvider.GetFormat呼び出し
   └─ 要求された型に応じたフォーマットオブジェクトを返却
```

### フローチャート

```mermaid
flowchart TD
    A[CultureInfo生成] --> B{NameOrLCIDの型}
    B -->|数値| C[LCIDとして使用]
    B -->|文字列| D[CultureTableでLCID検索]
    B -->|空文字列| E[INVARIANT_LCIDを使用]
    C --> F[CultureTable.GetStringでプロパティ取得]
    D --> F
    E --> G[デフォルト値をロード]
    F --> H[mLoaded = True]
    G --> H
    H --> I[プロパティアクセス]
    I --> J{DateTimeFormat要求?}
    J -->|Yes| K[DateTimeFormatInfo生成]
    J -->|No| L{NumberFormat要求?}
    L -->|Yes| M[NumberFormatInfo生成]
    L -->|No| N{Calendar要求?}
    N -->|Yes| O[Calendar生成]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ニュートラルカルチャ制限 | ニュートラルカルチャはフォーマット情報を提供できない | DateTimeFormat/NumberFormat取得時 |
| BR-02 | ReadOnlyカルチャ | ReadOnlyフラグが立っているカルチャは変更不可 | プロパティSet時 |
| BR-03 | Invariantカルチャ | LCID=127のInvariantカルチャはUserOverrideを使用しない | Invariantカルチャ生成時 |
| BR-04 | 遅延ロード | DateTimeFormat、NumberFormat、Calendarは初回アクセス時に生成 | プロパティGet時 |
| BR-05 | カルチャ継承 | 子カルチャは親カルチャの設定を継承可能 | Parent取得時 |
| BR-06 | カレンダーマッピング | カレンダータイプに応じた適切なCalendarクラスを生成 | Calendar取得時 |

### 計算ロジック

```
LCID構造（32ビット）:
- ビット0-9: プライマリ言語ID
- ビット10-15: サブ言語ID（6ビット）
- ビット16-19: ソートID（4ビット）
- ビット20-31: 予約（12ビット）

カレンダータイプマッピング:
- 1, 2, 9-12: GregorianCalendar（各種バリエーション）
- 3: JapaneseCalendar
- 4: TaiwanCalendar
- 5: KoreanCalendar
- 6: HijriCalendar
- 7: ThaiBuddhistCalendar
- 8: HebrewCalendar
- 13: JulianCalendar
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。CultureTableからのデータ取得はメモリ内操作である。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Argument | 引数エラー | 無効なカルチャ識別子 | 有効なLCIDまたはカルチャ名を指定 |
| ArgumentOutOfRange | 引数範囲外 | LCIDが負数 | 0以上のLCIDを指定 |
| NotSupported | 非サポート | ニュートラルカルチャでフォーマット情報を取得 | 特定カルチャ（en-US等）を使用 |
| InvalidOperation | 無効操作 | ReadOnlyカルチャを変更しようとした | Cloneで変更可能なコピーを作成 |
| ArgumentNull | Null引数 | DateTimeFormat/NumberFormatにNullを設定 | 有効なオブジェクトを指定 |

### リトライ仕様

カルチャ情報のロードは同期的に実行され、リトライ機構は不要。

## トランザクション仕様

本機能はトランザクション管理を必要としない。

## パフォーマンス要件

- カルチャ情報は初回ロード時にキャッシュされる
- InvariantCulture、CurrentCulture等はシングルトンとしてキャッシュ
- DateTimeFormatInfo、NumberFormatInfoは遅延ロード

## セキュリティ考慮事項

- ReadOnlyフラグにより、共有カルチャインスタンスの意図しない変更を防止
- システムカルチャ設定へのアクセスはWindows APIを介して行われる

## 備考

- .NET FrameworkのSystem.Globalization.CultureInfoクラスと互換性のある実装
- MITライセンスで提供（Copyright (c) 2015 Kelly Ethridge）
- PropertyBagを使用したシリアライズ/デシリアライズに対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、CultureInfoが保持するプロパティ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CultureInfo.cls | `Source/CorLib/System.Globalization/CultureInfo.cls` | PropsType構造体（行81-93）でカルチャプロパティを定義 |
| 1-2 | CultureInfo.cls | `Source/CorLib/System.Globalization/CultureInfo.cls` | カレンダー定数（行66-78）でサポートカレンダーを定義 |

**読解のコツ**: VB6のPrivate Typeによるプロパティ構造体パターンを理解すること。シリアライズ対応のためのPROP_*定数も重要。

#### Step 2: エントリーポイントを理解する

処理の起点となるコンストラクタとファクトリメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CultureInfo.cls | `Source/CorLib/System.Globalization/CultureInfo.cls` | Init関数（行421-448）でNameOrLCIDからの初期化処理 |
| 2-2 | CultureInfoStatic.cls | `Source/CorLib/System.Globalization/CultureInfoStatic.cls` | 静的メソッド群（CurrentCulture、InvariantCulture等） |

**主要処理フロー**:
1. **行424-437**: NameOrLCIDの型判定とLCID解決
2. **行439-443**: UseUserOverrideの設定
3. **行447**: Load関数呼び出し
4. **行472-490**: カルチャプロパティのロード

#### Step 3: プロパティ遅延ロードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CultureInfo.cls | `Source/CorLib/System.Globalization/CultureInfo.cls` | DateTimeFormatプロパティ（行349-358）の遅延初期化 |
| 3-2 | CultureInfo.cls | `Source/CorLib/System.Globalization/CultureInfo.cls` | NumberFormatプロパティ（行317-326）の遅延初期化 |
| 3-3 | CultureInfo.cls | `Source/CorLib/System.Globalization/CultureInfo.cls` | Calendarプロパティ（行108-114）の遅延初期化 |

**主要処理フロー**:
- **行318-319**: ニュートラルカルチャチェック
- **行321-324**: NumberFormatInfoの生成とCultureInfo関連付け
- **行506-528**: GetCalendar関数でカレンダータイプに応じたCalendar生成

#### Step 4: IFormatProvider実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CultureInfo.cls | `Source/CorLib/System.Globalization/CultureInfo.cls` | GetFormat関数（行303-309）による書式プロバイダ取得 |

**主要処理フロー**:
- **行304-305**: NumberFormatInfo要求時の処理
- **行306-308**: DateTimeFormatInfo要求時の処理

### プログラム呼び出し階層図

```
ユーザーコード / CorDateTime.ToString
    │
    ├─ Cor.NewCultureInfo(NameOrLCID, UseUserOverride)
    │      └─ Init(NameOrLCID, UseUserOverride)
    │             ├─ LCIDの解決
    │             └─ Load(LCID)
    │                    └─ CultureTable.GetString/GetNumber
    │
    ├─ CultureInfo.DateTimeFormat
    │      └─ New DateTimeFormatInfo
    │             └─ InitCultureInfo(Me)
    │
    ├─ CultureInfo.NumberFormat
    │      └─ New NumberFormatInfo
    │             └─ InitCultureInfo(Me)
    │
    ├─ CultureInfo.Calendar
    │      └─ GetCalendar(CalendarType)
    │             ├─ New GregorianCalendar
    │             ├─ New JapaneseCalendar
    │             ├─ New HijriCalendar
    │             └─ ... (その他のカレンダー)
    │
    └─ CultureInfo.GetFormat(FormatType)
           ├─ NumberFormat (NumberFormatInfo要求時)
           └─ DateTimeFormat (DateTimeFormatInfo要求時)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

LCID/カルチャ名 ───▶ CultureTable検索 ───▶ CultureInfoインスタンス
                           │
                           ▼
                    プロパティロード
                    (Name, EnglishName等)
                           │
        ┌──────────────────┼──────────────────┐
        ▼                  ▼                  ▼
  DateTimeFormat    NumberFormat         Calendar
  (遅延生成)         (遅延生成)           (遅延生成)
        │                  │                  │
        ▼                  ▼                  ▼
  日付書式設定       数値書式設定        日付計算
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CultureInfo.cls | `Source/CorLib/System.Globalization/CultureInfo.cls` | ソース | カルチャ情報メインクラス |
| CultureInfoStatic.cls | `Source/CorLib/System.Globalization/CultureInfoStatic.cls` | ソース | 静的メソッド提供クラス |
| CultureTable.cls | `Source/CorLib/System.Globalization/CultureTable.cls` | ソース | カルチャデータテーブル |
| DateTimeFormatInfo.cls | `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` | ソース | 日付時刻書式情報 |
| NumberFormatInfo.cls | `Source/CorLib/System.Globalization/NumberFormatInfo.cls` | ソース | 数値書式情報 |
| GregorianCalendar.cls | `Source/CorLib/System.Globalization/GregorianCalendar.cls` | ソース | グレゴリオ暦カレンダー |
| JapaneseCalendar.cls | `Source/CorLib/System.Globalization/JapaneseCalendar.cls` | ソース | 和暦カレンダー |
| HijriCalendar.cls | `Source/CorLib/System.Globalization/HijriCalendar.cls` | ソース | イスラム暦カレンダー |
| HebrewCalendar.cls | `Source/CorLib/System.Globalization/HebrewCalendar.cls` | ソース | ヘブライ暦カレンダー |
| IFormatProvider.cls | `Source/CorLib/System/IFormatProvider.cls` | ソース | 書式プロバイダインターフェース |
| ICloneable.cls | `Source/CorLib/System/ICloneable.cls` | ソース | クローン可能インターフェース |
| IObject.cls | `Source/CorLib/System/IObject.cls` | ソース | オブジェクト基底インターフェース |
