# 機能設計書 75-NumberFormatInfo

## 概要

本ドキュメントは、VBCorLibライブラリにおけるNumberFormatInfoクラスの機能設計を記載する。NumberFormatInfoは、数値の書式設定に必要なカルチャ固有の情報を提供するクラスである。

### 本機能の処理概要

NumberFormatInfoは、特定のロケールにおける数値の書式設定情報を格納し、数値データのフォーマッティングに使用されるクラスである。IFormatProviderインターフェースを実装し、数値の書式設定オブジェクトとして機能する。通貨記号、小数点記号、桁区切り記号、正負の数値パターンなど、国際化対応に必要な数値フォーマット情報を一元管理する。

**業務上の目的・背景**：数値の表示形式は国・地域によって大きく異なる。米国では小数点に「.」、桁区切りに「,」を使用するが、ドイツでは逆に小数点に「,」、桁区切りに「.」を使用する。通貨記号や通貨の位置（前置/後置）も国によって異なる。NumberFormatInfoクラスは、これらの地域固有の設定を統一的に管理し、.NET Frameworkとの互換性を持つVB6実装を提供する。

**機能の利用シーン**：多言語対応アプリケーションでの金額表示、レポート出力における地域固有数値フォーマット、国際的な財務データ処理、ユーザーインターフェースのローカライズなどで利用される。

**主要な処理内容**：
1. 数値フォーマット情報の管理（小数点、桁区切り、負数パターン）
2. 通貨フォーマット情報の管理（通貨記号、配置パターン）
3. パーセントフォーマット情報の管理（パーセント記号、配置パターン）
4. 特殊値の表現（NaN、正の無限大、負の無限大）
5. IFormatProviderインターフェースによる書式プロバイダ機能

**関連システム・外部連携**：CultureInfoクラスと連携してカルチャ固有の数値フォーマット情報を提供する。StringBuilderのAppendFormat等で使用される。

**権限による制御**：特になし。ただし、ReadOnlyフラグにより変更不可のインスタンスを作成可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラス |

## 機能種別

データ提供処理（数値書式情報管理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| LCID | Long | Yes | ロケール識別子 | 有効なLCIDであること |
| UseUserOverride | Boolean | No | ユーザー設定を使用するか | デフォルトはTrue |

### 入力データソース

- CultureTableクラスからロードされる数値書式定義データ
- Windows APIから取得されるユーザーロケール設定（UseUserOverride時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| PositiveSign | String | 正の符号（デフォルト: "+"） |
| NegativeSign | String | 負の符号（デフォルト: "-"） |
| NumberDecimalSeparator | String | 数値の小数点記号 |
| NumberDecimalDigits | Long | 数値の小数点以下桁数 |
| NumberGroupSizes | Long() | 数値の桁グループサイズ配列 |
| NumberGroupSeparator | String | 数値の桁区切り記号 |
| NumberNegativePattern | NumberNegativePatterns | 負数パターン（0-4） |
| CurrencyDecimalSeparator | String | 通貨の小数点記号 |
| CurrencyDecimalDigits | Long | 通貨の小数点以下桁数 |
| CurrencyGroupSizes | Long() | 通貨の桁グループサイズ配列 |
| CurrencyGroupSeparator | String | 通貨の桁区切り記号 |
| CurrencySymbol | String | 通貨記号 |
| CurrencyPositivePattern | CurrencyPositivePatterns | 正の通貨パターン（0-3） |
| CurrencyNegativePattern | CurrencyNegativePatterns | 負の通貨パターン（0-15） |
| PercentDecimalSeparator | String | パーセントの小数点記号 |
| PercentDecimalDigits | Long | パーセントの小数点以下桁数 |
| PercentGroupSizes | Long() | パーセントの桁グループサイズ配列 |
| PercentGroupSeparator | String | パーセントの桁区切り記号 |
| PercentSymbol | String | パーセント記号 |
| PercentPositivePattern | PercentPositivePatterns | 正のパーセントパターン（0-3） |
| PercentNegativePattern | PercentNegativePatterns | 負のパーセントパターン（0-11） |
| PerMilleSymbol | String | パーミル記号 |
| NaNSymbol | String | NaN表現 |
| PositiveInfinitySymbol | String | 正の無限大表現 |
| NegativeInfinitySymbol | String | 負の無限大表現 |
| IsReadOnly | Boolean | 読み取り専用フラグ |

### 出力先

プロパティを介してアプリケーションに提供される。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタによる初期化
   └─ LCIDとUseUserOverrideフラグを受け取る
2. 数値フォーマット情報のロード
   ├─ UseUserOverride=True: Windows APIから取得
   └─ UseUserOverride=False: CultureTableから取得
3. IFormatProvider.GetFormat呼び出し
   └─ NumberFormatInfo型の場合、自身を返却
```

### フローチャート

```mermaid
flowchart TD
    A[NumberFormatInfo生成] --> B[Init呼び出し]
    B --> C{UseUserOverride?}
    C -->|Yes| D[Windows APIから設定取得]
    C -->|No| E[CultureTableから設定取得]
    D --> F[プロパティ設定]
    E --> F
    F --> G[mLoaded = True]
    G --> H[フォーマット実行]
    H --> I{フォーマット種別}
    I -->|数値 N/n| J[NumberNegativePatternで負数処理]
    I -->|通貨 C/c| K[CurrencyPatternで通貨処理]
    I -->|パーセント P/p| L[PercentPatternでパーセント処理]
    J --> M[書式化された文字列]
    K --> M
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 負数パターン | 5種類の負数表示パターン（0-4）をサポート | 負の数値フォーマット時 |
| BR-02 | 通貨正パターン | 4種類の正の通貨パターン（0-3）をサポート | 正の通貨フォーマット時 |
| BR-03 | 通貨負パターン | 16種類の負の通貨パターン（0-15）をサポート | 負の通貨フォーマット時 |
| BR-04 | パーセント正パターン | 4種類の正のパーセントパターン（0-3）をサポート | 正のパーセントフォーマット時 |
| BR-05 | パーセント負パターン | 12種類の負のパーセントパターン（0-11）をサポート | 負のパーセントフォーマット時 |
| BR-06 | ReadOnlyカルチャ | ReadOnlyフラグが立っている場合は変更不可 | プロパティSet時 |
| BR-07 | 遅延ロード | 初回プロパティアクセス時にロード | プロパティGet時 |

### 計算ロジック

```
NumberNegativePatterns列挙型:
- 0: (n)    - 括弧で囲む
- 1: -n    - 負号を前に
- 2: - n   - 負号を前に（空白あり）
- 3: n-    - 負号を後に
- 4: n -   - 負号を後に（空白あり）

CurrencyPositivePatterns列挙型:
- 0: $n    - 通貨記号を前に
- 1: n$    - 通貨記号を後に
- 2: $ n   - 通貨記号を前に（空白あり）
- 3: n $   - 通貨記号を後に（空白あり）

CurrencyNegativePatterns列挙型:
- 0: ($n)  〜 15: (n $)  - 16種類の組み合わせ

PercentPositivePatterns列挙型:
- 0: n %   - 数値の後に%（空白あり）
- 1: n%    - 数値の後に%
- 2: %n    - %の後に数値
- 3: % n   - %の後に数値（空白あり）

PercentNegativePatterns列挙型:
- 0: -n %  〜 11: n- %  - 12種類の組み合わせ
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidOperation | 無効操作 | ReadOnlyインスタンスへの書き込み | Cloneで変更可能なコピーを作成 |
| ArgumentNull | Null引数 | 必須プロパティにNullを設定 | 有効な値を指定 |
| Argument | 引数エラー | 無効なパターン値を設定 | 有効な列挙値を指定 |

### リトライ仕様

書式設定処理は同期的に実行され、リトライ機構は不要。

## トランザクション仕様

本機能はトランザクション管理を必要としない。

## パフォーマンス要件

- 書式設定情報は初回ロード時にキャッシュされる
- 遅延ロードによる初期化コストの分散

## セキュリティ考慮事項

- ReadOnlyフラグにより、共有インスタンスの意図しない変更を防止

## 備考

- .NET FrameworkのSystem.Globalization.NumberFormatInfoクラスと互換性のある実装
- MITライセンスで提供（Copyright (c) 2012 Kelly Ethridge）
- PropertyBagを使用したシリアライズ/デシリアライズに対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NumberFormatInfo.cls | `Source/CorLib/System.Globalization/NumberFormatInfo.cls` | PropsType構造体（行200-228）で書式情報を定義 |
| 1-2 | NumberFormatInfo.cls | `Source/CorLib/System.Globalization/NumberFormatInfo.cls` | パターン列挙型（行94-198）の定義 |

#### Step 2: プロパティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NumberFormatInfo.cls | `Source/CorLib/System.Globalization/NumberFormatInfo.cls` | 各フォーマットプロパティのGet/Set |

### プログラム呼び出し階層図

```
CultureInfo / ユーザーコード
    │
    ├─ NumberFormatInfo.NumberDecimalSeparator
    │
    ├─ NumberFormatInfo.CurrencySymbol
    │
    ├─ NumberFormatInfo.GetFormat(FormatType)
    │      └─ 自身を返却（FormatType = "NumberFormatInfo"の場合）
    │
    └─ Clone()
           └─ 新しいインスタンスを生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NumberFormatInfo.cls | `Source/CorLib/System.Globalization/NumberFormatInfo.cls` | ソース | 数値書式情報メインクラス |
| NumberFormatInfoStatic.cls | `Source/CorLib/System.Globalization/NumberFormatInfoStatic.cls` | ソース | 静的メソッド提供クラス |
| CultureInfo.cls | `Source/CorLib/System.Globalization/CultureInfo.cls` | ソース | カルチャ情報（NumberFormatの親） |
| CultureTable.cls | `Source/CorLib/System.Globalization/CultureTable.cls` | ソース | カルチャデータテーブル |
| IFormatProvider.cls | `Source/CorLib/System/IFormatProvider.cls` | ソース | 書式プロバイダインターフェース |
| ICloneable.cls | `Source/CorLib/System/ICloneable.cls` | ソース | クローン可能インターフェース |
