# 機能設計書 77-JulianCalendar

## 概要

本ドキュメントは、VBCorLibライブラリにおけるJulianCalendarクラスの機能設計を記載する。JulianCalendarは、ユリウス暦に基づく日付計算を提供するカレンダークラスである。

### 本機能の処理概要

JulianCalendarは、紀元前45年にユリウス・カエサルによって導入されたユリウス暦に基づいた日付操作メソッドを提供するクラスである。Calendarインターフェースを実装し、日付の加算、減算、年月日の取得、閏年判定などの機能を提供する。グレゴリオ暦と比較して、閏年の規則が異なる。

**業務上の目的・背景**：ユリウス暦は1582年までヨーロッパで広く使用されていた暦法であり、歴史的な日付計算や、ユリウス暦を現在も使用している一部の東方正教会の祝日計算などで必要となる。本クラスは.NET Frameworkとの互換性を持つVB6実装を提供する。

**機能の利用シーン**：歴史的日付の計算、天文学的計算、東方正教会の祝日計算、ユリウス日（Julian Day）関連の計算などで利用される。

**主要な処理内容**：
1. 日付への時間単位の加算（AddDays, AddMonths, AddYears等）
2. 日付からの情報抽出（GetYear, GetMonth, GetDayOfMonth等）
3. 閏年判定（4年に1回、例外なし）
4. 月の日数取得（GetDaysInMonth, GetDaysInYear）
5. 2桁年から4桁年への変換（ToFourDigitYear）

**関連システム・外部連携**：CultureInfoクラスのオプションカレンダーとして使用される場合がある。

**権限による制御**：特になし。ただし、ReadOnlyフラグにより変更不可のインスタンスを作成可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラス |

## 機能種別

計算処理（日付演算）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Time | Variant | Yes | 操作対象の日付 | 有効な日付であること |
| Year | Long | Yes (一部) | 年 | 1-9999の範囲 |
| Month | Long | Yes (一部) | 月 | 1-12の範囲 |
| Day | Long | Yes (一部) | 日 | 月に応じた有効な日 |
| Era | Long | No | 紀元 | JulianEra（1）のみサポート |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AlgorithmType | CalendarAlgorithmType | SolarCalendar |
| Eras | Long() | {1}（JulianEra） |
| TwoDigitYearMax | Long | デフォルト2029 |
| MinSupportedDateTime | CorDateTime | CorDateTime.MinValue |
| MaxSupportedDateTime | CorDateTime | CorDateTime.MaxValue |

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 閏年ルール | 4で割り切れる年は閏年（例外なし） | 閏年判定時 |
| BR-02 | グレゴリオ暦との差 | ユリウス暦はグレゴリオ暦より約2日遅れ | 日付変換時 |
| BR-03 | 紀元 | JulianEra（1）のみをサポート | Era指定時 |

### 計算ロジック

```
閏年判定（ユリウス暦）:
IsLeapYear(Year) = (Year mod 4 = 0)

※グレゴリオ暦との違い:
- グレゴリオ暦: 100で割り切れる年は閏年でない（400で割り切れる場合を除く）
- ユリウス暦: 100や400の例外規則がない
```

## 備考

- .NET FrameworkのSystem.Globalization.JulianCalendarクラスと互換性のある実装
- MITライセンスで提供（Copyright (c) 2012 Kelly Ethridge）

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | JulianCalendar.cls | `Source/CorLib/System.Globalization/JulianCalendar.cls` | 定数定義（行49-61） |
| 1-2 | JulianCalendar.cls | `Source/CorLib/System.Globalization/JulianCalendar.cls` | Erasプロパティ（行82-84） |
| 1-3 | JulianCalendar.cls | `Source/CorLib/System.Globalization/JulianCalendar.cls` | TwoDigitYearMax（行128-160） |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| JulianCalendar.cls | `Source/CorLib/System.Globalization/JulianCalendar.cls` | ソース | ユリウス暦カレンダー |
| JulianCalendarStatic.cls | `Source/CorLib/System.Globalization/JulianCalendarStatic.cls` | ソース | 静的メソッド提供 |
| Calendar.cls | `Source/CorLib/System.Globalization/Calendar.cls` | ソース | カレンダー基底インターフェース |
