# 機能設計書 78-JapaneseCalendar

## 概要

本ドキュメントは、VBCorLibライブラリにおけるJapaneseCalendarクラスの機能設計を記載する。JapaneseCalendarは、日本の和暦（元号）に基づく日付計算を提供するカレンダークラスである。

### 本機能の処理概要

JapaneseCalendarは、日本の天皇の治世に基づいた元号（明治、大正、昭和、平成）を使用した日付操作メソッドを提供するクラスである。Calendarインターフェースを実装し、和暦での日付の加算、減算、年月日の取得、元号の判定などの機能を提供する。

**業務上の目的・背景**：日本では公文書や正式な文書において和暦が使用されることが多い。官公庁のシステム、金融機関、保険業界などでは和暦表示が必須となる場合がある。本クラスは.NET Frameworkとの互換性を持つVB6実装を提供し、和暦計算機能を実現する。

**機能の利用シーン**：日本向けビジネスアプリケーション、公文書作成システム、年金計算システム、保険システム、銀行システムなど、和暦表示が必要なシステムで利用される。

**主要な処理内容**：
1. 元号に基づく日付計算
2. 西暦と和暦の相互変換
3. 元号の判定（GetEra）
4. 元号内の年の取得（GetYear）
5. 日付への時間単位の加算（AddDays, AddMonths, AddYears等）

**関連システム・外部連携**：CultureInfoクラスと連携して日本カルチャ（ja-JP）のカレンダーとして使用される。

**権限による制御**：特になし。ただし、ReadOnlyフラグにより変更不可のインスタンスを作成可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラス |

## 機能種別

計算処理（日付演算）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Time | Variant | Yes | 操作対象の日付 | 明治元年9月8日以降であること |
| Year | Long | Yes (一部) | 元号内の年 | 1以上、元号の最大年以下 |
| Month | Long | Yes (一部) | 月 | 1-12の範囲 |
| Day | Long | Yes (一部) | 日 | 月に応じた有効な日 |
| Era | Long | Yes (元号指定時) | 元号 | 1-4（明治=1, 大正=2, 昭和=3, 平成=4） |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AlgorithmType | CalendarAlgorithmType | SolarCalendar |
| Eras | Long() | {4, 3, 2, 1}（平成、昭和、大正、明治の順） |
| TwoDigitYearMax | Long | デフォルト99 |
| MinSupportedDateTime | CorDateTime | 1868年9月8日（明治元年） |
| MaxSupportedDateTime | CorDateTime | CorDateTime.MaxValue |

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 元号定義 | 4つの元号をサポート（明治=1, 大正=2, 昭和=3, 平成=4） | 全ての操作 |
| BR-02 | 最小日付 | 1868年9月8日（明治元年9月8日）から対応 | 日付検証時 |
| BR-03 | 元号切替日 | 明治:1868/9/8、大正:1912/7/30、昭和:1926/12/25、平成:1989/1/8 | GetEra時 |
| BR-04 | 元年表記 | 元号の最初の年は「元年」と呼ばれる（数値としては1） | 年取得時 |

### 計算ロジック

```
元号期間:
- 明治(1): 1868/09/08 - 1912/07/29
- 大正(2): 1912/07/30 - 1926/12/24
- 昭和(3): 1926/12/25 - 1989/01/07
- 平成(4): 1989/01/08 - 現在

西暦から和暦への変換:
和暦年 = 西暦年 - 元号開始西暦年 + 1

例: 2024年 → 平成36年（実際には令和だが、本実装では平成のみ）
```

## 備考

- .NET FrameworkのSystem.Globalization.JapaneseCalendarクラスと互換性のある実装
- MITライセンスで提供（Copyright (c) 2018 Kelly Ethridge）
- 令和（2019年5月1日〜）は本実装に含まれていない可能性がある（ソースコード確認が必要）

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | JapaneseCalendar.cls | `Source/CorLib/System.Globalization/JapaneseCalendar.cls` | EraInfo構造体（行55-61） |
| 1-2 | JapaneseCalendar.cls | `Source/CorLib/System.Globalization/JapaneseCalendar.cls` | Erasプロパティ（行137-139） |
| 1-3 | JapaneseCalendar.cls | `Source/CorLib/System.Globalization/JapaneseCalendar.cls` | MinSupportedDateTime（行178-180） |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| JapaneseCalendar.cls | `Source/CorLib/System.Globalization/JapaneseCalendar.cls` | ソース | 和暦カレンダー |
| JapaneseCalendarStatic.cls | `Source/CorLib/System.Globalization/JapaneseCalendarStatic.cls` | ソース | 静的メソッド提供 |
| Calendar.cls | `Source/CorLib/System.Globalization/Calendar.cls` | ソース | カレンダー基底インターフェース |
