# 機能設計書 79-HebrewCalendar

## 概要

本ドキュメントは、VBCorLibライブラリにおけるHebrewCalendarクラスの機能設計を記載する。HebrewCalendarは、ヘブライ暦（ユダヤ暦）に基づく日付計算を提供するカレンダークラスである。

### 本機能の処理概要

HebrewCalendarは、ユダヤ教で使用されるヘブライ暦（太陰太陽暦）に基づいた日付操作メソッドを提供するクラスである。Calendarインターフェースを実装し、ヘブライ暦での日付の加算、減算、年月日の取得、閏年判定などの機能を提供する。19年周期（メトン周期）に基づく複雑な閏年規則を持つ。

**業務上の目的・背景**：ヘブライ暦はユダヤ教の宗教暦として使用され、過越祭（ペサハ）、贖罪日（ヨム・キプール）、仮庵の祭り（スコット）などの祝祭日の計算に必要である。イスラエルや世界中のユダヤ人コミュニティ向けのアプリケーションで必要となる。本クラスは.NET Frameworkとの互換性を持つVB6実装を提供する。

**機能の利用シーン**：ユダヤ教祝祭日カレンダー、イスラエル向けアプリケーション、宗教的行事スケジュール管理、ユダヤ暦日付変換などで利用される。

**主要な処理内容**：
1. ヘブライ暦日付への時間単位の加算（AddDays, AddMonths, AddYears等）
2. ヘブライ暦からの情報抽出（GetYear, GetMonth, GetDayOfMonth等）
3. 閏年判定（19年周期で7回の閏年）
4. 閏月（アダル・シェニ）の判定
5. 月の日数取得（月によって29日または30日、可変）

**関連システム・外部連携**：CultureInfoクラスのオプションカレンダーとして使用される。

**権限による制御**：特になし。ただし、ReadOnlyフラグにより変更不可のインスタンスを作成可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラス |

## 機能種別

計算処理（日付演算）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Time | Variant | Yes | 操作対象の日付 | サポート範囲内であること |
| Year | Long | Yes (一部) | ヘブライ暦年 | 5343-5999の範囲 |
| Month | Long | Yes (一部) | 月 | 1-13の範囲（閏年は13ヶ月） |
| Day | Long | Yes (一部) | 日 | 月に応じた有効な日 |
| Era | Long | No | 紀元 | HebrewEra（1）のみサポート |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AlgorithmType | CalendarAlgorithmType | LunisolarCalendar（太陰太陽暦） |
| Eras | Long() | {1}（HebrewEra） |
| TwoDigitYearMax | Long | デフォルト5790 |
| MinSupportedDateTime | CorDateTime | 1583年1月1日 |
| MaxSupportedDateTime | CorDateTime | 2239年9月29日 |

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 閏年周期 | 19年周期で3, 6, 8, 11, 14, 17, 19年目が閏年 | 閏年判定時 |
| BR-02 | 閏月 | 閏年には13番目の月（アダル・シェニ）が追加される | 月計算時 |
| BR-03 | 年の種類 | 不足年(353/383日)、通常年(354/384日)、過剰年(355/385日) | 日数計算時 |
| BR-04 | エポック | ティシュリ1日、紀元前3761年 = RD -1,373,427 | 日付変換時 |
| BR-05 | サポート範囲 | ヘブライ暦5343年〜5999年 | 年検証時 |

### 計算ロジック

```
閏年判定:
19年周期で7回の閏年: 年 mod 19 ∈ {3, 6, 8, 11, 14, 17, 0(=19)}
IsLeapYear(Year) = ((7 * Year + 1) mod 19) < 7

月の構成:
1. ティシュリ (30日)
2. ヘシュバン (29または30日)
3. キスレブ (29または30日)
4. テベット (29日)
5. シェバット (30日)
6. アダル (29日、閏年は30日)
7. アダル・シェニ (閏年のみ、29日)
8-12. ニサン〜エルル (交互に30日と29日)

年の日数計算:
- 不足年: ヘシュバン=29, キスレブ=29
- 通常年: ヘシュバン=29, キスレブ=30
- 過剰年: ヘシュバン=30, キスレブ=30
```

## 備考

- .NET FrameworkのSystem.Globalization.HebrewCalendarクラスと互換性のある実装
- MITライセンスで提供（Copyright (c) 2018 Kelly Ethridge）
- エポック（RD -1,373,427）は紀元前3761年10月7日（ユリウス暦）に相当

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HebrewCalendar.cls | `Source/CorLib/System.Globalization/HebrewCalendar.cls` | EPOCH定数（行54） |
| 1-2 | HebrewCalendar.cls | `Source/CorLib/System.Globalization/HebrewCalendar.cls` | 年範囲定数（行64-65） |
| 1-3 | HebrewCalendar.cls | `Source/CorLib/System.Globalization/HebrewCalendar.cls` | AlgorithmType（行77-79） |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HebrewCalendar.cls | `Source/CorLib/System.Globalization/HebrewCalendar.cls` | ソース | ヘブライ暦カレンダー |
| HebrewCalendarStatic.cls | `Source/CorLib/System.Globalization/HebrewCalendarStatic.cls` | ソース | 静的メソッド提供 |
| Calendar.cls | `Source/CorLib/System.Globalization/Calendar.cls` | ソース | カレンダー基底インターフェース |
