# 機能設計書 8-Environment

## 概要

本ドキュメントは、VBCorLibライブラリにおける環境情報機能（Environment）の設計を記述する。Environmentクラスは、.NET Frameworkの`System.Environment`クラスに相当するシステム環境情報の取得・設定機能を提供する静的クラスである。

### 本機能の処理概要

Environmentクラスは、実行中のシステムの環境情報（マシン名、ユーザー名、OSバージョン、環境変数、特殊フォルダパス等）を取得し、環境変数の操作を行う機能を提供する。

**業務上の目的・背景**：アプリケーションはしばしば実行環境の情報を必要とする。Environmentはシステム情報へのアクセスを標準化し、マシン名、ユーザー名、作業ディレクトリ、環境変数などへの統一的なAPIを提供する。

**機能の利用シーン**：システム環境の情報取得を必要とする場面で利用される。具体的には、ログファイルへのマシン/ユーザー情報記録、設定ファイルの保存先決定、プラットフォーム依存処理の分岐、環境変数からの設定読み込み、コマンドライン引数の解析などの場面で活用される。

**主要な処理内容**：
1. システム情報の取得（MachineName、UserName、UserDomainName、OSVersion、TickCount、WorkingSet）
2. パス情報の取得（CurrentDirectory、SystemDirectory、GetFolderPath）
3. プロセス情報の取得（CommandLine、GetCommandLineArgs、Is64BitOperatingSystem、UserInteractive）
4. 環境変数の操作（GetEnvironmentVariable、SetEnvironmentVariable、ExpandEnvironmentVariables、GetEnvironmentVariables）
5. その他（NewLine、Exit）

**関連システム・外部連携**：Windows APIを使用してシステム情報を取得。GetComputerNameW、GetUserNameW、GetVersionExW、GetEnvironmentVariableW、GetSystemDirectoryW、SHGetFolderPathW等を使用。

**権限による制御**：権限による制御は行わない。ただし、Machine/User環境変数はWindows 95/98/MEではサポートされない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラスである |

## 機能種別

計算処理 / システム情報取得ユーティリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Folder | SpecialFolder | Yes | 特殊フォルダの種類 | 列挙値 |
| Name | String | Yes | 環境変数名 | なし |
| Value | String | No | 環境変数の値 | なし |
| Target | EnvironmentVariableTarget | No | 環境変数のスコープ | Machine/Process/User |

### 入力データソース

Windows API経由でシステムから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| マシン名 | String | MachineNameプロパティ |
| ユーザー名 | String | UserNameプロパティ |
| ユーザードメイン | String | UserDomainNameプロパティ |
| OSバージョン | OperatingSystem | OSVersionプロパティ |
| 経過時間 | Long | TickCountプロパティ（システム起動からのミリ秒） |
| メモリ使用量 | Currency | WorkingSetプロパティ |
| カレントディレクトリ | String | CurrentDirectoryプロパティ |
| システムディレクトリ | String | SystemDirectoryプロパティ |
| コマンドライン | String | CommandLineプロパティ |
| コマンドライン引数 | String() | GetCommandLineArgsの戻り値 |
| 64ビットOS判定 | Boolean | Is64BitOperatingSystemプロパティ |
| ユーザー対話可能 | Boolean | UserInteractiveプロパティ |
| 改行文字 | String | NewLineプロパティ（vbCrLf） |
| 環境変数値 | String | GetEnvironmentVariableの戻り値 |
| フォルダパス | String | GetFolderPathの戻り値 |

### 出力先

呼び出し元への戻り値

## 処理フロー

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{情報種別}
    B -->|システム情報| C[Windows API呼び出し]
    B -->|環境変数| D{Target}
    D -->|Process| E[GetEnvironmentVariableW]
    D -->|Machine/User| F[Registry読み取り]
    B -->|特殊フォルダ| G[SHGetFolderPathW]
    C --> H[値を返却]
    E --> H
    F --> H
    G --> H
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 静的クラス | インスタンス化不可、クラス名で直接アクセス | 全メソッド |
| BR-02 | プラットフォーム制限 | Machine/User環境変数はNT系のみ | 環境変数操作 |
| BR-03 | TickCountオーバーフロー | 約24.85日でオーバーフローして負に | TickCount |

### 主要列挙型

**SpecialFolder列挙型（一部）**
- Desktop、MyDocuments、MyMusic、MyPictures
- ApplicationData、LocalApplicationData
- ProgramFiles、Windows、SystemDir
- Startup、SendTo、Templates等

**EnvironmentVariableTarget列挙型**
- Machine (0): システム全体
- Process (1): 現在のプロセス
- User (2): 現在のユーザー

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidOperationException | 操作エラー | マシン名取得失敗 | システム設定確認 |
| PlatformNotSupportedException | 非サポート | Win95/98/MEでUserDomainName | NTプラットフォームで使用 |
| InvalidOperationException | 操作エラー | OSバージョン取得失敗 | システム確認 |

## 備考

- Environmentクラスは直接インスタンス化不可（VB_Creatable = False）
- Windows APIを多用してシステム情報を取得
- OSVersionはキャッシュされる
- NewLineは常にvbCrLf（Windows環境）

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Environment.cls | `Source/CorLib/System/Environment.cls` | 49-51行目: API宣言 |
| 1-2 | Environment.cls | `Source/CorLib/System/Environment.cls` | 117-165行目: SpecialFolder列挙型 |
| 1-3 | Environment.cls | `Source/CorLib/System/Environment.cls` | 179-183行目: EnvironmentVariableTarget |
| 1-4 | Environment.cls | `Source/CorLib/System/Environment.cls` | 192-200行目: Is64BitOperatingSystem |
| 1-5 | Environment.cls | `Source/CorLib/System/Environment.cls` | 208-210行目: CommandLine |
| 1-6 | Environment.cls | `Source/CorLib/System/Environment.cls` | 233-244行目: MachineName |
| 1-7 | Environment.cls | `Source/CorLib/System/Environment.cls` | 261-288行目: OSVersion |
| 1-8 | Environment.cls | `Source/CorLib/System/Environment.cls` | 316-318行目: TickCount |
| 1-9 | Environment.cls | `Source/CorLib/System/Environment.cls` | 385-395行目: UserName |
| 1-10 | Environment.cls | `Source/CorLib/System/Environment.cls` | 422-440行目: ExpandEnvironmentVariables |
| 1-11 | Environment.cls | `Source/CorLib/System/Environment.cls` | 450-452行目: GetCommandLineArgs |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Environment.cls | `Source/CorLib/System/Environment.cls` | ソース | 環境情報のメインクラス |
| OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | ソース | OS情報を表すクラス |
| Directory.cls | `Source/CorLib/System.IO/Directory.cls` | ソース | ディレクトリ操作（CurrentDirectory） |
