# 機能設計書 80-HijriCalendar

## 概要

本ドキュメントは、VBCorLibライブラリにおけるHijriCalendarクラスの機能設計を記載する。HijriCalendarは、イスラム暦（ヒジュラ暦）に基づく日付計算を提供するカレンダークラスである。

### 本機能の処理概要

HijriCalendarは、イスラム教で使用されるヒジュラ暦（太陰暦）に基づいた日付操作メソッドを提供するクラスである。Calendarインターフェースを実装し、ヒジュラ暦での日付の加算、減算、年月日の取得、閏年判定などの機能を提供する。本実装は表形式（Tabular）のイスラム暦に基づいている。

**業務上の目的・背景**：ヒジュラ暦はイスラム教の宗教暦として使用され、ラマダン（断食月）、イード・アル＝フィトル、イード・アル＝アドハーなどの祝祭日の計算に必要である。中東や東南アジアのイスラム圏向けアプリケーションで必要となる。本クラスは.NET Frameworkとの互換性を持つVB6実装を提供する。

**機能の利用シーン**：イスラム教祝祭日カレンダー、中東・東南アジア向けアプリケーション、ラマダン開始日計算、イスラム暦日付変換などで利用される。

**主要な処理内容**：
1. ヒジュラ暦日付への時間単位の加算（AddDays, AddMonths, AddYears等）
2. ヒジュラ暦からの情報抽出（GetYear, GetMonth, GetDayOfMonth等）
3. 閏年判定（30年周期で11回の閏年）
4. HijriAdjustmentによる地域差補正
5. 月の日数取得（交互に30日と29日）

**関連システム・外部連携**：CultureInfoクラスと連携してイスラム圏カルチャのカレンダーとして使用される。

**権限による制御**：特になし。ただし、ReadOnlyフラグにより変更不可のインスタンスを作成可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラス |

## 機能種別

計算処理（日付演算）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Time | Variant | Yes | 操作対象の日付 | サポート範囲内であること |
| Year | Long | Yes (一部) | ヒジュラ暦年 | 1-9666の範囲 |
| Month | Long | Yes (一部) | 月 | 1-12の範囲 |
| Day | Long | Yes (一部) | 日 | 月に応じた有効な日 |
| Era | Long | No | 紀元 | HijriEra（1）のみサポート |
| HijriAdjustment | Long | No | 日数調整値 | -2から2の範囲 |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AlgorithmType | CalendarAlgorithmType | LunarCalendar（太陰暦） |
| Eras | Long() | {1}（HijriEra） |
| TwoDigitYearMax | Long | デフォルト1451 |
| MinSupportedDateTime | CorDateTime | 622年7月18日（グレゴリオ暦） |
| MaxSupportedDateTime | CorDateTime | 9999年12月31日（グレゴリオ暦） |
| HijriAdjustment | Long | 地域差補正値（-2〜2） |

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 閏年周期 | 30年周期で2, 5, 7, 10, 13, 16, 18, 21, 24, 26, 29年目が閏年 | 閏年判定時 |
| BR-02 | 年の日数 | 通常年は354日、閏年は355日 | 日数計算時 |
| BR-03 | 月の日数 | 奇数月は30日、偶数月は29日（閏年の12月は30日） | 月日数計算時 |
| BR-04 | エポック | 622年7月18日（グレゴリオ暦）= グレゴリオ日227013 | 日付変換時 |
| BR-05 | HijriAdjustment | ラマダン開始など地域差を-2〜+2日で補正可能 | 日付計算時 |

### 計算ロジック

```
閏年判定:
30年周期で11回の閏年
(19 * Year + 11) mod 30 < 11

30年周期の日数:
(19 * 354) + (11 * 355) = 10631日

年から経過日数への変換:
DaysPer30Years = 10631
Days = ((Year - 1) / 30) * DaysPer30Years + 年内の追加日数

月の日数:
- 奇数月（1,3,5,7,9,11）: 30日
- 偶数月（2,4,6,8,10）: 29日
- 12月: 通常年29日、閏年30日

HijriAdjustment:
- 実際の月の観測結果と計算結果の差を補正
- -2から+2の範囲で設定可能
- 変換計算時に加算される
```

## 備考

- .NET FrameworkのSystem.Globalization.HijriCalendarクラスと互換性のある実装
- MITライセンスで提供（Copyright (c) 2017 Kelly Ethridge）
- 本実装は表形式（Tabular）のイスラム暦であり、純粋な月の観測に基づくものではない

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HijriCalendar.cls | `Source/CorLib/System.Globalization/HijriCalendar.cls` | EPOCH定数（行60） |
| 1-2 | HijriCalendar.cls | `Source/CorLib/System.Globalization/HijriCalendar.cls` | DaysPer30Years定数（行65） |
| 1-3 | HijriCalendar.cls | `Source/CorLib/System.Globalization/HijriCalendar.cls` | AlgorithmType（行98-100） |
| 1-4 | HijriCalendar.cls | `Source/CorLib/System.Globalization/HijriCalendar.cls` | HijriAdjustment（行143-169） |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HijriCalendar.cls | `Source/CorLib/System.Globalization/HijriCalendar.cls` | ソース | ヒジュラ暦カレンダー |
| HijriCalendarStatic.cls | `Source/CorLib/System.Globalization/HijriCalendarStatic.cls` | ソース | 静的メソッド提供 |
| Calendar.cls | `Source/CorLib/System.Globalization/Calendar.cls` | ソース | カレンダー基底インターフェース |
