# 機能設計書 83-ThaiBuddhistCalendar

## 概要

本ドキュメントは、VBCorLibライブラリにおけるThaiBuddhistCalendar（タイ仏暦）機能の設計を記述する。

### 本機能の処理概要

ThaiBuddhistCalendarは、タイ仏暦（仏滅紀元/BE: Buddhist Era）に基づいた日付計算機能を提供するクラスである。タイ仏暦は仏陀入滅を元年とし、グレゴリオ暦より543年進んだ紀年法である。

**業務上の目的・背景**：タイ王国に関連するシステムにおいて、タイ仏暦による日付表示や計算が必要となる場合がある。タイでは公文書や日常生活においてタイ仏暦が広く使用されている。本機能は.NET FrameworkのSystem.Globalization.ThaiBuddhistCalendarと互換性のあるAPIを提供し、VB6アプリケーションにおいて国際化対応を可能にする。

**機能の利用シーン**：
- タイ仏暦を使用する業務アプリケーションでの日付表示
- グレゴリオ暦とタイ仏暦の相互変換
- タイ仏暦に基づいた日付演算（年/月/日の加算・減算）
- うるう年の判定

**主要な処理内容**：
1. タイ仏暦年とグレゴリオ暦年の相互変換（年オフセット: 543年）
2. 日付の加算・減算（年、月、日、時、分、秒、ミリ秒単位）
3. うるう年・うるう日の判定
4. 2桁年から4桁年への変換
5. 日付からの年月日時分秒ミリ秒の抽出
6. 日付の曜日・年間通算日の取得

**関連システム・外部連携**：
- Windowsのロケール設定からTwoDigitYearMax値を取得（CAL_THAI）
- CorDateTimeクラスとの連携による日付操作

**権限による制御**：特になし。ReadOnlyプロパティにより読み取り専用カレンダーインスタンスの作成が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 該当なし | - | - | ThaiBuddhistCalendarはライブラリ機能として他のアプリケーションから利用される |

## 機能種別

計算処理 / データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Time | Variant (Date/CorDateTime) | Yes | 操作対象の日時 | 有効な日付範囲内であること |
| Year | Long | Yes | タイ仏暦の年（544〜10542） | MinThaiBuddhistYear(544)以上、MaxThaiBuddhistYear(10542)以下 |
| Month | Long | Yes | 月（1〜12） | 1〜12の範囲内 |
| Day | Long | Yes | 日 | 該当月の有効日数以内 |
| Era | Variant | No | 時代（省略時は現在の時代） | ThaiBuddhistEra(1)またはCurrentEra |

### 入力データソース

- アプリケーションからのメソッド呼び出し
- Windowsシステム設定（TwoDigitYearMax初期値）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CorDateTime | CorDateTime | 変換・演算後の日時オブジェクト |
| Year | Long | タイ仏暦の年 |
| Month | Long | 月 |
| DayOfMonth | Long | 日 |
| DayOfWeek | DayOfWeek | 曜日 |
| DayOfYear | Long | 年間通算日 |
| IsLeapYear | Boolean | うるう年フラグ |
| IsLeapDay | Boolean | うるう日フラグ |

### 出力先

呼び出し元アプリケーションへの戻り値

## 処理フロー

### 処理シーケンス

```
1. 入力パラメータの検証
   └─ Era、Year、Month、Dayの範囲チェック
2. タイ仏暦年からグレゴリオ暦年への変換
   └─ グレゴリオ暦年 = タイ仏暦年 - 543
3. 日付演算の実行
   └─ CorDateTimeまたはCalendar共通処理を利用
4. 結果の返却
   └─ 必要に応じてグレゴリオ暦年からタイ仏暦年へ再変換
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{パラメータ検証}
    B -->|エラー| C[例外スロー]
    B -->|OK| D[タイ仏暦年→グレゴリオ暦年変換]
    D --> E[CorDateTime/Calendar共通処理呼び出し]
    E --> F{結果の年変換が必要?}
    F -->|Yes| G[グレゴリオ暦年→タイ仏暦年変換]
    F -->|No| H[結果返却]
    G --> H
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-83-01 | 年オフセット | グレゴリオ暦年 = タイ仏暦年 - 543 | 全ての年変換処理 |
| BR-83-02 | 有効年範囲 | 544年（西暦1年）〜10542年（西暦9999年） | 年の入力・出力時 |
| BR-83-03 | うるう年判定 | グレゴリオ暦と同一ルール | IsLeapYear呼び出し時 |
| BR-83-04 | 時代 | ThaiBuddhistEra（1）のみサポート | Era検証時 |

### 計算ロジック

**グレゴリオ暦年への変換**:
```
GetGregorianYear = Year - YearOffset  ' YearOffset = 543
```

**タイ仏暦年の取得**:
```
GetYear = CorDateTime.GetYear(Time) + YearOffset
```

## データベース操作仕様

本機能はデータベースを直接操作しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentOutOfRangeException | 範囲外エラー | Year < 544 または Year > 10542 | 有効な年を指定する |
| ArgumentOutOfRangeException | 範囲外エラー | Month < 1 または Month > 12 | 有効な月を指定する |
| ArgumentOutOfRangeException | 範囲外エラー | Day < 1 または Day > 該当月の日数 | 有効な日を指定する |
| Argument_InvalidEraValue | 無効な時代 | Era が ThaiBuddhistEra 以外 | ThaiBuddhistEra(1)を指定する |
| InvalidOperationException | 読み取り専用 | ReadOnlyインスタンスへの書き込み | 書き込み可能なインスタンスを使用する |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特になし（インメモリ計算のみ）

## セキュリティ考慮事項

特になし

## 備考

- .NET FrameworkのSystem.Globalization.ThaiBuddhistCalendarと互換性のあるAPI
- ICloneableインターフェースを実装し、Clone()メソッドによるコピーが可能
- PropertyBagによるシリアライズ/デシリアライズに対応
- ThaiBuddhistCalendarStaticクラスでThaiBuddhistEra定数を提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ThaiBuddhistCalendar.cls | `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` | 定数定義（MinThaiBuddhistYear=544, MaxThaiBuddhistYear=10542, YearOffset=543）とメンバ変数を確認 |

**主要定数（49-51行目）**:
- MinThaiBuddhistYear = 544（最小年）
- MaxThaiBuddhistYear = 10542（最大年）
- YearOffset = 543（年オフセット）

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ThaiBuddhistCalendar.cls | `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` | 公開メソッドの呼び出しパターンを理解 |

**主要処理フロー**:
- **164-166行目**: AddDays - Statics.Calendar.AddDaysを呼び出し
- **251-253行目**: GetDayOfMonth - CorDateTime.GetDayOfMonthを呼び出し
- **394-396行目**: GetYear - CorDateTime.GetYear(Time) + YearOffsetでタイ仏暦年を計算
- **479-485行目**: ToDateTime - ValidateEra/Yearの後、Cor.NewDateTimeでCorDateTimeを生成

#### Step 3: 年変換ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ThaiBuddhistCalendar.cls | `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` | GetGregorianYear関数（564-566行目）とGetYear関数（394-396行目） |

**主要処理フロー**:
- **564-566行目**: グレゴリオ暦年への変換（Year - YearOffset）
- **394-396行目**: タイ仏暦年の取得（CorDateTime.GetYear + YearOffset）

#### Step 4: バリデーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ThaiBuddhistCalendar.cls | `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` | ValidateEra, ValidateYear, ValidateMonthメソッド |

**主要処理フロー**:
- **543-550行目**: ValidateEra - ThaiBuddhistEraまたはCurrentEraのみ許可
- **552-556行目**: ValidateYear - 544〜10542の範囲チェック
- **558-562行目**: ValidateMonth - 1〜12の範囲チェック

### プログラム呼び出し階層図

```
ThaiBuddhistCalendar
    │
    ├─ AddDays/AddMonths/AddYears等
    │      └─ Statics.Calendar.AddXxx
    │              └─ CorDateTime演算
    │
    ├─ GetDayOfMonth/GetMonth等
    │      └─ CorDateTime.GetXxx
    │
    ├─ GetYear
    │      └─ CorDateTime.GetYear + YearOffset
    │
    ├─ ToDateTime
    │      ├─ ValidateEra/Year
    │      ├─ GetGregorianYear (- YearOffset)
    │      └─ Cor.NewDateTime
    │
    └─ IsLeapYear
           └─ CorDateTime.IsLeapYear (変換後のグレゴリオ暦年で判定)
```

### データフロー図

```
[入力]                   [処理]                         [出力]

タイ仏暦年(544-10542) ──▶ - YearOffset ──▶ グレゴリオ暦年(1-9999)
                                │
                                ▼
                         CorDateTime処理
                                │
                                ▼
グレゴリオ暦年(1-9999) ──▶ + YearOffset ──▶ タイ仏暦年(544-10542)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ThaiBuddhistCalendar.cls | `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` | ソース | メインクラス（日付計算処理） |
| ThaiBuddhistCalendarStatic.cls | `Source/CorLib/System.Globalization/ThaiBuddhistCalendarStatic.cls` | ソース | 静的メソッド（ThaiBuddhistEra定数） |
| modCalendarHelpers.bas | `Source/CorLib/System.Globalization/modCalendarHelpers.bas` | ソース | カレンダー共通ヘルパー |
| Calendar.cls | `Source/CorLib/System.Globalization/Calendar.cls` | ソース | 基底インターフェース |
