# 機能設計書 85-ResourceManager

## 概要

本ドキュメントは、VBCorLibライブラリにおけるResourceManager（リソースマネージャー）機能の設計を記述する。

### 本機能の処理概要

ResourceManagerは、カルチャ固有のリソースへのランタイムアクセスを提供するクラスである。複数の.RESファイルやEXE/DLLファイルからリソースを読み込み、カルチャIDに基づいて適切なリソースを返す。

**業務上の目的・背景**：多言語対応アプリケーションでは、UI文字列や画像などのリソースをカルチャ（ロケール）ごとに管理する必要がある。本機能は.NET FrameworkのSystem.Resources.ResourceManagerと互換性のあるAPIを提供し、VB6アプリケーションにおいて国際化（i18n）対応を可能にする。

**機能の利用シーン**：
- 多言語アプリケーションでの文字列リソース管理
- カルチャに応じたUIリソース（アイコン、画像等）の取得
- リソースファイル（.RES）からのリソース読み込み
- EXE/DLLに埋め込まれたリソースの取得

**主要な処理内容**：
1. リソースファイル（.RES）またはEXE/DLLからのリソース読み込み
2. カルチャID（LCID）に基づくリソースセットの管理
3. 親カルチャへのフォールバック検索
4. リソースの取得（GetObject、GetString）
5. リソースセットの列挙

**関連システム・外部連携**：
- ResourceReader（.RESファイル読み込み）
- WinResourceReader（EXE/DLLリソース読み込み）
- ResourceSet（カルチャ別リソース管理）
- CultureInfo（カルチャ情報）

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 該当なし | - | - | ResourceManagerはライブラリ機能として他のアプリケーションから利用される |

## 機能種別

データアクセス / リソース管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| FileName | String | Yes | リソースファイルパス | 有効なファイルパス |
| ResourceName | Variant | Yes | リソース識別子 | 文字列または数値 |
| ResourceType | Variant | Yes | リソースタイプ | ResourceTypes列挙値または文字列 |
| CultureID | Variant | No | カルチャID（LCID） | 有効なLCIDまたはCultureInfoオブジェクト |

### 入力データソース

- .RESファイル
- EXE/DLLファイル（埋め込みリソース）
- フォルダ内の複数リソースファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Resource | Variant | 取得したリソース値 |
| String | String | 文字列リソース |
| ResourceSet | ResourceSet | カルチャ固有のリソースセット |

### 出力先

呼び出し元アプリケーションへの戻り値

## 処理フロー

### 処理シーケンス（GetObject）

```
1. カルチャIDの取得・変換
   └─ CultureInfoまたはLCIDからLanguageIDを取得
2. 指定カルチャのResourceSetを検索
   └─ 存在しない場合は親カルチャを検索
3. リソースの取得
   └─ ResourceSet.GetObjectを呼び出し
4. フォールバック処理
   └─ 見つからない場合は全ResourceSetを検索
5. 結果の返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[カルチャID取得]
    B --> C{指定カルチャのResourceSetあり?}
    C -->|Yes| D[ResourceSet.GetObject呼び出し]
    C -->|No| E{親カルチャあり?}
    E -->|Yes| F[親カルチャで検索]
    F --> C
    E -->|No| G{文字列リソース?}
    G -->|Yes| H[フォールバックリソースセット検索]
    G -->|No| I[全ResourceSet検索]
    D --> J[結果返却]
    H --> J
    I --> J
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-85-01 | カルチャフォールバック | 指定カルチャになければ親カルチャを検索 | GetObject/GetString |
| BR-85-02 | 文字列フォールバック | 文字列リソースは最初に見つかったセットをフォールバックとして使用 | GetString |
| BR-85-03 | リソースファイル判定 | LoadLibraryで読み込めればEXE/DLL、そうでなければ.RES | リソース読み込み時 |
| BR-85-04 | 遅延読み込み | リソースは最初のアクセス時に読み込まれる | GetObject/GetString/GetResourceSet |

### 計算ロジック

特になし（リソース検索ロジックのみ）

## データベース操作仕様

本機能はデータベースを直接操作しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FileNotFoundException | ファイル未検出 | リソースファイルが存在しない | 正しいファイルパスを指定する |
| IOError | IOエラー | リソースファイルの読み込みに失敗 | ファイル形式を確認する |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- リソースは遅延読み込みにより、必要になるまでメモリを消費しない
- 一度読み込んだリソースセットはキャッシュされる

## セキュリティ考慮事項

- 外部ファイルからリソースを読み込むため、信頼できないソースからのファイルに注意

## 備考

- .NET FrameworkのSystem.Resources.ResourceManagerと互換性のあるAPI
- IEnumerableインターフェースを実装し、For Each文でリソースセットを列挙可能
- CreateFileBasedResourceManagerで複数ファイルからリソースを読み込み可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourceManager.cls | `Source/CorLib/System.Resources/ResourceManager.cls` | メンバ変数（mResourceSets, mFiles, mFallbackResourceSet）を確認 |

**主要メンバ変数（56-58行目）**:
- mResourceSets (Hashtable) - カルチャID別のResourceSetを保持
- mFiles() (String) - リソースファイルパスの配列
- mFallbackResourceSet (ResourceSet) - フォールバック用ResourceSet

#### Step 2: 初期化処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourceManager.cls | `Source/CorLib/System.Resources/ResourceManager.cls` | InitFromFile, InitFromFolder |

**主要処理フロー**:
- **208-210行目**: InitFromFile - 単一ファイルからの初期化
- **212-214行目**: InitFromFolder - フォルダ内の複数ファイルからの初期化

#### Step 3: リソース取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResourceManager.cls | `Source/CorLib/System.Resources/ResourceManager.cls` | GetObject, GetString, GetResourceSet |

**主要処理フロー**:
- **70-117行目**: GetObject - メインのリソース取得処理
- **126-129行目**: GetString - 文字列リソースの取得（GetObjectを呼び出し）
- **137-139行目**: GetResourceSet - 指定カルチャのResourceSet取得

#### Step 4: 内部処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ResourceManager.cls | `Source/CorLib/System.Resources/ResourceManager.cls` | LoadResources, GetResourceReader, GetFallbackString |

**主要処理フロー**:
- **220-229行目**: LoadResources - リソースファイルの読み込み
- **256-273行目**: GetResourceReader - ファイル形式に応じたReader取得
- **296-331行目**: GetFallbackString - フォールバック文字列の検索

### プログラム呼び出し階層図

```
ResourceManager
    │
    ├─ 初期化
    │      ├─ InitFromFile
    │      └─ InitFromFolder
    │
    ├─ リソース取得
    │      ├─ GetObject
    │      │      ├─ GetLanguageID
    │      │      ├─ InternalGetResourceSet
    │      │      │      └─ LoadResources (遅延読み込み)
    │      │      │             └─ LoadResource
    │      │      │                    └─ GetResourceReader
    │      │      │                           ├─ WinResourceReader (EXE/DLL)
    │      │      │                           └─ ResourceReader (.RES)
    │      │      └─ ResourceSet.GetObject
    │      │
    │      ├─ GetString
    │      │      └─ GetObject (StringResource)
    │      │
    │      └─ GetResourceSet
    │             └─ InternalGetResourceSet
    │
    └─ 列挙
           └─ GetEnumerator
                  └─ mResourceSets.GetEnumerator
```

### データフロー図

```
[入力ファイル]                [ResourceManager]              [出力]

.RES ファイル ───┐                   │
                 ├──▶ LoadResources ─┼──▶ mResourceSets (Hashtable)
EXE/DLL ─────────┘         │         │        │
                           ▼         │        │
              ┌─ ResourceReader      │        ▼
              └─ WinResourceReader   │   ResourceSet (per LCID)
                                     │        │
                                     │        ▼
              GetObject/GetString ◀──┴── Resource Value
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourceManager.cls | `Source/CorLib/System.Resources/ResourceManager.cls` | ソース | メインクラス |
| ResourceManagerStatic.cls | `Source/CorLib/System.Resources/ResourceManagerStatic.cls` | ソース | 静的メソッド（CreateFileBasedResourceManager） |
| ResourceSet.cls | `Source/CorLib/System.Resources/ResourceSet.cls` | ソース | カルチャ別リソースセット |
| ResourceReader.cls | `Source/CorLib/System.Resources/ResourceReader.cls` | ソース | .RESファイル読み込み |
| WinResourceReader.cls | `Source/CorLib/System.Resources/WinResourceReader.cls` | ソース | EXE/DLLリソース読み込み |
| ResourceKey.cls | `Source/CorLib/System.Resources/ResourceKey.cls` | ソース | リソースキー |
