# 機能設計書 87-ResourceWriter

## 概要

本ドキュメントは、VBCorLibライブラリにおけるResourceWriter（リソースライター）機能の設計を記述する。

### 本機能の処理概要

ResourceWriterは、.RES形式のリソースファイルを作成する機能を提供するクラスである。文字列、アイコン、カーソル、ビットマップなどのリソースをエンコードし、.RES形式で出力する。

**業務上の目的・背景**：アプリケーションで使用するリソースを.RES形式のファイルとして作成する必要がある場合に使用する。本機能は.NET FrameworkのSystem.Resources.ResourceWriterと互換性のあるAPIを提供する。

**機能の利用シーン**：
- .RESファイルの作成
- リソースの動的生成
- 多言語リソースファイルの生成

**主要な処理内容**：
1. リソースの追加（AddResource）
2. リソースのエンコード
3. .RES形式でのファイル出力
4. カスタムエンコーダーの追加

**関連システム・外部連携**：
- BinaryWriter（バイナリファイル書き込み）
- IResourceEncoder（リソースエンコーダーインターフェース）
- 各種エンコーダー（StringResourceEncoder, BitMapResourceEncoder等）

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 該当なし | - | - | ResourceWriterはライブラリ機能として他のアプリケーションから利用される |

## 機能種別

データ出力 / ファイル書き込み

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Source | Variant | Yes | 出力先（ファイルパスまたはStreamオブジェクト） | 有効な出力先であること |
| Value | Variant | Yes | リソース値 | サポートされる型であること |
| ResourceName | Variant | Yes | リソース名 | 文字列または数値 |
| ResourceType | Variant | No | リソースタイプ | ResourceTypes列挙値または文字列 |
| LanguageID | Variant | No | 言語ID | 有効なLCID |

### 入力データソース

- アプリケーションからのAddResource呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| .RESファイル | File | 生成されたリソースファイル |

### 出力先

- 指定されたファイルパス
- 指定されたStreamオブジェクト

## 処理フロー

### 処理シーケンス

```
1. 出力先の準備
   └─ FileStreamまたはStreamの取得
2. リソースの追加（繰り返し）
   └─ 適切なエンコーダーでエンコード
3. ファイル生成（Generate）
   └─ 空ヘッダー書き込み
   └─ 各リソースのヘッダーとデータ書き込み
4. ファイルクローズ
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[BinaryWriter作成]
    B --> C[AddResource呼び出し]
    C --> D{エンコーダーあり?}
    D -->|Yes| E[エンコーダーでエンコード]
    D -->|No| F[ArgumentException]
    E --> G{追加完了?}
    G -->|No| C
    G -->|Yes| H[Generate呼び出し]
    H --> I[空ヘッダー書き込み]
    I --> J[各エンコーダーからリソース取得]
    J --> K[リソースヘッダー書き込み]
    K --> L[リソースデータ書き込み]
    L --> M{次のリソースあり?}
    M -->|Yes| J
    M -->|No| N[CloseWriter]
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-87-01 | エンコーダー検索 | 先頭から順にエンコーダーを検索 | AddResource時 |
| BR-87-02 | 生成後は追加不可 | Generate後はAddResourceできない | Generate呼び出し後 |
| BR-87-03 | 空ヘッダー | 32バイトの空ヘッダーを先頭に書き込み | Generate時 |
| BR-87-04 | DWordアライメント | データはDWord境界でアライメント | 書き込み時 |
| BR-87-05 | メモリフラグ | MOVEABLE, PURE, DISCARDABLEフラグを設定 | ヘッダー書き込み時 |

### 計算ロジック

**DWordアライメント計算**:
```vb
If (Size Mod 4) <> 0 Then
    ComputeDWordAlignedOffset = 4 - (Size Mod 4)
End If
```

## データベース操作仕様

本機能はデータベースを直接操作しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentException | サポート外の型 | 対応エンコーダーがない | サポートされる型を使用する |
| ArgumentNullException | Null引数 | EncoderToAddがNothing | 有効なエンコーダーを渡す |
| InvalidOperationException | 生成済み | Generate後のAddResource | Generate前に追加する |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特になし

## セキュリティ考慮事項

特になし

## 備考

- .NET FrameworkのSystem.Resources.ResourceWriterと互換性のあるAPI
- IResourceWriterインターフェースを実装
- 標準エンコーダー：Binary, String, BitMap, Cursor, CursorGroup, Icon, IconGroup
- AddEncoderでカスタムエンコーダーを追加可能（先頭に挿入）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourceWriter.cls | `Source/CorLib/System.Resources/ResourceWriter.cls` | メンバ変数を確認 |

**主要メンバ変数（45-47行目）**:
- mWriter (BinaryWriter) - バイナリ出力
- mEncoders (ArrayList) - エンコーダーリスト
- mGenerated (Boolean) - 生成済みフラグ

#### Step 2: 初期化処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourceWriter.cls | `Source/CorLib/System.Resources/ResourceWriter.cls` | Init, Class_Initialize |

**主要処理フロー**:
- **146-154行目**: Class_Initialize - 標準エンコーダーの登録
- **156-158行目**: Init - BinaryWriter作成

#### Step 3: リソース追加処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResourceWriter.cls | `Source/CorLib/System.Resources/ResourceWriter.cls` | AddResource, EncodeResource |

**主要処理フロー**:
- **79-82行目**: AddResource - リソースの追加
- **291-302行目**: EncodeResource - エンコーダーによるエンコード

#### Step 4: ファイル生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ResourceWriter.cls | `Source/CorLib/System.Resources/ResourceWriter.cls` | Generate, WriteResources, WriteResource |

**主要処理フロー**:
- **87-91行目**: Generate - ファイル生成開始
- **190-198行目**: WriteResources - 全リソースの書き込み
- **216-271行目**: WriteResource - 個別リソースの書き込み

### プログラム呼び出し階層図

```
ResourceWriter
    │
    ├─ 初期化
    │      ├─ Init
    │      │      └─ GetStream
    │      │             ├─ FileStream (ファイルパス)
    │      │             └─ そのまま (Stream)
    │      │
    │      └─ Class_Initialize
    │             └─ mEncoders.Add (標準エンコーダー登録)
    │
    ├─ リソース追加
    │      ├─ AddResource
    │      │      └─ EncodeResource
    │      │             └─ IResourceEncoder.Encode
    │      │
    │      └─ AddEncoder (先頭に挿入)
    │
    ├─ ファイル生成
    │      └─ Generate
    │             └─ WriteResources
    │                    ├─ WriteBlankHeader
    │                    └─ WriteEncodedResources
    │                           └─ WriteResource
    │                                  ├─ EncodeStringOrInt
    │                                  └─ ComputeDWordAlignedOffset
    │
    └─ クリーンアップ
           └─ CloseWriter
                  └─ Generate (未生成の場合)
```

### データフロー図

```
[入力]                    [ResourceWriter]              [出力]

AddResource ──────┐            │
    │             │            ▼
Value ────────────┼──▶ mEncoders ──▶ IResourceEncoder.Encode
ResourceName ─────┤            │
ResourceType ─────┤            ▼
LanguageID ───────┘     内部バッファ
                              │
                              ▼
                    Generate ──▶ WriteResource
                              │
                              ▼
                         .RES ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourceWriter.cls | `Source/CorLib/System.Resources/ResourceWriter.cls` | ソース | メインクラス |
| IResourceWriter.cls | `Source/CorLib/System.Resources/IResourceWriter.cls` | ソース | インターフェース |
| IResourceEncoder.cls | `Source/CorLib/System.Resources/IResourceEncoder.cls` | ソース | エンコーダーインターフェース |
| BinaryResourceEncoder.cls | `Source/CorLib/System.Resources/BinaryResourceEncoder.cls` | ソース | バイナリエンコーダー |
| StringResourceEncoder.cls | `Source/CorLib/System.Resources/StringResourceEncoder.cls` | ソース | 文字列エンコーダー |
| BitMapResourceEncoder.cls | `Source/CorLib/System.Resources/BitMapResourceEncoder.cls` | ソース | ビットマップエンコーダー |
| IconResourceEncoder.cls | `Source/CorLib/System.Resources/IconResourceEncoder.cls` | ソース | アイコンエンコーダー |
| CursorResourceEncoder.cls | `Source/CorLib/System.Resources/CursorResourceEncoder.cls` | ソース | カーソルエンコーダー |
