# 機能設計書 88-ResourceSet

## 概要

本ドキュメントは、VBCorLibライブラリにおけるResourceSet（リソースセット）機能の設計を記述する。

### 本機能の処理概要

ResourceSetは、特定のカルチャ（ロケール）に対するリソースを格納・管理するクラスである。他のカルチャを無視し、単一カルチャのリソースのみを保持する。

**業務上の目的・背景**：多言語対応アプリケーションにおいて、特定のカルチャに属するリソースをまとめて管理する必要がある。本機能は.NET FrameworkのSystem.Resources.ResourceSetと互換性のあるAPIを提供する。

**機能の利用シーン**：
- 特定カルチャのリソースのみを取得・管理
- ResourceManagerからカルチャ別リソースセットの取得
- リソースの列挙

**主要な処理内容**：
1. IResourceReaderからのリソース読み込み
2. カルチャID（LanguageID）によるフィルタリング
3. リソースの取得（GetObject、GetString）
4. リソースの列挙

**関連システム・外部連携**：
- ResourceReader（.RESファイル読み込み）
- WinResourceReader（EXE/DLLリソース読み込み）
- ResourceManager（リソースセットの利用元）

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 該当なし | - | - | ResourceSetはライブラリ機能として他のアプリケーションから利用される |

## 機能種別

データ管理 / リソース管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CultureID | Variant | Yes | カルチャID（LCIDまたはCultureInfo） | 有効なLCID |
| Source | Variant | Yes | .RESファイルパス、StreamまたはIResourceReader | 有効なソース |
| ResourceName | Variant | Yes | リソース名 | 文字列または数値 |
| ResourceType | Variant | Yes | リソースタイプ | ResourceTypes列挙値または文字列 |

### 入力データソース

- .RESファイル
- Streamオブジェクト
- IResourceReaderオブジェクト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Resource | Variant | 取得したリソース値 |
| String | String | 文字列リソース |
| LanguageID | Long | カルチャID |

### 出力先

呼び出し元アプリケーションへの戻り値

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ カルチャIDの設定
   └─ Readerの取得
2. リソース読み込み
   └─ カルチャIDでフィルタリング
   └─ mResourcesに格納
3. リソース取得
   └─ ResourceKeyで検索
   └─ 値を返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CultureID設定]
    B --> C[Reader取得]
    C --> D{IResourceReader?}
    D -->|Yes| E[そのまま使用]
    D -->|No| F[ResourceReader作成]
    E --> G[リソース読み込みループ]
    F --> G
    G --> H{次のエントリあり?}
    H -->|Yes| I{LanguageID一致?}
    I -->|Yes| J[mResourcesに追加]
    I -->|No| H
    J --> H
    H -->|No| K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-88-01 | カルチャフィルタ | 指定カルチャIDと一致するリソースのみ格納 | リソース読み込み時 |
| BR-88-02 | クローズ後アクセス不可 | CloseResourceSet後はアクセスできない | 全メソッド |
| BR-88-03 | デフォルトReader | CorLib.ResourceReader | GetDefaultReader |
| BR-88-04 | デフォルトWriter | CorLib.ResourceWriter | GetDefaultWriter |

### 計算ロジック

特になし（検索とフィルタリングのみ）

## データベース操作仕様

本機能はデータベースを直接操作しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidOperationException | クローズ済み | CloseResourceSet後のアクセス | Close前にアクセスする |
| ArgumentNullException | Null引数 | SourceがNothing | 有効なソースを渡す |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- リソースはHashtableに格納され、O(1)で取得可能

## セキュリティ考慮事項

特になし

## 備考

- .NET FrameworkのSystem.Resources.ResourceSetと互換性のあるAPI
- IEnumerableインターフェースを実装
- Hashtableによるリソース管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResourceSet.cls | `Source/CorLib/System.Resources/ResourceSet.cls` | メンバ変数を確認 |

**主要メンバ変数（53-54行目）**:
- mResources (Hashtable) - リソースを格納
- mLanguageID (Long) - カルチャID

#### Step 2: 初期化処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourceSet.cls | `Source/CorLib/System.Resources/ResourceSet.cls` | Init, LoadResources, GetReader |

**主要処理フロー**:
- **187-190行目**: Init - カルチャIDとReaderの取得
- **192-204行目**: LoadResources - カルチャIDでフィルタリングしてHashtableに追加
- **232-245行目**: GetReader - IResourceReaderの取得

#### Step 3: リソース取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResourceSet.cls | `Source/CorLib/System.Resources/ResourceSet.cls` | GetObject, GetString |

**主要処理フロー**:
- **75-82行目**: GetObject - ResourceKeyで検索
- **90-97行目**: GetString - 文字列リソースの取得

### プログラム呼び出し階層図

```
ResourceSet
    │
    ├─ 初期化
    │      └─ Init
    │             ├─ GetLanguageID
    │             └─ LoadResources
    │                    └─ GetReader
    │                           ├─ IResourceReader (そのまま)
    │                           └─ ResourceReader (新規作成)
    │
    ├─ リソース取得
    │      ├─ GetObject
    │      │      ├─ VerifyOpen
    │      │      ├─ ResourceKey作成
    │      │      └─ mResources(Key)
    │      │
    │      └─ GetString
    │             └─ GetObject (StringResource)
    │
    ├─ 列挙
    │      └─ GetEnumerator
    │             └─ mResources.GetEnumerator
    │
    └─ クリーンアップ
           └─ CloseResourceSet
```

### データフロー図

```
[入力]                    [ResourceSet]               [出力]

IResourceReader ──┐            │
                  ├──▶ LoadResources ──▶ mResources (Hashtable)
.RES/Stream ──────┘                              │
                                                  │
                           GetObject/GetString ◀──┘
                                   │
                                   ▼
                             リソース値
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ResourceSet.cls | `Source/CorLib/System.Resources/ResourceSet.cls` | ソース | メインクラス |
| ResourceKey.cls | `Source/CorLib/System.Resources/ResourceKey.cls` | ソース | リソースキー |
| ResourceReader.cls | `Source/CorLib/System.Resources/ResourceReader.cls` | ソース | デフォルトReader |
| ResourceWriter.cls | `Source/CorLib/System.Resources/ResourceWriter.cls` | ソース | デフォルトWriter |
