# 機能設計書 89-WinResourceReader

## 概要

本ドキュメントは、VBCorLibライブラリにおけるWinResourceReader（Win32リソースリーダー）機能の設計を記述する。

### 本機能の処理概要

WinResourceReaderは、EXEやDLLファイルに埋め込まれたWin32リソースを読み込む機能を提供するクラスである。Windows APIを使用してリソースを列挙し、文字列、アイコン、カーソル、ビットマップなどのリソースを取得する。

**業務上の目的・背景**：Windowsの実行可能ファイル（EXE）やダイナミックリンクライブラリ（DLL）に埋め込まれたリソースを読み込む必要がある場合に使用する。本機能はResourceReaderと同様のインターフェースを提供し、リソースソースの違いを吸収する。

**機能の利用シーン**：
- EXE/DLLからのリソース読み込み
- ResourceManagerへのリソース提供
- Win32リソースの列挙と取得

**主要な処理内容**：
1. LoadLibraryによるファイルハンドル取得
2. EnumResourceTypesによるリソースタイプ列挙
3. リソースデータのデコード
4. リソースの列挙（IDictionaryEnumerator）
5. カスタムデコーダーの追加

**関連システム・外部連携**：
- Windows API（LoadLibrary, EnumResourceTypes, FindResource等）
- IResourceDecoder（リソースデコーダーインターフェース）
- 各種デコーダー（StringResourceDecoder, BitMapResourceDecoder等）

**権限による制御**：ファイルへの読み取りアクセス権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 該当なし | - | - | WinResourceReaderはライブラリ機能として他のアプリケーションから利用される |

## 機能種別

データアクセス / ファイル読み込み

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| FileName | String | Yes | EXE/DLLファイルパス | 有効なファイルパス |
| DecoderToAdd | IResourceDecoder | No | カスタムデコーダー | Nothingでないこと |

### 入力データソース

- EXE/DLLファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| DictionaryEntry | DictionaryEntry | キー（ResourceKey）と値（リソースデータ）のペア |
| ResourceKey | ResourceKey | リソース識別情報（名前、タイプ、言語ID） |
| ResourceValue | Variant | デコードされたリソース値 |

### 出力先

呼び出し元アプリケーションへの戻り値（列挙子経由）

## 処理フロー

### 処理シーケンス

```
1. ファイルの検証と読み込み
   └─ LoadLibraryでファイルハンドル取得
2. リソースの列挙
   └─ EnumResourceTypesでコールバック関数を呼び出し
3. リソースのデコード
   └─ 適切なデコーダーによる変換
4. リソースの返却
   └─ DictionaryEntry形式で提供
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[File.Exists確認]
    B -->|No| C[FileNotFoundException]
    B -->|Yes| D[LoadLibrary呼び出し]
    D -->|失敗| E[IOException]
    D -->|成功| F[mFileHandle保存]
    F --> G[GetEnumerator呼び出し]
    G --> H[LoadResources]
    H --> I[EnumResourceTypes呼び出し]
    I --> J[EnumResTypeProc コールバック]
    J --> K{リソースタイプあり?}
    K -->|Yes| L[EnumResourceNames]
    L --> M[EnumResNameProc コールバック]
    M --> N[EnumResourceLanguages]
    N --> O[AddResource]
    O --> P{デコーダーあり?}
    P -->|Yes| Q[デコード処理]
    P -->|No| R[バイト配列として保存]
    Q --> S[エントリ追加]
    R --> S
    S --> K
    K -->|No| T[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-89-01 | ファイル形式検証 | LoadLibraryで読み込み可能なファイルであること | 初期化時 |
| BR-89-02 | デコーダー優先 | 登録済みデコーダーがある場合はそれを使用 | リソース読み込み時 |
| BR-89-03 | バイト配列フォールバック | デコーダーがない場合はバイト配列として返す | リソース読み込み時 |
| BR-89-04 | FreeLibrary | CloseReaderでFreeLibrary呼び出し | クローズ時 |

### 計算ロジック

特になし（Windows APIに依存）

## データベース操作仕様

本機能はデータベースを直接操作しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FileNotFoundException | ファイル未検出 | ファイルが存在しない | 正しいファイルパスを指定する |
| IOException | 無効なファイル | LoadLibraryが失敗 | 有効なEXE/DLLファイルを使用する |
| InvalidOperationException | リーダークローズ | クローズ後のアクセス | CloseReader前にアクセスする |
| ArgumentNullException | Null引数 | DecoderToAddがNothing | 有効なデコーダーを渡す |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- リソースは列挙時に一括読み込みされる

## セキュリティ考慮事項

- 外部のEXE/DLLファイルを読み込むため、信頼できないソースからのファイルに注意
- LoadLibraryを使用するため、DLLサイドローディング攻撃に注意

## 備考

- IResourceReaderインターフェースを実装
- ResourceReaderと同じデコーダーを使用可能
- Windows API（kernel32.dll）に依存
- コールバック関数はモジュールレベルで定義（EnumResTypeProc等）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WinResourceReader.cls | `Source/CorLib/System.Resources/WinResourceReader.cls` | メンバ変数を確認 |

**主要メンバ変数（61-63行目）**:
- mEntries (ArrayList) - リソースエントリのリスト
- mDecoders (Hashtable) - デコーダーのマップ
- mFileHandle (Long) - ファイルハンドル

#### Step 2: 初期化処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WinResourceReader.cls | `Source/CorLib/System.Resources/WinResourceReader.cls` | Init, Class_Initialize |

**主要処理フロー**:
- **169-179行目**: Class_Initialize - 標準デコーダーの登録
- **181-188行目**: Init - ファイル存在確認とLoadLibrary呼び出し

#### Step 3: リソース読み込み処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WinResourceReader.cls | `Source/CorLib/System.Resources/WinResourceReader.cls` | LoadResources, AddResource |

**主要処理フロー**:
- **223-236行目**: LoadResources - EnumResourceTypes呼び出し
- **194-211行目**: AddResource - デコーダーによるデコードとエントリ追加

#### Step 4: コールバック関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | modWinResourceReaderHelpers.bas | `Source/CorLib/System.Resources/modWinResourceReaderHelpers.bas` | EnumResTypeProc, EnumResNameProc, EnumResLangProc |

### プログラム呼び出し階層図

```
WinResourceReader
    │
    ├─ 初期化
    │      ├─ Init
    │      │      ├─ File.Exists
    │      │      └─ LoadLibrary (kernel32.dll)
    │      │
    │      └─ Class_Initialize
    │             └─ AddDecoder (標準デコーダー登録)
    │
    ├─ リソース読み込み
    │      ├─ GetEnumerator
    │      │      └─ LoadResources
    │      │             └─ EnumResourceTypes
    │      │                    └─ EnumResTypeProc (コールバック)
    │      │                           └─ EnumResourceNames
    │      │                                  └─ EnumResNameProc (コールバック)
    │      │                                         └─ EnumResourceLanguages
    │      │                                                └─ EnumResLangProc (コールバック)
    │      │                                                       └─ AddResource
    │      │
    │      └─ AddResource
    │             ├─ IResourceDecoder.Decode
    │             └─ IResourceDecoder.GetResource
    │
    └─ クリーンアップ
           └─ CloseReader
                  └─ FreeLibrary
```

### データフロー図

```
[入力]                    [WinResourceReader]            [出力]

EXE/DLL ──▶ LoadLibrary ──▶ mFileHandle
                               │
                               ▼
              EnumResourceTypes ──▶ EnumResTypeProc
                                          │
                                          ▼
                               EnumResourceNames ──▶ EnumResNameProc
                                                          │
                                                          ▼
                                               EnumResourceLanguages ──▶ EnumResLangProc
                                                                              │
                                                                              ▼
                                                                       AddResource
                                                                              │
                                                                              ▼
                                                                    mEntries (ArrayList)
                                                                              │
                                                                              ▼
                                                                   DictionaryEntry[]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WinResourceReader.cls | `Source/CorLib/System.Resources/WinResourceReader.cls` | ソース | メインクラス |
| modWinResourceReaderHelpers.bas | `Source/CorLib/System.Resources/modWinResourceReaderHelpers.bas` | ソース | コールバック関数 |
| IResourceReader.cls | `Source/CorLib/System.Resources/IResourceReader.cls` | ソース | インターフェース |
| IResourceDecoder.cls | `Source/CorLib/System.Resources/IResourceDecoder.cls` | ソース | デコーダーインターフェース |
| ResourceEnumerator.cls | `Source/CorLib/System.Resources/ResourceEnumerator.cls` | ソース | 列挙子 |
