# 機能設計書 9-OperatingSystem

## 概要

本ドキュメントは、VBCorLibライブラリにおけるオペレーティングシステム情報機能（OperatingSystem）の設計を記述する。OperatingSystemクラスは、.NET Frameworkの`System.OperatingSystem`クラスに相当するOS情報（プラットフォーム、バージョン、サービスパック）の表現機能を提供するクラスである。

### 本機能の処理概要

OperatingSystemクラスは、現在実行中のOSの情報（プラットフォームID、バージョン、サービスパック）を保持し、文字列表現やクローン生成を行う機能を提供する。

**業務上の目的・背景**：アプリケーションは実行環境のOS情報を必要とする場合がある。OperatingSystemはOSの種類、バージョン、サービスパックなどの情報を構造化して保持し、OS依存の処理分岐や動作要件の確認を容易にする。

**機能の利用シーン**：OS情報の確認を必要とする場面で利用される。具体的には、プラットフォーム依存機能の利用可否判定、OSバージョンに応じたAPI選択、互換性チェック、ログへのシステム情報記録、最小動作環境の確認などの場面で活用される。

**主要な処理内容**：
1. OS情報の取得（Platform、Version、ServicePack）
2. バージョン文字列の取得（VersionString）
3. 文字列変換（ToString）
4. クローン生成（Clone）

**関連システム・外部連携**：Environmentクラスから生成・使用される。Versionクラスを使用してOSバージョンを表現する。

**権限による制御**：権限による制御は行わない。全てのメソッドは同一の動作を行う。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないユーティリティクラスである |

## 機能種別

データ保持 / システム情報表現

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Platform | PlatformID | Yes | プラットフォーム識別子 | 列挙値 |
| Version | Version | Yes | OSバージョン | Versionオブジェクト |
| ServicePack | String | No | サービスパック名 | なし |

### 入力データソース

Environment.OSVersionで生成される

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| プラットフォーム | PlatformID | Platformプロパティ |
| バージョン | Version | Versionプロパティ |
| サービスパック | String | ServicePackプロパティ |
| バージョン文字列 | String | VersionStringプロパティ |
| クローン | OperatingSystem | Cloneの戻り値 |

### 出力先

呼び出し元への戻り値

## 処理フロー

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|プロパティ取得| C[内部値を返す]
    B -->|VersionString| D{キャッシュあり?}
    D -->|あり| E[キャッシュを返す]
    D -->|なし| F[OS名+バージョン+SP生成]
    F --> G[キャッシュに保存]
    G --> E
    B -->|Clone| H[新規インスタンス生成]
    C --> I[終了]
    E --> I
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 不変オブジェクト | 初期化後は値を変更不可 | 全プロパティ |
| BR-02 | バージョン文字列キャッシュ | VersionStringは初回生成後キャッシュ | VersionString |
| BR-03 | プラットフォーム名決定 | PlatformIDからOS名を決定 | VersionString |

### PlatformID列挙型

| 値 | 名前 | 説明 |
|----|------|------|
| 0 | Win32S | 16ビットWindowsで32ビット機能にアクセス |
| 1 | Win32Windows | Windows 95, 98, ME |
| 2 | Win32NT | Windows NT4.0, 2000, XP, Server 2003以降 |
| 3 | WinCE | Windows CE（PDA等） |

### 計算ロジック

**VersionStringの生成**
1. PlatformIDから基本OS名を決定
   - Win32NT → "Microsoft Windows NT"
   - Win32S → "Microsoft Win32S"
   - Win32Windows → バージョンに応じて"Windows 95"または"Windows 98"
   - WinCE → "Microsoft Windows CE"
2. バージョン番号を連結
3. サービスパックがあれば追加

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 通常エラーは発生しない | - |

## 備考

- IObject、ICloneableインターフェースを実装
- 永続化可能（Persistable = 1）
- Environment.OSVersionで主に使用される
- Windows 95/98/MEではサービスパック情報は空文字列

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | 57-62行目: PlatformID列挙型 |
| 1-2 | OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | 65-68行目: 内部変数 |
| 1-3 | OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | 76-78行目: ServicePackプロパティ |
| 1-4 | OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | 85-87行目: Platformプロパティ |
| 1-5 | OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | 94-96行目: Versionプロパティ |
| 1-6 | OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | 103-105行目: Cloneメソッド |
| 1-7 | OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | 112-141行目: VersionStringプロパティ |
| 1-8 | OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | 148-150行目: ToStringメソッド |
| 1-9 | OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | 192-196行目: Initメソッド |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OperatingSystem.cls | `Source/CorLib/System/OperatingSystem.cls` | ソース | OS情報のメインクラス |
| Version.cls | `Source/CorLib/System/Version.cls` | ソース | バージョン番号クラス |
| Environment.cls | `Source/CorLib/System/Environment.cls` | ソース | OSVersionプロパティで使用 |
