# 機能設計書 90-Registry

## 概要

本ドキュメントは、VBCorLibライブラリにおけるRegistry（レジストリアクセス）機能の設計を記述する。

### 本機能の処理概要

Registryは、Windowsレジストリへのアクセスを提供するクラスである。ルートキー（HKEY_CLASSES_ROOT、HKEY_CURRENT_USER等）へのアクセスと、キー・値の読み書き機能を提供する。

**業務上の目的・背景**：Windowsアプリケーションにおいて、設定情報や構成データをレジストリに保存・取得する必要がある。本機能は.NET FrameworkのMicrosoft.Win32.Registryと互換性のあるAPIを提供する。

**機能の利用シーン**：
- アプリケーション設定の保存・取得
- ファイル拡張子とアプリケーションの関連付け
- システム構成情報の取得
- ユーザー固有の設定管理

**主要な処理内容**：
1. ルートキー（ClassesRoot、CurrentUser等）へのアクセス
2. レジストリ値の取得（GetValue）
3. レジストリ値の設定（SetValue）
4. サブキーの作成・削除・列挙

**関連システム・外部連携**：
- Windows Registry API（advapi32.dll）
- RegistryKeyクラス

**権限による制御**：レジストリキーへの読み取り/書き込み権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 該当なし | - | - | Registryはライブラリ機能として他のアプリケーションから利用される |

## 機能種別

システムアクセス / レジストリ操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| KeyName | String | Yes | フルレジストリキー名（ルートキー含む） | 有効なルートキー名で開始 |
| ValueName | String | Yes | 値の名前 | 最大16383文字 |
| DefaultValue | Variant | No | 値が存在しない場合の既定値 | なし |
| Value | Variant | Yes | 設定する値 | 型に応じた値 |

### 入力データソース

- Windowsレジストリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| RegistryKey | RegistryKey | ルートキーオブジェクト |
| Value | Variant | 取得したレジストリ値 |

### 出力先

呼び出し元アプリケーションへの戻り値

## 処理フロー

### 処理シーケンス

```
1. ルートキーへのアクセス
   └─ 対応するRegistryKeyオブジェクトを返却
2. 値の取得
   └─ キー名からルートとサブキーを分離
   └─ サブキーを開いて値を取得
3. 値の設定
   └─ キー名からルートとサブキーを分離
   └─ サブキーを作成/開いて値を設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|ルートキー取得| C[対応するmXXXを返却]
    B -->|GetValue| D[GetSubKey呼び出し]
    B -->|SetValue| E[GetSubKey呼び出し]
    D --> F[キー名を解析]
    E --> F
    F --> G[GetRootKey呼び出し]
    G --> H{ルートキー有効?}
    H -->|No| I[Argument例外]
    H -->|Yes| J{Writable?}
    J -->|Yes| K[CreateSubKey]
    J -->|No| L[OpenSubKey]
    K --> M[値の設定/取得]
    L --> M
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-90-01 | ルートキー名検証 | HKEY_で始まる有効なルートキー名であること | GetRootKey |
| BR-90-02 | サブキー作成 | SetValueは必要に応じてサブキーを作成 | SetValue |
| BR-90-03 | 値名最大長 | 値名は16383文字以下 | GetValue, SetValue |
| BR-90-04 | キー名最大長 | 各キー名は255文字以下 | OpenSubKey, CreateSubKey |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを直接操作しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentException | 引数エラー | 無効なルートキー名 | 有効なルートキー名を使用 |
| ArgumentException | 引数エラー | 値名が16383文字超過 | 短い値名を使用 |
| UnauthorizedAccessException | アクセス拒否 | 書き込み権限なし | 適切な権限でキーを開く |
| ObjectDisposedException | オブジェクト破棄 | CloseKey後のアクセス | CloseKey前にアクセス |
| Win32Exception | Windowsエラー | Registry API失敗 | エラーコードを確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（レジストリ操作はトランザクション非対応）

## パフォーマンス要件

- ルートキーはClass_Initializeで一度だけ作成される
- Flushは必要な場合のみ呼び出す（パフォーマンスに影響）

## セキュリティ考慮事項

- レジストリへの書き込みには適切な権限が必要
- HKEY_LOCAL_MACHINEへの書き込みは管理者権限が必要な場合がある
- 機密情報をレジストリに保存する場合は暗号化を検討

## 備考

- .NET FrameworkのMicrosoft.Win32.Registryと互換性のあるAPI
- RegistryKeyクラスと連携して動作
- 6つのルートキーをサポート（ClassesRoot, CurrentConfig, CurrentUser, LocalMachine, PerformanceData, Users）
- REG_DWORD, REG_QWORD, REG_SZ, REG_BINARY, REG_MULTI_SZ, REG_EXPAND_SZをサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Registry.cls | `Source/CorLib/Microsoft.Win32/Registry.cls` | メンバ変数を確認 |

**主要メンバ変数（53-58行目）**:
- mClassesRoot (RegistryKey) - HKEY_CLASSES_ROOT
- mCurrentConfig (RegistryKey) - HKEY_CURRENT_CONFIG
- mCurrentUser (RegistryKey) - HKEY_CURRENT_USER
- mLocalMachine (RegistryKey) - HKEY_LOCAL_MACHINE
- mPerformanceData (RegistryKey) - HKEY_PERFORMANCE_DATA
- mUsers (RegistryKey) - HKEY_USERS

#### Step 2: 初期化処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Registry.cls | `Source/CorLib/Microsoft.Win32/Registry.cls` | Class_Initialize |

**主要処理フロー**:
- **198-205行目**: Class_Initialize - 6つのルートキーをRegistryKeyオブジェクトとして作成

#### Step 3: ルートキー取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Registry.cls | `Source/CorLib/Microsoft.Win32/Registry.cls` | ClassesRoot, CurrentUser等のプロパティ |

**主要処理フロー**:
- **69-71行目**: ClassesRoot - HKEY_CLASSES_ROOT
- **78-80行目**: CurrentConfig - HKEY_CURRENT_CONFIG
- **87-89行目**: CurrentUser - HKEY_CURRENT_USER
- **95-97行目**: LocalMachine - HKEY_LOCAL_MACHINE
- **103-105行目**: PerformanceData - HKEY_PERFORMANCE_DATA
- **111-113行目**: Users - HKEY_USERS

#### Step 4: 値の取得・設定処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Registry.cls | `Source/CorLib/Microsoft.Win32/Registry.cls` | GetValue, SetValue |
| 4-2 | Registry.cls | `Source/CorLib/Microsoft.Win32/Registry.cls` | GetRootKey, GetSubKey |

**主要処理フロー**:
- **127-132行目**: GetValue - サブキーを開いて値を取得
- **145-150行目**: SetValue - サブキーを作成/開いて値を設定
- **156-173行目**: GetRootKey - ルートキー名からRegistryKeyを取得
- **175-192行目**: GetSubKey - フルパスからサブキーを開く/作成

#### Step 5: RegistryKeyクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | RegistryKey.cls | `Source/CorLib/Microsoft.Win32/RegistryKey.cls` | メンバ変数、主要メソッド |

**主要メンバ変数（119-121行目）**:
- mHKey (Long) - レジストリハンドル
- mName (String) - キー名
- mWritable (Boolean) - 書き込み可能フラグ

**主要メソッド**:
- **144-155行目**: OpenSubKey - サブキーを開く
- **191-203行目**: CreateSubKey - サブキーを作成
- **352-380行目**: SetValue - 値を設定
- **402-476行目**: GetValue - 値を取得
- **269-290行目**: GetSubKeyNames - サブキー名一覧取得
- **304-325行目**: GetValueNames - 値名一覧取得

### プログラム呼び出し階層図

```
Registry
    │
    ├─ 初期化
    │      └─ Class_Initialize
    │             └─ Cor.NewRegistryKey (6回)
    │
    ├─ ルートキー取得
    │      ├─ ClassesRoot → mClassesRoot
    │      ├─ CurrentConfig → mCurrentConfig
    │      ├─ CurrentUser → mCurrentUser
    │      ├─ LocalMachine → mLocalMachine
    │      ├─ PerformanceData → mPerformanceData
    │      └─ Users → mUsers
    │
    ├─ 値の取得
    │      └─ GetValue
    │             └─ GetSubKey (Writable=False)
    │                    ├─ GetRootKey
    │                    └─ Root.OpenSubKey
    │                           └─ RegOpenKeyEx (advapi32.dll)
    │
    └─ 値の設定
           └─ SetValue
                  └─ GetSubKey (Writable=True)
                         ├─ GetRootKey
                         └─ Root.CreateSubKey
                                └─ RegCreateKeyEx (advapi32.dll)

RegistryKey
    │
    ├─ キー操作
    │      ├─ OpenSubKey
    │      │      └─ RegOpenKeyEx
    │      ├─ CreateSubKey
    │      │      └─ RegCreateKeyEx
    │      ├─ DeleteSubKey
    │      │      └─ RegDeleteKey
    │      ├─ DeleteSubKeyTree
    │      │      └─ 再帰的にDeleteSubKeyTree
    │      └─ CloseKey
    │             └─ RegCloseKey
    │
    ├─ 値操作
    │      ├─ GetValue
    │      │      └─ RegQueryValueEx
    │      ├─ SetValue
    │      │      ├─ SetValueDWord → RegSetValueEx
    │      │      ├─ SetValueSZ → RegSetValueEx
    │      │      ├─ SetValueMultiSZ → RegSetValueEx
    │      │      ├─ SetValueExpandSZ → RegSetValueEx
    │      │      ├─ SetValueBinary → RegSetValueEx
    │      │      └─ SetValueQWord → RegSetValueEx
    │      └─ DeleteValue
    │             └─ RegDeleteValue
    │
    └─ 列挙
           ├─ GetSubKeyNames
           │      └─ RegEnumKeyEx
           └─ GetValueNames
                  └─ RegEnumValue
```

### データフロー図

```
[入力]                    [Registry/RegistryKey]           [出力]

フルキー名 ──▶ GetRootKey ──▶ ルートキー (RegistryKey)
     "HKEY_CURRENT_USER\..."        │
                                    ▼
                           GetSubKey ──▶ サブキー (RegistryKey)
                                              │
                                              ▼
               ┌──────────────────────────────┴──────────────────────────────┐
               │                                                              │
               ▼                                                              ▼
          GetValue                                                       SetValue
               │                                                              │
               ▼                                                              ▼
    RegQueryValueEx ──▶ 値 (Variant)                         値 ──▶ RegSetValueEx
               │                                                              │
               │         [型変換]                                             │
               ├─ REG_SZ ──▶ String                String ──▶ REG_SZ ─────────┤
               ├─ REG_DWORD ──▶ Long               Long ──▶ REG_DWORD ────────┤
               ├─ REG_BINARY ──▶ Byte()            Byte() ──▶ REG_BINARY ─────┤
               ├─ REG_MULTI_SZ ──▶ String()        String() ──▶ REG_MULTI_SZ ─┤
               ├─ REG_EXPAND_SZ ──▶ String         String ──▶ REG_EXPAND_SZ ──┤
               └─ REG_QWORD ──▶ Int64              Int64 ──▶ REG_QWORD ───────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Registry.cls | `Source/CorLib/Microsoft.Win32/Registry.cls` | ソース | メインクラス（ルートキー提供） |
| RegistryKey.cls | `Source/CorLib/Microsoft.Win32/RegistryKey.cls` | ソース | レジストリキー操作クラス |
| RegistryKeyStatic.cls | `Source/CorLib/Microsoft.Win32/RegistryKeyStatic.cls` | ソース | 静的メソッド |
| modWin32Api.bas | `Source/CorLib/modWin32Api.bas` | ソース | Windows API宣言 |
