# 機能設計書 92-Thread

## 概要

本ドキュメントは、VBCorLibライブラリにおけるThread機能の設計を記述するものである。Threadは、スレッドの作成と制御、優先度設定、および状態取得を提供するクラスである。

### 本機能の処理概要

Threadクラスは、現在実行中のスレッドの情報へのアクセスを提供する。VB6/VBAはシングルスレッド環境であるため、このクラスは主にカルチャ情報の管理に使用される。

**業務上の目的・背景**：.NET Frameworkとの互換性を維持しつつ、VB6/VBAアプリケーションでスレッド関連の概念（特にカルチャ情報）を扱う手段を提供する。国際化対応アプリケーションでは、現在のスレッドのカルチャ設定に基づいて日付や数値のフォーマットを決定する必要がある。

**機能の利用シーン**：アプリケーションの国際化・ローカライゼーション、日付・時刻・数値のカルチャ依存フォーマット、言語・地域に応じた処理の切り替えに使用される。

**主要な処理内容**：
1. 現在のスレッドの取得（CurrentThread）- 現在実行中のスレッドオブジェクトを取得
2. カルチャ情報の取得・設定（CurrentCulture）- スレッドに関連付けられたカルチャ情報を管理

**関連システム・外部連携**：システムデフォルトのロケールID（LCID）をWindows API（GetSystemDefaultLCID）経由で取得する。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連なし |

## 機能種別

システム情報取得 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Value | CultureInfo | Yes | 設定するカルチャ情報 | Nothingの場合ArgumentNullException |

### 入力データソース

- システムデフォルトLCID（初回取得時）
- アプリケーションからの直接設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CurrentThread | Thread | 現在実行中のスレッドオブジェクト |
| CurrentCulture | CultureInfo | スレッドのカルチャ情報 |

### 出力先

- 呼び出し元への戻り値

## 処理フロー

### 処理シーケンス

```
1. CurrentThread取得
   └─ ThreadStatic経由で現在のスレッドオブジェクトを取得

2. CurrentCulture取得
   └─ mCurrentCultureがNothingの場合、システムLCIDから新規生成
   └─ 生成したCultureInfoをReadOnlyとしてマーク
   └─ キャッシュされたCultureInfoを返却

3. CurrentCulture設定
   └─ Nothingの場合はArgumentNullException
   └─ 新しいCultureInfoを設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{CurrentCulture取得?}
    B -->|Yes| C{mCurrentCultureはNothing?}
    C -->|Yes| D[GetSystemDefaultLCID呼び出し]
    D --> E[NewCultureInfo生成]
    E --> F[MarkReadOnly呼び出し]
    F --> G[mCurrentCultureに保存]
    C -->|No| H[キャッシュ済みを返却]
    G --> H
    B -->|No - 設定| I{ValueはNothing?}
    I -->|Yes| J[ArgumentNullException]
    I -->|No| K[mCurrentCultureに設定]
    H --> L[終了]
    K --> L
    J --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-92-01 | Null禁止 | CurrentCultureにNothingは設定不可 | CurrentCulture設定時 |
| BR-92-02 | 初期化遅延 | CurrentCultureは初回アクセス時に初期化 | 初回CurrentCulture取得時 |
| BR-92-03 | ReadOnly設定 | 自動生成されたCultureInfoはReadOnlyとなる | CurrentCulture自動生成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentNull | ArgumentNullException | CurrentCultureにNothingを設定 | 有効なCultureInfoを設定する |

### リトライ仕様

特になし

## トランザクション仕様

該当なし

## パフォーマンス要件

- CurrentCultureは初回アクセス時のみCultureInfoを生成（遅延初期化）
- 以降のアクセスはキャッシュされたオブジェクトを返却

## セキュリティ考慮事項

特になし

## 備考

- VB6/VBAはシングルスレッド環境のため、Thread機能は限定的
- .NET FrameworkのSystem.Threading.Threadクラスの一部機能を実装
- 主にカルチャ情報管理のために使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Threadクラスはシンプルな構造で、主にCultureInfoへの参照を保持する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Thread.cls | `Source/CorLib/System.Threading/Thread.cls` | プライベート変数mCurrentCulture（43行目）がカルチャ情報を保持 |

**読解のコツ**: VB6のPrivate変数は先頭に"m"を付ける命名規則を使用している。

#### Step 2: エントリーポイントを理解する

ThreadStaticクラスが現在のスレッドオブジェクトへのアクセスを提供する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ThreadStatic.cls | `Source/CorLib/System.Threading/ThreadStatic.cls` | CurrentThread（46-48行目）がシングルトンのThreadを返す |

**主要処理フロー**:
1. **39行目**: mCurrentThreadがモジュールレベルで宣言（New Thread）
2. **46-48行目**: CurrentThread - シングルトンパターンでThreadを返却

#### Step 3: コア機能を理解する

Threadクラスのカルチャ管理機能を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Thread.cls | `Source/CorLib/System.Threading/Thread.cls` | CurrentCulture Get（52-59行目）で遅延初期化 |
| 3-2 | Thread.cls | `Source/CorLib/System.Threading/Thread.cls` | CurrentCulture Set（77-82行目）でカルチャ設定 |

**主要処理フロー**:
- **52-59行目**: CurrentCulture Get - mCurrentCultureがNothingなら、GetSystemDefaultLCIDでLCIDを取得しCultureInfoを生成
- **55行目**: MarkReadOnlyで変更不可に設定
- **77-82行目**: CurrentCulture Set - Nothingチェック後、新しいCultureInfoを設定

### プログラム呼び出し階層図

```
ThreadStatic.CurrentThread
    │
    └─ Thread（シングルトン）
           │
           ├─ CurrentCulture Get
           │      ├─ GetSystemDefaultLCID（Windows API）
           │      └─ Cor.NewCultureInfo
           │             └─ CultureInfo.MarkReadOnly
           │
           └─ CurrentCulture Set
                  └─ mCurrentCultureへの代入
```

### データフロー図

```
[入力]                    [処理]                         [出力]

（なし - 初回取得時） ─────▶ GetSystemDefaultLCID ─────▶ LCID
                                │
                                ▼
                         NewCultureInfo ─────────────▶ CultureInfo
                                │
                                ▼
                         MarkReadOnly
                                │
CultureInfo ──────────────▶ CurrentCulture Set ──────▶ mCurrentCulture更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Thread.cls | `Source/CorLib/System.Threading/Thread.cls` | ソース | スレッド操作の実装（カルチャ管理） |
| ThreadStatic.cls | `Source/CorLib/System.Threading/ThreadStatic.cls` | ソース | 現在のスレッドへのアクセス提供 |
