# 機能設計書 93-Ticker

## 概要

本ドキュメントは、VBCorLibライブラリにおけるTicker機能の設計を記述するものである。Tickerは、繰り返しタイマーイベントを提供するクラスである。

### 本機能の処理概要

Tickerクラスは、指定された間隔で繰り返し発生するタイマーイベントを提供する。イベント方式とコールバック方式の2つの通知方法をサポートしている。

**業務上の目的・背景**：アプリケーションで定期的な処理（データの自動更新、UIのリフレッシュ、ポーリング処理など）を実行するためのタイマー機能が必要である。TickerクラスはWindows APIのSetTimerをラップし、.NET風のインターフェースで使いやすいタイマー機能を提供する。

**機能の利用シーン**：定期的なデータ更新、アニメーション処理、ポーリング処理、タイムアウト監視、バックグラウンドタスクのスケジューリングに使用される。

**主要な処理内容**：
1. タイマーの開始（StartTicker）- 指定間隔でタイマーを開始
2. タイマーの停止（StopTicker）- タイマーを停止
3. イベント発生（Elapsed）- タイマー間隔到達時にイベントを発生
4. コールバック呼び出し - 設定されている場合、コールバック関数を呼び出し
5. 自動リセット制御（AutoReset）- 繰り返し/単発の切り替え

**関連システム・外部連携**：Windows API（SetTimer、KillTimer）を使用してタイマー機能を実現。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | Simple Ticker (Event版) | 主画面 | Tickerオブジェクトのイベント通知機能デモ（タイマー開始、停止、インターバル設定、Elapsedイベント） |
| 5 | Simple Ticker 2 (Callback版) | 主画面 | Tickerオブジェクトのコールバック通知機能デモ（タイマー開始、停止、インターバル設定、コールバック関数呼び出し） |

## 機能種別

タイマー処理 / イベント発生

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Interval | Long | Yes | タイマー間隔（ミリ秒） | 0以上（負の値はArgumentOutOfRangeException） |
| Data | Variant | No | ユーザー定義データ | - |
| AutoReset | Boolean | No | 繰り返し実行（デフォルト: True） | - |
| AddressOfCallback | Long | No | コールバック関数のアドレス | - |

### 入力データソース

- アプリケーションからの直接設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Elapsed | Event | タイマー間隔到達時に発生するイベント |
| Enabled | Boolean | タイマーの実行状態 |
| Interval | Long | 現在のタイマー間隔 |
| AutoReset | Boolean | 繰り返し設定 |
| Data | Variant | ユーザー定義データ |

### 出力先

- Elapsedイベントハンドラ
- コールバック関数

## 処理フロー

### 処理シーケンス

```
1. Ticker初期化
   └─ Init: Interval、AutoReset、Data、Callbackを設定

2. タイマー開始
   └─ StartTicker: 既存タイマーを停止し、新しくSetTimerで開始
   └─ TimerIdをHashtableに登録

3. タイマーイベント発生
   └─ TickerCallback: WM_TIMERメッセージを受信
   └─ OnElapsed: AutoResetに応じて停止判定
   └─ Elapsedイベント発生
   └─ コールバック関数呼び出し（設定されている場合）

4. タイマー停止
   └─ StopTicker: KillTimerでタイマーを停止
   └─ HashtableからTimerIdを削除
```

### フローチャート

```mermaid
flowchart TD
    A[StartTicker] --> B[StopTicker呼び出し]
    B --> C{Interval > 0?}
    C -->|Yes| D[SetTimer API呼び出し]
    D --> E[mTimerIdを保存]
    E --> F[HashtableにWeakRef登録]
    C -->|No| G[終了]
    F --> H[WM_TIMER受信待ち]
    H --> I[TickerCallback]
    I --> J[OnElapsed呼び出し]
    J --> K{AutoReset?}
    K -->|No| L[StopTicker]
    K -->|Yes| M[継続]
    L --> N[Elapsedイベント発生]
    M --> N
    N --> O{Callback設定?}
    O -->|Yes| P[Callback.Invoke]
    O -->|No| Q[終了]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-93-01 | 負の間隔禁止 | Intervalに負の値は設定不可 | Interval設定時 |
| BR-93-02 | 自動リスタート | タイマー実行中にIntervalを変更すると自動的にリスタート | Interval変更時かつEnabled=True |
| BR-93-03 | デフォルトAutoReset | AutoResetのデフォルトはTrue | 初期化時 |
| BR-93-04 | WeakReference | Tickerへの参照はWeakReferenceで保持 | タイマー登録時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentOutOfRange_NeedNonNegNum | ArgumentOutOfRangeException | Intervalに負の値を設定 | 0以上の値を設定 |
| Win32Error | Win32Exception | SetTimerが0を返した場合 | システムリソースを確認 |

### リトライ仕様

特になし

## トランザクション仕様

該当なし

## パフォーマンス要件

- タイマー精度はWindows APIの制限に依存（通常10-15ミリ秒程度）
- 多数のTickerを同時に使用する場合はシステムリソースに注意

## セキュリティ考慮事項

- コールバック関数のアドレスはAddressOfで取得した有効なアドレスである必要がある
- 不正なコールバックアドレスはクラッシュの原因となる

## 備考

- .NET FrameworkのSystem.Timers.Timerクラスに類似した機能
- WithEventsでイベントを受け取るか、コールバック関数で処理するかを選択可能
- Class_TerminateでStopTickerが自動呼び出しされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Tickerクラスの内部状態を管理する変数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Ticker.cls | `Source/CorLib/System.Threading/Ticker.cls` | プライベート変数（84-89行目）：mInterval、mAutoReset、mTimerId、mData、mDelegate、mCallback |

**読解のコツ**: mTimerIdが0の場合はタイマー未実行、0以外の場合は実行中を示す。

#### Step 2: エントリーポイントを理解する

タイマーの開始と停止のメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Ticker.cls | `Source/CorLib/System.Threading/Ticker.cls` | StartTicker（209-215行目）でタイマー開始 |
| 2-2 | Ticker.cls | `Source/CorLib/System.Threading/Ticker.cls` | StopTicker（220-224行目）でタイマー停止 |

**主要処理フロー**:
1. **209-215行目**: StartTicker - まずStopTickerで既存タイマーを停止し、Interval > 0ならTickerShared.StartTickerで新タイマー開始
2. **220-224行目**: StopTicker - EnabledならTickerShared.StopTickerでタイマー停止

#### Step 3: ヘルパーモジュールを理解する

TickerShared.basがWindows APIとの橋渡しを行う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TickerShared.bas | `Source/CorLib/System.Threading/TickerShared.bas` | StartTicker（36-46行目）でSetTimer呼び出し |
| 3-2 | TickerShared.bas | `Source/CorLib/System.Threading/TickerShared.bas` | TickerCallback（58-89行目）でWM_TIMERを処理 |

**主要処理フロー**:
- **36-46行目**: StartTicker - SetTimerでタイマー作成、HashtableにWeakReferenceを登録
- **48-53行目**: StopTicker - HashtableからTimerIdを削除、KillTimerでタイマー破棄
- **58-89行目**: TickerCallback - WM_TIMER受信時にTickerのOnElapsedを呼び出し

#### Step 4: イベント発生処理を理解する

OnElapsedメソッドでイベントとコールバックを発生させる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Ticker.cls | `Source/CorLib/System.Threading/Ticker.cls` | OnElapsed（255-265行目）でイベント発生 |

**主要処理フロー**:
- **256-258行目**: AutoResetがFalseならStopTickerを呼び出し
- **260行目**: RaiseEvent Elapsed(mData)でイベント発生
- **262-264行目**: mCallbackが設定されていればCallback.Invokeを呼び出し

### プログラム呼び出し階層図

```
Ticker.StartTicker
    │
    ├─ Ticker.StopTicker
    │      └─ TickerShared.StopTicker
    │             ├─ Hashtable.Remove
    │             └─ KillTimer（Windows API）
    │
    └─ TickerShared.StartTicker
           ├─ SetTimer（Windows API）
           └─ Hashtable.Add（WeakReference）

Windows Message Loop
    │
    └─ TickerCallback（WM_TIMER）
           │
           └─ Ticker.OnElapsed
                  ├─ StopTicker（AutoReset=False時）
                  ├─ RaiseEvent Elapsed
                  └─ mCallback.Invoke（設定時）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Interval ─────────────▶ Ticker.StartTicker ────────────▶ mTimerId（タイマーID）
                              │
                              ▼
                        SetTimer API
                              │
（WM_TIMERメッセージ） ─────▶ TickerCallback ─────────────▶ OnElapsed呼び出し
                              │
                              ▼
                        Ticker.OnElapsed
                              │
                              ├─────────────────────────▶ Elapsedイベント
                              │
                              └─────────────────────────▶ Callback.Invoke
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Ticker.cls | `Source/CorLib/System.Threading/Ticker.cls` | ソース | タイマー機能の実装 |
| TickerShared.bas | `Source/CorLib/System.Threading/TickerShared.bas` | ソース | Windows API呼び出しとコールバック管理 |
| SimpleTicker.vbp | `Examples/Misc/SimpleTicker/SimpleTicker.vbp` | サンプル | イベント方式のデモ |
| SimpleTicker2.vbp | `Examples/Misc/SimpleTicker2/SimpleTicker2.vbp` | サンプル | コールバック方式のデモ |
