---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-CorArray.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的な数値**：実測データなし
  2. **CallbackSorterの詳細実装**：別ファイルのため未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/CorArray.cls` 38-44行目（モジュールコメント）
- E-02: `Source/CorLib/System/CorArray.cls` 52-61行目（構造体定義）
- E-03: `Source/CorLib/System/CorArray.cls` 86-88行目（Existsメソッド）
- E-04: `Source/CorLib/System/CorArray.cls` 112-121行目（Findメソッド）
- E-05: `Source/CorLib/System/CorArray.cls` 151-184行目（FindIndexメソッド）
- E-06: `Source/CorLib/System/CorArray.cls` 209-226行目（FindAllメソッド）
- E-07: `Source/CorLib/System/CorArray.cls` 324-333行目（FindLastメソッド）
- E-08: `Source/CorLib/System/CorArray.cls` 359-392行目（FindLastIndexメソッド）
- E-09: `Source/CorLib/System/CorArray.cls` 412-432行目（TrueForAllメソッド）
- E-10: `Source/CorLib/System/CorArray.cls` 449-464行目（ForEachメソッド）
- E-11: `Source/CorLib/System/CorArray.cls` 491-494行目（BinarySearchメソッド）
- E-12: `Source/CorLib/System/CorArray.cls` 526-529行目（BinarySearchExメソッド）
- E-13: `Source/CorLib/System/CorArray.cls` 557-592行目（Clearメソッド）
- E-14: `Source/CorLib/System/CorArray.cls` 641-648行目（Copyメソッド）
- E-15: `Source/CorLib/System/CorArray.cls` 707-778行目（CopyExメソッド）
- E-16: `Source/CorLib/System/CorArray.cls` 812-846行目（CreateInstanceメソッド）
- E-17: `Source/CorLib/System/CorArray.cls` 854-859行目（Lengthメソッド）
- E-18: `Source/CorLib/System/CorArray.cls` 869-882行目（GetLengthメソッド）
- E-19: `Source/CorLib/System/CorArray.cls` 889-894行目（Rankメソッド）
- E-20: `Source/CorLib/System/CorArray.cls` 906-936行目（IndexOfメソッド）
- E-21: `Source/CorLib/System/CorArray.cls` 954-959行目（IsNullメソッド）
- E-22: `Source/CorLib/System/CorArray.cls` 977-990行目（IsNullOrEmptyメソッド）
- E-23: `Source/CorLib/System/CorArray.cls` 1002-1038行目（LastIndexOfメソッド）
- E-24: `Source/CorLib/System/CorArray.cls` 1046-1101行目（Reverseメソッド）
- E-25: `Source/CorLib/System/CorArray.cls` 1114-1119行目（Sortメソッド）
- E-26: `Source/CorLib/System/CorArray.cls` 1213-1294行目（SortKeyExメソッド）
- E-27: `Source/CorLib/System/CorArray.cls` 1300-1338行目（InternalBinarySearchメソッド）
- E-28: `Source/CorLib/System/CorArray.cls` 1379-1410行目（AssignDefaultElementValueメソッド）
- E-29: `Source/CorLib/System/CorArray.cls` 1412-1422行目（CopyValueTypesメソッド）
- E-30: `Source/CorLib/System/CorArray.cls` 1426-1475行目（CopyReferenceTypesメソッド）
- E-31: `Source/CorLib/System/CorArray.cls` 1556-1634行目（GetAssigningFunctionメソッド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 配列の作成、操作、検索、ソート機能を提供 | E-01 | ○ |
| C-02 | GuidSafeArray1d、ArrayInfo構造体を使用 | E-02 | ○ |
| C-03 | Existsメソッドは FindIndex を使用 | E-03 | ○ |
| C-04 | Findメソッドは FindIndex と VariantCopyInd を使用 | E-04 | ○ |
| C-05 | FindIndexはコールバック関数で要素検索 | E-05 | ○ |
| C-06 | FindAllは条件に合う全要素を返す | E-06 | ○ |
| C-07 | FindLastは後方から検索 | E-07, E-08 | ○ |
| C-08 | TrueForAllは全要素をチェック | E-09 | ○ |
| C-09 | ForEachは全要素に対してアクションを実行 | E-10 | ○ |
| C-10 | BinarySearchは二分探索を実行 | E-11, E-27 | ○ |
| C-11 | Clearは配列要素をクリア | E-13 | ○ |
| C-12 | CopyとCopyExは型変換を含むコピーを実行 | E-14, E-15 | ○ |
| C-13 | CreateInstanceは指定型の配列を生成 | E-16 | ○ |
| C-14 | Length/GetLengthは要素数を返す | E-17, E-18 | ○ |
| C-15 | Rankは次元数を返す | E-19 | ○ |
| C-16 | IndexOf/LastIndexOfは線形検索 | E-20, E-23 | ○ |
| C-17 | IsNull/IsNullOrEmptyは配列状態チェック | E-21, E-22 | ○ |
| C-18 | Reverseは配列を反転 | E-24 | ○ |
| C-19 | Sortはクイックソートを使用 | E-25, E-26 | ○ |
| C-20 | 検索失敗時はLBound-1を返す | E-05 (183行目) | ○ |
| C-21 | 値型はCopyMemoryで高速コピー | E-29 | ○ |
| C-22 | 参照型は SafeArrayCopyData を使用 | E-30 | ○ |
| C-23 | 型変換関数は GetAssigningFunction で取得 | E-31 | ○ |
| C-24 | デフォルト値割り当ては型別に処理 | E-28 | ○ |
| C-25 | 要素サイズに応じてスワップ関数を選択 | E-24 (1069-1079行目) | ○ |
| C-26 | IComparerインターフェースをサポート | E-26 (1258行目) | ○ |
| C-27 | パフォーマンス: クイックソートはO(n log n) | **根拠なし** | △ |
| C-28 | CallbackSorterの詳細実装 | **別ファイル未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値（実測データがないため推定）
  - 候補：ベンチマークテスト結果 / 実行時間計測
- CallbackSorterの詳細実装
  - 候補：`Source/CorLib/System/CallbackSorter.cls` の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なメソッド仕様は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス特性は理論値であり実測データなし
- 0: 低リスク - エラーハンドリングは各メソッドで適切に実装されていることを確認

## 6) レビュアーチェックリスト（最小）
- [ ] ソートアルゴリズムがクイックソートであることの確認（modSorting.basの確認）
- [ ] CallbackSorter.clsの実装確認
- [ ] コールバック関数の安全性に関する注意事項が十分か確認
- [ ] 多次元配列の処理に関する記述が正確か確認
