---
generated_at: 2026-01-20 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Console.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System/Console.cls` 38-66行目（モジュールコメント）
- E-02: `Source/CorLib/System/Console.cls` 68-96行目（Windows API宣言）
- E-03: `Source/CorLib/System/Console.cls` 99-106行目（定数定義）
- E-04: `Source/CorLib/System/Console.cls` 109-152行目（内部構造体定義）
- E-05: `Source/CorLib/System/Console.cls` 163-169行目（ConsoleBreakType列挙型）
- E-06: `Source/CorLib/System/Console.cls` 193-211行目（ConsoleColor列挙型）
- E-07: `Source/CorLib/System/Console.cls` 213-223行目（内部変数）
- E-08: `Source/CorLib/System/Console.cls` 231-258行目（Break/BreakTypeプロパティ）
- E-09: `Source/CorLib/System/Console.cls` 266-276行目（Errorプロパティ）
- E-10: `Source/CorLib/System/Console.cls` 285-296行目（Outプロパティ）
- E-11: `Source/CorLib/System/Console.cls` 305-311行目（In_プロパティ）
- E-12: `Source/CorLib/System/Console.cls` 322-324行目（Readメソッド）
- E-13: `Source/CorLib/System/Console.cls` 335-337行目（ReadLineメソッド）
- E-14: `Source/CorLib/System/Console.cls` 353-385行目（ReadKeyメソッド）
- E-15: `Source/CorLib/System/Console.cls` 392-398行目（SetOutメソッド）
- E-16: `Source/CorLib/System/Console.cls` 405-410行目（SetInメソッド）
- E-17: `Source/CorLib/System/Console.cls` 417-423行目（SetErrorメソッド）
- E-18: `Source/CorLib/System/Console.cls` 431-433行目（OpenStandardOutput）
- E-19: `Source/CorLib/System/Console.cls` 441-443行目（OpenStandardInput）
- E-20: `Source/CorLib/System/Console.cls` 451-453行目（OpenStandardError）
- E-21: `Source/CorLib/System/Console.cls` 465-469行目（WriteLineメソッド）
- E-22: `Source/CorLib/System/Console.cls` 479-483行目（WriteValueメソッド）
- E-23: `Source/CorLib/System/Console.cls` 491-502行目（Beepメソッド）
- E-24: `Source/CorLib/System/Console.cls` 516-575行目（SetWindowSizeメソッド）
- E-25: `Source/CorLib/System/Console.cls` 636-665行目（BufferWidth/BufferHeightプロパティ）
- E-26: `Source/CorLib/System/Console.cls` 775-813行目（Titleプロパティ）
- E-27: `Source/CorLib/System/Console.cls` 823-866行目（BackgroundColor/ForegroundColorプロパティ）
- E-28: `Source/CorLib/System/Console.cls` 875-926行目（Cursor位置/サイズ/表示プロパティ）
- E-29: `Source/CorLib/System/Console.cls` 935-984行目（CursorSize/CursorVisibleプロパティ）
- E-30: `Source/CorLib/System/Console.cls` 989-1002行目（Clearメソッド）
- E-31: `Source/CorLib/System/Console.cls` 1017-1066行目（MoveBufferAreaメソッド）
- E-32: `Source/CorLib/System/Console.cls` 1114-1117行目（ResetColorメソッド）
- E-33: `Source/CorLib/System/Console.cls` 1124-1175行目（Input/OutputEncodingプロパティ）
- E-34: `Source/CorLib/System/Console.cls` 1185-1232行目（CapsLock/NumLock/KeyAvailableプロパティ）
- E-35: `Source/CorLib/System/Console.cls` 1313-1328行目（Initメソッド）
- E-36: `Source/CorLib/System/Console.cls` 1330-1349行目（DisableCloseButtonメソッド）
- E-37: `Source/CorLib/System/Console.cls` 1438-1448行目（コンストラクタ/デストラクタ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンソール入出力機能を提供 | E-01 | ○ |
| C-02 | VB6アプリはデフォルトで新しいコンソールを作成 | E-01 (42-45行目) | ○ |
| C-03 | link /edit /subsystem:consoleでEXE変換 | E-01 (47-52行目) | ○ |
| C-04 | AllocConsole/FreeConsole API使用 | E-02 (68-69行目) | ○ |
| C-05 | GetStdHandle API使用 | E-02 (75行目) | ○ |
| C-06 | STD_OUTPUT_HANDLE=-11, STD_INPUT_HANDLE=-10, STD_ERROR_HANDLE=-12 | E-03 (99-101行目) | ○ |
| C-07 | ConsoleBreakType列挙型（ControlC=0, ControlBreak=1, CloseWindow=2, LogOffUser=5, ShutDownSystem=6） | E-05 | ○ |
| C-08 | ConsoleColor列挙型（CurrentColor=-1, Black=0 〜 White=15） | E-06 | ○ |
| C-09 | mOwnsConsole/mOutput/mInput/mError等の内部変数 | E-07 | ○ |
| C-10 | BreakはConsoleCallbacks.Breakを参照 | E-08 (232, 246行目) | ○ |
| C-11 | ErrorプロパティはStreamWriter経由でOpenStandardError使用 | E-09 | ○ |
| C-12 | OutプロパティはStreamWriter経由でOpenStandardOutput使用 | E-10 | ○ |
| C-13 | In_プロパティはStreamReader経由でOpenStandardInput使用 | E-11 | ○ |
| C-14 | ReadはIn_.Readを呼び出し | E-12 | ○ |
| C-15 | ReadLineはIn_.ReadLineを呼び出し | E-13 | ○ |
| C-16 | ReadKeyはReadConsoleInputを使用 | E-14 (360行目) | ○ |
| C-17 | Alt/Shift/Control/Caps-Lock等は単独で返されない | E-14 (372-376行目) | ○ |
| C-18 | SetOutでNothing渡すとArgumentNull | E-15 (393-394行目) | ○ |
| C-19 | SetInでNothing渡すとArgumentNull | E-16 (406-407行目) | ○ |
| C-20 | SetErrorでNothing渡すとArgumentNull | E-17 (418-419行目) | ○ |
| C-21 | OpenStandardOutputはWriteAccessでConsoleStream生成 | E-18 | ○ |
| C-22 | OpenStandardInputはReadAccessでConsoleStream生成 | E-19 | ○ |
| C-23 | OpenStandardErrorはWriteAccessでConsoleStream生成 | E-20 | ○ |
| C-24 | WriteLineはParamArrayで可変引数を受け取る | E-21 | ○ |
| C-25 | Beepは周波数37-32767Hz、Duration>=1 | E-23 (492-499行目) | ○ |
| C-26 | SetWindowSizeでバッファ拡張とウィンドウサイズ変更 | E-24 | ○ |
| C-27 | タイトル最大長24500文字 | E-26 (102, 790, 804行目) | ○ |
| C-28 | BackgroundColorは属性の上位4ビット | E-27 (824行目) | ○ |
| C-29 | ForegroundColorは属性の下位4ビット | E-27 (850行目) | ○ |
| C-30 | CursorSize範囲は1-100 | E-29 (947行目) | ○ |
| C-31 | ClearはFillConsoleOutputCharacter/Attribute使用 | E-30 | ○ |
| C-32 | ResetColorでGrayに設定 | E-32 (1115行目) | ○ |
| C-33 | OutputEncodingはGetConsoleOutputCP使用 | E-33 (1125行目) | ○ |
| C-34 | InitでAllocConsole→Sleep(10)→ハンドル取得 | E-35 | ○ |
| C-35 | Class_TerminateでFreeConsole（mOwnsConsole時のみ） | E-37 (1445-1447行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Consoleクラスの主要実装は完全に確認済み
- 1: 注意 - IDEでの閉じるボタン操作はクラッシュを引き起こす可能性（56-57行目のコメント参照）
- 0: 低リスク - Windows API呼び出しは標準的なパターン

## 6) レビュアーチェックリスト（最小）
- [ ] ConsoleCallbacks.basの実装確認（BreakType/Break変数）
- [ ] ConsoleStream.clsの実装確認
- [ ] ConsoleKeyInfo.clsの実装確認
- [ ] 入出力エンコーディングのNT系制限確認
- [ ] デバッガ内での閉じるボタン無効化動作確認
