---
generated_at: 2026-01-20 17:58:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：100-ArgumentNullException

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/ArgumentNullException.cls`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArgumentNullExceptionはNull参照の例外 | E-01: 38-48行目コメント | ○ |
| C-02 | Implements IObject, Exception, SystemException, ArgumentException | E-01: 57-60行目 | ○ |
| C-03 | HResultはE_POINTER（&H5B） | E-01: 119-121行目 | ○ |
| C-04 | ErrorNumberはvbObjectNotSet | E-01: 128-130行目 | ○ |
| C-05 | ParamNameでmBase.GetValueを使用 | E-01: 85-87行目 | ○ |
| C-06 | PropParamName定数 = "ParamName" | E-01: 63行目 | ○ |
| C-07 | MessageにParamNameを追加 | E-01: 169-173行目 | ○ |
| C-08 | GetExceptionMessageでArgumentNull_Genericを使用 | E-01: 167行目 | ○ |
| C-09 | Class_InitPropertiesでExceptionBase生成 | E-01: 243-245行目 | ○ |
| C-10 | InitでParamName、Message、InnerException設定 | E-01: 247-251行目 | ○ |
| C-11 | ArgumentException_*でインターフェース実装 | E-01: 268-323行目 | ○ |
| C-12 | Exception_*でインターフェース実装 | E-01: 344-394行目 | ○ |
| C-13 | SystemException_*でインターフェース実装 | E-01: 400-450行目 | ○ |
| C-14 | Initの引数順序はParamName、Message、InnerException | E-01: 247行目 | ○ |
| C-15 | 機能一覧でNull引数例外として定義 | E-02: 101行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての機能説明がコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] HResult（E_POINTER）がArgumentException（COR_E_ARGUMENT）と異なることを確認
- [ ] ErrorNumber（vbObjectNotSet）が適切か確認
- [ ] ArgumentExceptionインターフェースの完全実装を確認
- [ ] Initの引数順序（ParamName先）がArgumentExceptionと異なることを確認
