---
generated_at: 2026-01-20 16:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：101-ArgumentOutOfRangeException.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **COR_E_ARGUMENTOUTOFRANGE定数値**：定数定義ファイルの確認が必要
  2. **.NET Framework互換性**：設計意図の推測に基づく
  3. **セキュリティ考慮事項**：一般的なベストプラクティスに基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/ArgumentOutOfRangeException.cls` - 主要例外クラス実装
- E-02: `Source/CorLib/System/Constructors.cls` (176-178行目) - コンストラクタ関数
- E-03: `Source/CorLib/System/ExceptionBase.cls` - 例外ベースクラス
- E-04: `Source/Tests/System/ArgumentOutOfRangeExceptionTests.cls` - ユニットテスト
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数の値が許容範囲外の場合にスローされる | E-01 (38-46行目コメント), E-04 | ○ |
| C-02 | IObject、Exception、SystemException、ArgumentExceptionを実装 | E-01 (55-58行目Implements) | ○ |
| C-03 | InvocationMethod列挙型（3種類） | E-01 (60-64行目) | ○ |
| C-04 | デフォルトメッセージは "Specified argument was..." | E-04 (30行目テスト結果) | ○ |
| C-05 | ParamNameがメッセージに追記される | E-01 (183-185行目), E-04 (69行目) | ○ |
| C-06 | ActualValueがメッセージに追記される | E-01 (187-193行目), E-04 (79行目) | ○ |
| C-07 | GenericInvocation→vbInvalidProcedureCall(5) | E-01 (278-279行目) | ○ |
| C-08 | ArrayInvocation→vbSubscriptOutOfRange(9) | E-01 (280-281行目) | ○ |
| C-09 | PropertyInvocation→vbInvalidPropertyValue(380) | E-01 (282-283行目) | ○ |
| C-10 | 範囲外Methodで自身をスロー | E-01 (284-285行目) | ○ |
| C-11 | ExceptionBaseに機能を委譲 | E-01 (70行目), E-03 | ○ |
| C-12 | シリアライズ可能（Persistable） | E-01 (4行目), E-04 (115-129行目) | ○ |
| C-13 | コンストラクタ関数はCor.NewArgumentOutOfRangeException | E-02 (176-178行目) | ○ |
| C-14 | HResultはCOR_E_ARGUMENTOUTOFRANGE | E-01 (134行目) | ○ |
| C-15 | GetBaseExceptionで例外チェーン追跡可能 | E-01 (221-223行目), E-04 (102-113行目) | ○ |
| C-16 | Dataプロパティでユーザー定義情報を保持 | E-01 (78-80行目), E-03 (83-89行目) | ○ |
| C-17 | COR_E_ARGUMENTOUTOFRANGE定数値の具体値 | **根拠なし** | △ |
| C-18 | .NET Frameworkとの互換性を意図 | E-01 (コメント), E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- COR_E_ARGUMENTOUTOFRANGE定数の実際の値（定数定義ファイル未確認）
  - 候補：`Source/CorLib/System/modConstants.bas` / `Source/CorLib/System/HResults.cls`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な主張が大半
- 1: 中リスク - 定数値の具体的な値は定数定義ファイルで要確認

## 6) レビュアーチェックリスト（最小）
- [ ] COR_E_ARGUMENTOUTOFRANGE定数の値を定数定義ファイルで確認
- [ ] vbInvalidProcedureCall、vbSubscriptOutOfRange、vbInvalidPropertyValueのVB標準エラー番号との一致確認
- [ ] テストケースの網羅性（境界値テスト等）の確認
