---
generated_at: 2026-01-20 16:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：105-NotSupportedException.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System/NotSupportedException.cls` - 主要例外クラス実装
- E-02: `Source/CorLib/System/Constructors.cls` (115-117行目) - コンストラクタ関数
- E-03: `Source/CorLib/System/ExceptionBase.cls` - 例外ベースクラス
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 呼び出されたメソッドがサポートされていない場合にスロー | E-01 (38-44行目コメント) | ○ |
| C-02 | IObject、Exception、SystemExceptionを実装 | E-01 (51-53行目Implements) | ○ |
| C-03 | HResultはCOR_E_NOTSUPPORTED | E-01 (102行目) | ○ |
| C-04 | ErrorNumberはvbInvalidProcedureCall (5) | E-01 (111行目) | ○ |
| C-05 | Messageプロパティでエラーメッセージ取得 | E-01 (148-150行目) | ○ |
| C-06 | Arg_NotSupportedExceptionからデフォルトメッセージ取得 | E-01 (149行目) | ○ |
| C-07 | ExceptionBaseに機能を委譲 | E-01 (57行目), E-03 | ○ |
| C-08 | シリアライズ可能（Persistable） | E-01 (4行目) | ○ |
| C-09 | コンストラクタ関数はCor.NewNotSupportedException | E-02 (115-117行目) | ○ |
| C-10 | GetBaseExceptionで例外チェーン追跡可能 | E-01 (177-179行目) | ○ |
| C-11 | Dataプロパティでユーザー定義情報を保持 | E-01 (67-69行目) | ○ |
| C-12 | Initメソッドで初期化 | E-01 (223-226行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な主張のみ

## 6) レビュアーチェックリスト（最小）
- [ ] COR_E_NOTSUPPORTED定数の値を定数定義ファイルで確認
- [ ] 使用箇所（FixedSizeArrayList等）での使われ方確認
