---
generated_at: 2026-01-20 16:48:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：106-IOException.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.IO/IOException.cls` - 主要例外クラス実装
- E-02: `Source/CorLib/System/Constructors.cls` (396-398行目) - コンストラクタ関数
- E-03: `Source/CorLib/System/ExceptionBase.cls` - 例外ベースクラス
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | I/Oエラーが発生した場合にスロー | E-01 (38-39行目コメント) | ○ |
| C-02 | IObject、Exception、SystemExceptionを実装 | E-01 (46-48行目Implements) | ○ |
| C-03 | HResultはmBase.HResultを返却 | E-01 (97行目) | ○ |
| C-04 | ErrorNumberはmBase.ErrorNumberを返却 | E-01 (106行目) | ○ |
| C-05 | デフォルトHResultはCOR_E_IO | E-01 (216行目) | ○ |
| C-06 | デフォルトErrorNumberはvbDeviceIOError | E-01 (217行目) | ○ |
| C-07 | Messageプロパティでエラーメッセージ取得 | E-01 (143-145行目) | ○ |
| C-08 | Arg_IOExceptionからデフォルトメッセージ取得 | E-01 (144行目) | ○ |
| C-09 | ExceptionBaseに機能を委譲 | E-01 (52行目), E-03 | ○ |
| C-10 | シリアライズ可能（Persistable） | E-01 (4行目) | ○ |
| C-11 | コンストラクタ関数はCor.NewIOException | E-02 (396-398行目) | ○ |
| C-12 | Initメソッドで初期化（4パラメータ） | E-01 (220-225行目) | ○ |
| C-13 | GetBaseExceptionで例外チェーン追跡可能 | E-01 (172-174行目) | ○ |
| C-14 | Dataプロパティでユーザー定義情報を保持 | E-01 (62-64行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な主張のみ

## 6) レビュアーチェックリスト（最小）
- [ ] COR_E_IO定数の値を定数定義ファイルで確認
- [ ] vbDeviceIOError (57)がVB6標準エラー番号と一致することを確認
- [ ] 派生例外クラス（FileNotFoundException等）との関係確認
