---
generated_at: 2026-01-20 16:52:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：107-FileNotFoundException.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.IO/FileNotFoundException.cls` - 主要例外クラス実装
- E-02: `Source/CorLib/System/Constructors.cls` (408-410行目) - コンストラクタ関数
- E-03: `Source/CorLib/System/ExceptionBase.cls` - 例外ベースクラス
- E-04: `Source/Tests/System.IO/FileNotFoundExceptionTests.cls` - ユニットテスト
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 指定されたファイルが見つからない場合にスロー | E-01 (38-39行目コメント) | ○ |
| C-02 | IObject、Exception、SystemException、IOExceptionを実装 | E-01 (46-49行目Implements) | ○ |
| C-03 | FileNameプロパティでファイル名取得 | E-01 (74-76行目) | ○ |
| C-04 | HResultはCOR_E_FILENOTFOUND | E-01 (109行目) | ○ |
| C-05 | ErrorNumberはvbFileNotFound (53) | E-01 (118行目) | ○ |
| C-06 | デフォルトメッセージは"Unable to find the specified file." | E-04 (30行目テスト) | ○ |
| C-07 | ファイル名から自動メッセージ生成 | E-01 (234行目), E-04 (59行目テスト) | ○ |
| C-08 | 自動生成メッセージ形式は"Could not find file '{FileName}'." | E-04 (59行目) | ○ |
| C-09 | ExceptionBaseに機能を委譲 | E-01 (54行目), E-03 | ○ |
| C-10 | シリアライズ可能（Persistable） | E-01 (4行目), E-04 (95-108行目) | ○ |
| C-11 | コンストラクタ関数はCor.NewFileNotFoundException | E-02 (408-410行目) | ○ |
| C-12 | Initメソッドで初期化（条件付きMessage生成） | E-01 (230-240行目) | ○ |
| C-13 | GetBaseExceptionで例外チェーン追跡可能 | E-01 (184-186行目), E-04 (82-93行目) | ○ |
| C-14 | Dataプロパティでユーザー定義情報を保持 | E-01 (64-66行目) | ○ |
| C-15 | IO_FileNotFound_Nameリソースを使用 | E-01 (234行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとテストコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] COR_E_FILENOTFOUND定数の値を定数定義ファイルで確認
- [ ] vbFileNotFound (53)がVB6標準エラー番号と一致することを確認
- [ ] シリアライズ後のFileName保持確認（テストで確認済み）
