---
generated_at: 2026-01-20 16:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-Random.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：実測データなし
  2. **暗号用途に関する警告**：推奨事項の妥当性確認
  3. **VBA Rnd関数の品質**：外部依存の品質保証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/Random.cls` - メインソースコード
- E-02: `Source/Tests/System/RandomTests.cls` - テストコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面連携情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextLongメソッドは0以上MaxValue未満の整数を返す | E-01 (54-59行目)、E-02 | ○ |
| C-02 | NextRangeメソッドはMinValue以上MaxValue未満の整数を返す | E-01 (69-74行目)、E-02 | ○ |
| C-03 | NextBytesメソッドは配列を0-255の乱数で充填する | E-01 (80-88行目)、E-02 | ○ |
| C-04 | NextDoubleメソッドは0.0以上1.0未満の値を返す | E-01 (96-98行目) | ○ |
| C-05 | MaxValueが負の場合ArgumentOutOfRangeExceptionをスロー | E-01 (55-56行目)、E-02 (46-53行目) | ○ |
| C-06 | MinValue > MaxValueの場合ArgumentOutOfRangeExceptionをスロー | E-01 (70-71行目)、E-02 (86-93行目) | ○ |
| C-07 | 配列未初期化の場合ArgumentNullExceptionをスロー | E-01 (81-82行目)、E-02 (129-137行目) | ○ |
| C-08 | 内部でVBA.Rnd関数を使用している | E-01 (97行目、143行目) | ○ |
| C-09 | シード値による乱数系列の初期化が可能 | E-01 (134-136行目)、E-02 (115-127行目) | ○ |
| C-10 | IObjectインターフェースを実装している | E-01 (44行目、150-160行目) | ○ |
| C-11 | 画面「Simply VB Unit Runner」と連携する | E-04 | ○ |
| C-12 | カテゴリは「System」である | E-03 | ○ |
| C-13 | NextNumber計算式はInt(Rnd * (Max - Min)) + Min | E-01 (143行目) | ○ |
| C-14 | クラスはPersistable属性を持つ | E-01 (4行目) | ○ |
| C-15 | Class_Initializeでランダム初期化を行う | E-01 (130-132行目) | ○ |
| C-16 | ToString、Equals、GetHashCodeメソッドを持つ | E-01 (104-124行目) | ○ |
| C-17 | NextBytesのループ範囲はLBound(Bytes)からUBound(Bytes) | E-01 (85行目) | ○ |
| C-18 | パフォーマンスは数マイクロ秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件に関する実測データ
  - 候補：ベンチマークテストの実施 / 類似ライブラリとの比較 / 開発者コメント

## 5) リスクフラグ（レビュー観点）
- 0: IObjectインターフェース実装（コード確認済み）
- 0: エラー処理の網羅性（テストコードで確認済み）
- 1: 暗号用途での使用警告（セキュリティ上重要）
- 1: パフォーマンス数値（実測なし、要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] NextLong/NextRangeの境界値テストが十分か確認
- [ ] シード再現性テストの妥当性確認
- [ ] 暗号用途への警告が適切な場所に記載されているか
- [ ] VBA.Rnd依存による制約事項の網羅性確認
