---
generated_at: 2026-01-20 16:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-BitConverter.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **Decimalレイアウト変換**：VBと.NET間の変換が正確か
  2. **エンディアン**：リトルエンディアン前提の妥当性
  3. **Int64型の扱い**：ユーザー定義型としての処理

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System/BitConverter.cls` - メインソースコード
- E-02: `Source/Tests/System/BitConverterTests.cls` - テストコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面連携情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetBytesはBoolean、Byte、Integer、Long、Int64、Single、Double、Currency、Date、Decimalをサポート | E-01 (166-237行目) | ○ |
| C-02 | ToBooleanは0より大きい値でTrueを返す | E-01 (266行目) | ○ |
| C-03 | ToDoubleは8バイトを変換する | E-01 (291-294行目) | ○ |
| C-04 | ToInt16は2バイトを変換する | E-01 (351-354行目) | ○ |
| C-05 | ToInt32は4バイトを変換する | E-01 (378-381行目) | ○ |
| C-06 | ToInt64は8バイトを変換する | E-01 (406-409行目) | ○ |
| C-07 | ToSingleは4バイトを変換する | E-01 (433-436行目) | ○ |
| C-08 | ToCurrencyは8バイトを変換する | E-01 (460-463行目) | ○ |
| C-09 | ToDateは8バイトを変換し、ミリ秒からOA日付に変換する | E-01 (322-327行目) | ○ |
| C-10 | ToDecimalは16バイトを変換し、.NETレイアウトからVBレイアウトに変換する | E-01 (521-537行目) | ○ |
| C-11 | 未初期化配列でArgumentNullExceptionをスロー | E-01 (606-608行目) | ○ |
| C-12 | StartIndexが範囲外でArgumentOutOfRangeExceptionをスロー | E-01 (609-614行目) | ○ |
| C-13 | サポート外の型でNotSupportedExceptionをスロー | E-01 (195-196行目、237-238行目) | ○ |
| C-14 | ToStringは16進数文字列をハイフン区切りで返す | E-01 (551-599行目) | ○ |
| C-15 | DoubleToInt64Bitsは64ビットをそのままコピーする | E-01 (52-54行目) | ○ |
| C-16 | Int64BitsToDoubleは64ビットをそのままコピーする | E-01 (63-65行目) | ○ |
| C-17 | SingleToInt32Bitsは32ビットをそのままコピーする | E-01 (74-76行目) | ○ |
| C-18 | Int32BitsToSingleは32ビットをそのままコピーする | E-01 (85-87行目) | ○ |
| C-19 | クラスはVB_Creatable = False（静的クラス） | E-01 (11行目) | ○ |
| C-20 | ValidateArrayArgumentsで配列バリデーションを実施 | E-01 (605-615行目) | ○ |
| C-21 | GetBytesはSafeArrayCreateVectorExで配列を作成 | E-01 (168行目等) | ○ |
| C-22 | Decimalの精度が28を超えるとArgumentOutOfRangeException | E-01 (526-527行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 型別処理の網羅性（ソースコード確認済み）
- 0: エラー処理（ValidateArrayArguments確認済み）
- 1: Decimalレイアウト変換（複雑なため要レビュー）
- 0: エンディアン（x86リトルエンディアン前提、ドキュメント記載済み）

## 6) レビュアーチェックリスト（最小）
- [ ] Decimalの.NET/VBレイアウト変換ロジックの正確性確認
- [ ] 境界値テスト（StartIndex = 0、配列末尾）の妥当性確認
- [ ] ToDate/ToDecimalの特殊ケース処理確認
- [ ] 16進数文字列変換の大文字/小文字確認
