---
generated_at: 2026-01-20 16:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：13-Convert.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：実測データなし
  2. **Base64のRFC準拠**：76文字改行の仕様確認
  3. **負数の2の補数表現**：各基数での動作確認

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System/Convert.cls` - メインソースコード
- E-02: `Source/Tests/System/ConvertTests.cls` - テストコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面連携情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToBase64Stringはバイト配列をBase64文字列に変換する | E-01 (ToBase64Stringメソッド)、E-02 | ○ |
| C-02 | FromBase64StringはBase64文字列をバイト配列に変換する | E-01 (FromBase64Stringメソッド)、E-02 | ○ |
| C-03 | Base64変換は3バイト→4文字の変換を行う | E-01 (エンコードロジック) | ○ |
| C-04 | Base64デコードは4文字→3バイトの変換を行う | E-01 (デコードロジック) | ○ |
| C-05 | InsertLineBreaksオプションで76文字毎に改行を挿入 | E-01 (Base64FormattingOptions処理) | ○ |
| C-06 | FromBase64Stringは空白文字を無視する | E-01 (空白除去処理) | ○ |
| C-07 | Base64文字列の長さが4の倍数でない場合FormatException | E-01 (バリデーション処理)、E-02 | ○ |
| C-08 | ToStringは2、8、10、16進数変換をサポート | E-01 (ToStringメソッド)、E-02 | ○ |
| C-09 | サポート外の基数でArgumentException | E-01 (基数バリデーション) | ○ |
| C-10 | 負数は2の補数表現で変換される | E-01 (負数処理ロジック) | ○ |
| C-11 | ToBoolean、ToByte等の型変換メソッドを提供 | E-01 (各型変換メソッド) | ○ |
| C-12 | 未初期化配列でArgumentNullException | E-01 (バリデーション) | ○ |
| C-13 | オフセット/長さが範囲外でArgumentOutOfRangeException | E-01 (バリデーション) | ○ |
| C-14 | 無効なBase64文字でFormatException | E-01 (文字バリデーション)、E-02 | ○ |
| C-15 | クラスは静的クラスとして設計 | E-01 (VB_Creatable属性) | ○ |
| C-16 | Base64Charsテーブルで64文字を管理 | E-01 (定数定義) | ○ |
| C-17 | Base64CharToBitsで逆引きを行う | E-01 (定数定義) | ○ |
| C-18 | ToBase64CharArrayは出力配列に書き込み、文字数を返す | E-01 (メソッド定義) | ○ |
| C-19 | ToDateTime変換をサポート | E-01 (ToDateTimeメソッド) | ○ |
| C-20 | パフォーマンスは1MBを数十ミリ秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の実測データ
  - 候補：ベンチマークテストの実施 / 大容量データでの性能測定

## 5) リスクフラグ（レビュー観点）
- 0: Base64エンコード/デコードの正確性（テストコード確認済み）
- 0: エラー処理の網羅性（バリデーション確認済み）
- 1: RFC 2045準拠の76文字改行（仕様確認推奨）
- 1: パフォーマンス数値（実測なし、要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] Base64エンコード/デコードの往復テスト確認
- [ ] 空白文字の除去仕様（許容される空白の種類）確認
- [ ] 負数の2の補数表現が各基数で正しいか確認
- [ ] ToDateTimeの範囲制限と例外処理確認
