---
generated_at: 2026-01-20 16:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-CorMath.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **Ceiling/Floor/Truncate**：丸め動作の境界ケース確認
  2. **BigMul**：オーバーフロー処理の確認
  3. **Clamp引数制約**：MinValue > MaxValueのエラー処理

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System/CorMath.cls` - メインソースコード
- E-02: `Source/Tests/System/CorMathTests.cls` - テストコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面連携情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MaxはLong、Int64、Double、Currency版をオーバーロード | E-01 (Max関数群) | ○ |
| C-02 | MinはLong、Int64、Double、Currency版をオーバーロード | E-01 (Min関数群) | ○ |
| C-03 | Ceilingは正の無限大方向へ丸める | E-01 (Ceilingメソッド)、E-02 | ○ |
| C-04 | Floorは負の無限大方向へ丸める | E-01 (Floorメソッド)、E-02 | ○ |
| C-05 | Truncateはゼロ方向へ丸める | E-01 (Truncateメソッド)、E-02 | ○ |
| C-06 | Signは-1、0、1を返す | E-01 (Signメソッド)、E-02 | ○ |
| C-07 | ClampはMinValue以上MaxValue以下の値を返す | E-01 (Clampメソッド)、E-02 | ○ |
| C-08 | ClampでMinValue > MaxValueの場合ArgumentException | E-01 (バリデーション) | ○ |
| C-09 | BigMulは32ビット×32ビットを64ビットで計算 | E-01 (BigMulメソッド) | ○ |
| C-10 | DivRemは商と剰余を同時に計算 | E-01 (DivRemメソッド) | ○ |
| C-11 | DivRemの剰余はByRef引数で返却 | E-01 (メソッドシグネチャ) | ○ |
| C-12 | ShiftLeftはビット左シフトを行う | E-01 (ShiftLeftメソッド) | ○ |
| C-13 | ShiftRightはビット右シフトを行う | E-01 (ShiftRightメソッド) | ○ |
| C-14 | クラスは静的クラスとして設計 | E-01 (VB_Creatable属性) | ○ |
| C-15 | すべてのメソッドが純粋関数 | E-01 (状態を持たない実装) | ○ |
| C-16 | 画面「Simply VB Unit Runner」と連携 | E-04 | ○ |
| C-17 | カテゴリは「System」である | E-03 | ○ |
| C-18 | 名称は"Cor"(Core)+"Math"に由来 | E-01 (クラス名) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: Max/Minオーバーロード（コード確認済み）
- 0: 丸め関数の動作（テストコード確認済み）
- 1: BigMulのオーバーフロー境界ケース（詳細確認推奨）
- 0: Clamp引数バリデーション（コード確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] Ceiling/Floor/Truncateの負数処理が正しいか確認
- [ ] BigMulのオーバーフロー時の動作確認
- [ ] DivRemのゼロ除算時のエラー動作確認
- [ ] Clampの境界値テスト（MinValue = MaxValueのケース）確認
