---
generated_at: 2026-01-20 16:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-Char.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **Unicode準拠**：文字分類がUnicode標準に準拠しているか
  2. **空白文字定義**：IsWhiteSpaceの空白文字リストの網羅性
  3. **サロゲートペア**：高位コードポイントの扱い

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System/Char.cls` - メインソースコード
- E-02: `Source/Tests/System/CharTests.cls` - テストコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面連携情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IsDigitは0-9を数字として判定 | E-01 (IsDigitメソッド)、E-02 | ○ |
| C-02 | IsLetterは英字を判定 | E-01 (IsLetterメソッド)、E-02 | ○ |
| C-03 | IsWhiteSpaceは空白文字を判定 | E-01 (IsWhiteSpaceメソッド)、E-02 | ○ |
| C-04 | IsControlは制御文字を判定 | E-01 (IsControlメソッド)、E-02 | ○ |
| C-05 | IsUpperは大文字を判定 | E-01 (IsUpperメソッド)、E-02 | ○ |
| C-06 | IsLowerは小文字を判定 | E-01 (IsLowerメソッド)、E-02 | ○ |
| C-07 | ToUpperは大文字に変換 | E-01 (ToUpperメソッド)、E-02 | ○ |
| C-08 | ToLowerは小文字に変換 | E-01 (ToLowerメソッド)、E-02 | ○ |
| C-09 | 変換不可能な文字はそのまま返却 | E-01 (変換ロジック) | ○ |
| C-10 | Null文字列でArgumentNullException | E-01 (バリデーション) | ○ |
| C-11 | 範囲外インデックスでArgumentOutOfRangeException | E-01 (バリデーション) | ○ |
| C-12 | GetUnicodeCategoryはカテゴリを返す | E-01 (メソッド定義) | ○ |
| C-13 | GetNumericValueは数値を返す | E-01 (メソッド定義) | ○ |
| C-14 | 数字以外は-1を返す（GetNumericValue） | E-01 (実装ロジック) | ○ |
| C-15 | クラスは静的クラスとして設計 | E-01 (VB_Creatable属性) | ○ |
| C-16 | 画面「Simply VB Unit Runner」と連携 | E-04 | ○ |
| C-17 | カテゴリは「System」である | E-03 | ○ |
| C-18 | IsLetterOrDigitはIsLetterとIsDigitの組み合わせ | E-01 (実装ロジック) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: ASCII範囲の文字分類（テストコード確認済み）
- 1: Unicode拡張範囲の文字分類（詳細確認推奨）
- 0: 大文字小文字変換（テストコード確認済み）
- 1: サロゲートペアの扱い（BMP外文字の動作確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] IsWhiteSpaceの空白文字リストがUnicode標準に準拠しているか
- [ ] 日本語文字の分類（ひらがな、カタカナ、漢字）が正しいか
- [ ] ToUpper/ToLowerのロケール依存性確認
- [ ] サロゲートペア（絵文字等）の動作確認
