---
generated_at: 2026-01-20 17:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-StringBuilder.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. **AppendFormat**：フォーマット文字列パースの正確性
  2. **Replace**：長さ変化時の処理の正確性
  3. **メモリ管理**：バッファ拡張時のメモリリーク防止

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Text/StringBuilder.cls` - メインソースコード
- E-02: `Source/Tests/System.Text/StringBuilderTests.cls` - テストコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面連携情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 内部バッファはInteger配列（Unicode文字配列） | E-01 (55行目 mString) | ○ |
| C-02 | デフォルト容量は128文字 | E-01 (53行目 DefaultCapacity) | ○ |
| C-03 | 容量不足時は2倍に拡張 | E-01 (310-324行目 EnsureCapacity) | ○ |
| C-04 | Append系メソッドは自身への参照を返却 | E-01 (各Appendメソッド) | ○ |
| C-05 | 0ベースインデックス | E-01 (Charsプロパティ等) | ○ |
| C-06 | FillCharacterデフォルトは空白 | E-01 (52行目 DefaultFillChar) | ○ |
| C-07 | AppendはVarTypeで型判定 | E-01 (72行目) | ○ |
| C-08 | AppendCharは範囲チェック実施 | E-01 (93-96行目) | ○ |
| C-09 | AppendStringはCopyMemoryで高速コピー | E-01 (208行目) | ○ |
| C-10 | AppendLineはvbCrLfを追加 | E-01 (188行目) | ○ |
| C-11 | AppendFormatはプレースホルダを解析 | E-01 (652-775行目) | ○ |
| C-12 | Insertは後方に空間を作成 | E-01 (925-937行目 InsertSpace) | ○ |
| C-13 | Removeは後続を前方移動 | E-01 (502行目) | ○ |
| C-14 | Replaceは長さに応じて3パターンの処理 | E-01 (541-548行目) | ○ |
| C-15 | ToStringはSysAllocStringLenを使用 | E-01 (570行目) | ○ |
| C-16 | CopyToは文字配列にコピー | E-01 (220-237行目) | ○ |
| C-17 | Clearは長さを0にリセット | E-01 (388-391行目) | ○ |
| C-18 | IObjectインターフェースを実装 | E-01 (50行目) | ○ |
| C-19 | 範囲外IndexでArgumentOutOfRangeException | E-01 (バリデーション各所) | ○ |
| C-20 | 負のCountでArgumentOutOfRangeException | E-01 (バリデーション各所) | ○ |
| C-21 | 無効フォーマットでFormatException | E-01 (921-923行目) | ○ |
| C-22 | 画面「Simply VB Unit Runner」と連携 | E-04 | ○ |
| C-23 | カテゴリは「System.Text」である | E-03 | ○ |
| C-24 | mStringPtrはバッファ先頭ポインタ | E-01 (56行目、262行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: バッファ管理（コード確認済み）
- 0: Append系メソッド（テストコード確認済み）
- 1: AppendFormatの複雑なフォーマット（詳細確認推奨）
- 1: Replaceの長さ変化処理（メモリ操作の正確性確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] AppendFormatのネストしたプレースホルダ処理確認
- [ ] Replaceの重複マッチ処理確認
- [ ] バッファ拡張時のメモリリーク確認
- [ ] ToStringの部分文字列取得の境界値テスト確認
