---
generated_at: 2026-01-20 17:05:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-ArrayList.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  1. **バージョン管理**：列挙中の変更検出が正しく動作するか
  2. **シリアライズ**：PropertyBagによる永続化の動作確認
  3. **範囲ビュー**：GetRangeのRangedArrayListが元リストと同期するか

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Collections/ArrayList.cls` - メインソースコード
- E-02: `Source/Tests/System.Collections/ArrayListTests.cls` - テストコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面連携情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 内部はVariant配列 | E-01 (70行目 mItems) | ○ |
| C-02 | デフォルト容量は16要素 | E-01 (68行目 DefaultCapacity) | ○ |
| C-03 | 容量不足時は2倍に拡張 | E-01 (734-748行目 EnsureCapacity) | ○ |
| C-04 | IList、ICollection、IEnumerable、ICloneable、IVersionableを実装 | E-01 (52-57行目) | ○ |
| C-05 | AddはCountにInsertして位置を返却 | E-01 (88-91行目) | ○ |
| C-06 | InsertはInsertSpaceで空間確保 | E-01 (424-433行目) | ○ |
| C-07 | RemoveはIndexOf検索後RemoveAt | E-01 (564-571行目) | ○ |
| C-08 | RemoveAtは要素クリアと空間詰め | E-01 (579-587行目) | ○ |
| C-09 | IndexOfはCorArray.IndexOfに委譲 | E-01 (414行目) | ○ |
| C-10 | BinarySearchはCorArray.BinarySearchExに委譲 | E-01 (187行目) | ○ |
| C-11 | SortはCorArray.SortExに委譲 | E-01 (672行目) | ○ |
| C-12 | ReverseはCorArray.Reverseに委譲 | E-01 (631行目) | ○ |
| C-13 | AddRangeはInsertRange(mCount, Source)に委譲 | E-01 (110行目) | ○ |
| C-14 | GetRangeはRangedArrayListを返却 | E-01 (386-388行目) | ○ |
| C-15 | CloneはInitCloneで浅いコピー | E-01 (270-273行目) | ○ |
| C-16 | ToArrayはCorArray.CreateInstance + CopyEx | E-01 (686-692行目) | ○ |
| C-17 | Clearは配列を再初期化 | E-01 (256-260行目) | ○ |
| C-18 | TrimToSizeはCountに容量を縮小 | E-01 (699-701行目) | ○ |
| C-19 | mVersionで変更追跡 | E-01 (73行目, 変更時のインクリメント) | ○ |
| C-20 | 範囲外IndexでArgumentOutOfRangeException | E-01 (バリデーション各所) | ○ |
| C-21 | Persistable属性を持つ | E-01 (4行目) | ○ |
| C-22 | Class_ReadProperties/Class_WritePropertiesでシリアライズ | E-01 (822-887行目) | ○ |
| C-23 | NewEnumでFor Each対応 | E-01 (551-555行目) | ○ |
| C-24 | GetEnumeratorでArrayListEnumeratorを返却 | E-01 (347-358行目) | ○ |
| C-25 | 画面「Simply VB Unit Runner」と連携 | E-04 | ○ |
| C-26 | カテゴリは「System.Collections」である | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 基本操作（Add/Remove）（テストコード確認済み）
- 0: 検索・ソート（CorArrayへの委譲確認済み）
- 1: GetRangeの同期動作（RangedArrayListの詳細確認推奨）
- 1: シリアライズのEmpty/Nothing処理（特殊ケース確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] 列挙中の変更でInvalidOperationExceptionが発生するか
- [ ] GetRangeで取得したリストへの変更が元リストに反映されるか
- [ ] シリアライズ/デシリアライズでEmpty/Nothing要素が正しく復元されるか
- [ ] ToArrayの型変換エラー処理確認
