---
generated_at: 2026-01-20 10:45:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：2-CorString.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **StringBuilderCacheの詳細実装**：別ファイルのため未確認
  2. **CompareHelperの詳細実装**：内部ヘルパー関数のため部分的確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/CorString.cls` 38-43行目（モジュールコメント）
- E-02: `Source/CorLib/System/CorString.cls` 57-66行目（StringComparison列挙型）
- E-03: `Source/CorLib/System/CorString.cls` 93-103行目（CompareOptions列挙型）
- E-04: `Source/CorLib/System/CorString.cls` 111-114行目（StringSplitOptions列挙型）
- E-05: `Source/CorLib/System/CorString.cls` 116-126行目（内部変数定義）
- E-06: `Source/CorLib/System/CorString.cls` 134-136行目（IsNullメソッド）
- E-07: `Source/CorLib/System/CorString.cls` 144-164行目（IsNullOrWhiteSpaceメソッド）
- E-08: `Source/CorLib/System/CorString.cls` 178-182行目（Formatメソッド）
- E-09: `Source/CorLib/System/CorString.cls` 197-201行目（FormatExメソッド）
- E-10: `Source/CorLib/System/CorString.cls` 215-217行目（FormatArrayメソッド）
- E-11: `Source/CorLib/System/CorString.cls` 232-234行目（FormatArrayExメソッド）
- E-12: `Source/CorLib/System/CorString.cls` 247-268行目（ToCharArrayメソッド）
- E-13: `Source/CorLib/System/CorString.cls` 280-288行目（PadLeftメソッド）
- E-14: `Source/CorLib/System/CorString.cls` 300-308行目（PadRightメソッド）
- E-15: `Source/CorLib/System/CorString.cls` 320-322行目（TrimStartメソッド）
- E-16: `Source/CorLib/System/CorString.cls` 334-336行目（TrimEndメソッド）
- E-17: `Source/CorLib/System/CorString.cls` 348-350行目（Trimメソッド）
- E-18: `Source/CorLib/System/CorString.cls` 364-390行目（Joinメソッド）
- E-19: `Source/CorLib/System/CorString.cls` 401-416行目（CopyToメソッド）
- E-20: `Source/CorLib/System/CorString.cls` 427-445行目（Removeメソッド）
- E-21: `Source/CorLib/System/CorString.cls` 458-477行目（IndexOfAnyメソッド）
- E-22: `Source/CorLib/System/CorString.cls` 490-507行目（LastIndexOfAnyメソッド）
- E-23: `Source/CorLib/System/CorString.cls` 518-542行目（Insertメソッド）
- E-24: `Source/CorLib/System/CorString.cls` 561-569行目（StartsWithメソッド）
- E-25: `Source/CorLib/System/CorString.cls` 610-620行目（EndsWithメソッド）
- E-26: `Source/CorLib/System/CorString.cls` 674-717行目（Splitメソッド）
- E-27: `Source/CorLib/System/CorString.cls` 719-749行目（FindSeparatorIndexes）
- E-28: `Source/CorLib/System/CorString.cls` 852-880行目（FindWhitespaceSeparatorIndexes）
- E-29: `Source/CorLib/System/CorString.cls` 959-972行目（Equalsメソッド）
- E-30: `Source/CorLib/System/CorString.cls` 1004-1013行目（Compareメソッド）
- E-31: `Source/CorLib/System/CorString.cls` 1080-1093行目（CompareExメソッド）
- E-32: `Source/CorLib/System/CorString.cls` 1118-1120行目（CompareCulturalメソッド）
- E-33: `Source/CorLib/System/CorString.cls` 1186-1188行目（CompareOrdinalメソッド）
- E-34: `Source/CorLib/System/CorString.cls` 1265-1272行目（CharAtメソッド）
- E-35: `Source/CorLib/System/CorString.cls` 1381-1389行目（FormatCoreメソッド）
- E-36: `Source/CorLib/System/CorString.cls` 1307-1323行目（InitCompareStructures）
- E-37: `Source/CorLib/System/CorString.cls` 1343-1366行目（LoadLowerUpperLookupTable）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 文字列の書式設定・操作機能を提供 | E-01 | ○ |
| C-02 | StringComparison列挙型（8種類） | E-02 | ○ |
| C-03 | CompareOptions列挙型（ビット演算対応） | E-03 | ○ |
| C-04 | StringSplitOptions列挙型 | E-04 | ○ |
| C-05 | SafeArray構造体を内部で使用 | E-05, E-36 | ○ |
| C-06 | IsNullはStrPtrでNull判定 | E-06 | ○ |
| C-07 | IsNullOrWhiteSpaceはホワイトスペース文字をチェック | E-07 | ○ |
| C-08 | Formatはプレースホルダー形式をサポート | E-08 | ○ |
| C-09 | FormatExはIFormatProviderをサポート | E-09 | ○ |
| C-10 | FormatArray/FormatArrayExは配列引数を受け取る | E-10, E-11 | ○ |
| C-11 | ToCharArrayは文字列をInteger配列に変換 | E-12 | ○ |
| C-12 | PadLeft/PadRightは指定幅までパディング | E-13, E-14 | ○ |
| C-13 | Trim系メソッドはTrimCoreを共有 | E-15, E-16, E-17 | ○ |
| C-14 | Joinは配列またはコレクションを結合 | E-18 | ○ |
| C-15 | CopyToは文字列を文字配列にコピー | E-19 | ○ |
| C-16 | Removeは部分文字列を削除 | E-20 | ○ |
| C-17 | IndexOfAny/LastIndexOfAnyは複数文字の検索 | E-21, E-22 | ○ |
| C-18 | Insertは指定位置に文字列を挿入 | E-23 | ○ |
| C-19 | StartsWith/EndsWithは開始/終了判定 | E-24, E-25 | ○ |
| C-20 | Splitはセパレータで分割 | E-26 | ○ |
| C-21 | セパレータ検出はFindSeparatorIndexesで実行 | E-27 | ○ |
| C-22 | 空白セパレータ時はFindWhitespaceSeparatorIndexes | E-28 | ○ |
| C-23 | EqualsはStringComparisonに基づいて等価判定 | E-29 | ○ |
| C-24 | CompareはBinaryCompare/TextCompareでStrComp使用 | E-30 | ○ |
| C-25 | CompareExは部分文字列比較 | E-31 | ○ |
| C-26 | CompareCulturalはカルチャ依存比較 | E-32 | ○ |
| C-27 | CompareOrdinalはCompareStringOrdinal API使用 | E-33 | ○ |
| C-28 | CharAtは指定位置の文字コードを返す | E-34 | ○ |
| C-29 | FormatCoreはStringBuilderCacheを使用 | E-35 | ○ |
| C-30 | 大文字小文字変換テーブルをリソースから読み込み | E-37 | ○ |
| C-31 | StringBuilderCacheの詳細実装 | **別ファイル未確認** | △ |
| C-32 | CompareHelperの詳細ロジック | **内部実装部分未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- StringBuilderCacheの詳細実装
  - 候補：`Source/CorLib/System.Text/StringBuilderCache.cls` の確認が必要
- CompareHelperの詳細実装
  - 候補：CorString.clsの後半部分またはmodCorString.basの確認が必要
- CompareCulturalHelperの詳細実装
  - 候補：Windows API呼び出しの詳細確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なメソッド仕様は全てソースコードで確認済み
- 0: 低リスク - 列挙型の定義は完全に確認済み
- 1: 中リスク - カルチャ依存比較はWindows APIに依存するため、環境による動作差異の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] StringBuilderCacheの実装確認（キャッシュサイズ、スレッドセーフ性）
- [ ] CompareHelper/CompareCulturalHelperの実装確認
- [ ] Windows API呼び出し（CompareStringW、CompareStringOrdinal）の確認
- [ ] 大文字小文字変換テーブル（リソースID 101）の内容確認
