---
generated_at: 2026-01-20 17:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-Queue.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **循環バッファ**：ラップアラウンド時の動作確認
  2. **NormalizeArray**：配列正規化の正確性
  3. **空キュー操作**：Dequeue/Peekの例外処理

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Collections/Queue.cls` - メインソースコード
- E-02: `Source/Tests/System.Collections/QueueTests.cls` - テストコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面連携情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 内部はVariant配列の循環バッファ | E-01 (56-61行目) | ○ |
| C-02 | デフォルト容量は16要素 | E-01 (49行目 DefaultCapacity) | ○ |
| C-03 | 容量不足時は2倍に拡張 | E-01 (325-339行目 EnsureCapacity) | ○ |
| C-04 | ICollection、IEnumerable、ICloneable、IVersionableを実装 | E-01 (43-47行目) | ○ |
| C-05 | Enqueueは末尾に追加しmTailを循環更新 | E-01 (167-173行目) | ○ |
| C-06 | Dequeueは先頭から取り出しmHeadを循環更新 | E-01 (150-158行目) | ○ |
| C-07 | Peekは先頭を参照（削除しない） | E-01 (224-229行目) | ○ |
| C-08 | 空キューへのDequeueでInvalidOperationException | E-01 (151-152行目) | ○ |
| C-09 | 空キューへのPeekでInvalidOperationException | E-01 (225-226行目) | ○ |
| C-10 | Containsは循環ループで検索 | E-01 (98-110行目) | ○ |
| C-11 | CopyToはmHead位置に応じて2パターンのコピー | E-01 (119-128行目) | ○ |
| C-12 | ToArrayはCopyToを利用 | E-01 (241-243行目) | ○ |
| C-13 | CloneはInitCloneで浅いコピー | E-01 (86-89行目) | ○ |
| C-14 | Clearは配列再初期化とmHead/mTail/mCountをリセット | E-01 (70-76行目) | ○ |
| C-15 | NormalizeArrayはmHead=0となるように再配置 | E-01 (302-323行目) | ○ |
| C-16 | TrimToSizeはNormalizeArrayを呼び出し容量縮小 | E-01 (266-275行目) | ○ |
| C-17 | mVersionで変更追跡 | E-01 (61行目, 変更時のインクリメント) | ○ |
| C-18 | Persistable属性を持つ | E-01 (4行目) | ○ |
| C-19 | Class_ReadProperties/Class_WritePropertiesでシリアライズ | E-01 (393-422行目) | ○ |
| C-20 | NewEnumでFor Each対応 | E-01 (211-215行目) | ○ |
| C-21 | 画面「Simply VB Unit Runner」と連携 | E-04 | ○ |
| C-22 | カテゴリは「System.Collections」である | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: Enqueue/Dequeue操作（テストコード確認済み）
- 0: 空キュー例外（バリデーション確認済み）
- 1: 循環バッファのラップアラウンド（境界ケース確認推奨）
- 1: NormalizeArrayのメモリ操作（CopyMemory/ZeroMemoryの正確性確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] 循環バッファがラップアラウンドした時のEnqueue/Dequeue動作確認
- [ ] CopyToの連続領域/分割領域ケースの両方がテストされているか
- [ ] TrimToSize後にmHead=0となっているか
- [ ] シリアライズ/デシリアライズで循環バッファの状態が正しく復元されるか
