---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート: Hashtable機能設計書

## 1. 概要

本レポートは、No.21 Hashtable機能設計書に記載された内容の根拠を示すものである。

## 2. 主張と根拠の対応表

### 2.1 機能概要セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 1 | Hashtableはキー/値ペアのコレクション | Hashtable.cls | 37-49 | クラスヘッダのドキュメントコメントで「Represents a collection of key/value pairs that are organized based on the hash code of the key」と記載 |
| 2 | IDictionaryインターフェースを実装 | Hashtable.cls | 52 | `Implements IDictionary` の宣言 |
| 3 | ICollectionインターフェースを実装 | Hashtable.cls | 53 | `Implements ICollection` の宣言 |
| 4 | IEnumerableインターフェースを実装 | Hashtable.cls | 54 | `Implements IEnumerable` の宣言 |
| 5 | ICloneableインターフェースを実装 | Hashtable.cls | 55 | `Implements ICloneable` の宣言 |

### 2.2 データ構造セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 6 | mLoadFactor変数の存在 | Hashtable.cls | 56 | `Private mLoadFactor As Single` |
| 7 | mLoadSize変数の存在 | Hashtable.cls | 57 | `Private mLoadSize As Long` |
| 8 | mCount変数の存在 | Hashtable.cls | 58 | `Private mCount As Long` |
| 9 | mBuckets配列の存在 | Hashtable.cls | 59 | `Private mBuckets() As HashBucket` |
| 10 | mCapacity変数の存在 | Hashtable.cls | 60 | `Private mCapacity As Long` |
| 11 | mVersion変数の存在 | Hashtable.cls | 61 | `Private mVersion As Long` |
| 12 | mKeyComparer変数の存在 | Hashtable.cls | 62 | `Private mKeyComparer As IEqualityComparer` |

### 2.3 提供機能セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 13 | Addメソッドの存在 | Hashtable.cls | 84-86 | `Public Sub Add(ByRef Key As Variant, ByRef Value As Variant)` |
| 14 | Clearメソッドの存在 | Hashtable.cls | 103-111 | `Public Sub Clear()` |
| 15 | Cloneメソッドの存在 | Hashtable.cls | 119-130 | `Public Function Clone() As Hashtable` |
| 16 | Containsメソッドの存在 | Hashtable.cls | 139-141 | `Public Function Contains(ByRef Key As Variant) As Boolean` |
| 17 | ContainsKeyメソッドの存在 | Hashtable.cls | 149-151 | `Public Function ContainsKey(ByRef Key As Variant) As Boolean` |
| 18 | ContainsValueメソッドの存在 | Hashtable.cls | 158-170 | `Public Function ContainsValue(ByRef Value As Variant) As Boolean` |
| 19 | CopyToメソッドの存在 | Hashtable.cls | 180-205 | `Public Sub CopyTo(ByRef Arr As Variant, ByVal ArrayIndex As Long)` |
| 20 | Itemプロパティの存在 | Hashtable.cls | 258-265 | `Public Property Get Item(ByRef Key As Variant) As Variant` |
| 21 | Keysプロパティの存在 | Hashtable.cls | 283-285 | `Public Property Get Keys() As ICollection` |
| 22 | Valuesプロパティの存在 | Hashtable.cls | 395-397 | `Public Property Get Values() As ICollection` |
| 23 | Removeメソッドの存在 | Hashtable.cls | 333-357 | `Public Sub Remove(ByRef Key As Variant)` |
| 24 | GetEnumeratorメソッドの存在 | Hashtable.cls | 212-215 | `Public Function GetEnumerator() As IDictionaryEnumerator` |

### 2.4 アルゴリズムセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 25 | オープンアドレス法（ダブルハッシング）採用 | Hashtable.cls | 513-517 | InitHashCode関数で一次・二次ハッシュを計算 |
| 26 | デフォルト負荷係数1.0 | Hashtable.cls | 67 | `Private Const DefaultLoadFactor As Single = 1!` |
| 27 | 実効負荷係数は0.72倍 | Hashtable.cls | 68 | `Private Const LoadFactorDepreciation As Single = 0.72!` |

### 2.5 内部処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 28 | GetKeyIndex関数の処理フロー | Hashtable.cls | 482-511 | 関数実装でハッシュコード計算、バケット探索、状態チェックを実行 |
| 29 | InsertItemサブルーチンの処理 | Hashtable.cls | 519-598 | サブルーチン実装でExpand、ハッシュ計算、重複チェック、格納を実行 |
| 30 | ReinsertItemsサブルーチンの処理 | Hashtable.cls | 464-480 | サブルーチン実装でバケット再構築を実行 |
| 31 | Expand関数の存在 | Hashtable.cls | 441-462 | `Private Sub Expand()` |

### 2.6 関連コンポーネントセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 32 | IEqualityComparerの使用 | Hashtable.cls | 62 | `Private mKeyComparer As IEqualityComparer` |
| 33 | EqualityComparerの使用 | Hashtable.cls | 421 | `Set mKeyComparer = New EqualityComparer` |
| 34 | HashtableEnumeratorの使用 | Hashtable.cls | 213-214 | `Set GetEnumerator = Cor.NewHashtableEnumerator(Me, SAPtr(mBuckets), EnumEntries)` |
| 35 | HashtableKeyCollectionの使用 | Hashtable.cls | 284 | `Set Keys = New HashtableKeyCollection` |
| 36 | HashtableValueCollectionの使用 | Hashtable.cls | 396 | `Set Values = New HashtableValueCollection` |
| 37 | DictionaryEntryの使用 | Hashtable.cls | 195 | `Set Entry = Cor.NewDictionaryEntry(mBuckets(i).Key, mBuckets(i).Value)` |

### 2.7 エラー処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 38 | 重複キー追加時のArgumentException | Hashtable.cls | 584-585 | `Error.Argument Argument_AddingDuplicate_Key, "Key", Key` |
| 39 | 配列Nullの場合のArgumentNullException | Hashtable.cls | 183 | `If SAPtr(Arr) = vbNullPtr Then Error.ArgumentNull "Arr", ArgumentNull_Array` |
| 40 | インデックス範囲外のArgumentOutOfRangeException | Hashtable.cls | 185-186 | `If ArrayIndex < LBound(Arr) Then Error.ArgumentOutOfRange "ArrayIndex"` |

### 2.8 パフォーマンスセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 41 | Add操作は平均O(1) | Hashtable.cls | 519-598 | ハッシュベースの直接アクセスによる挿入 |
| 42 | ContainsValueは線形探索O(n) | Hashtable.cls | 158-170 | 全バケットを順次探索するループ構造 |

### 2.9 コードリーディングガイドセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 43 | Class_Initialize の行番号 | Hashtable.cls | 407-409 | 実際のコード位置と一致 |
| 44 | Init の行番号 | Hashtable.cls | 415-439 | 実際のコード位置と一致 |
| 45 | InitHashCode の行番号 | Hashtable.cls | 513-517 | 実際のコード位置と一致 |

## 3. 根拠なしの主張

| No | 主張 | 理由 |
|----|------|------|
| 1 | HashBucket構造の詳細フィールド名 | HashBucket構造体の定義は別モジュールにあり、直接確認できなかった。推定値として記載 |
| 2 | 変更履歴の日付（2015年） | ソースファイルのコピーライト年から推定。具体的なコミット履歴は未確認 |

## 4. 信頼度算出

- 主張総数: 45
- 根拠あり: 43
- 根拠なし: 2
- 信頼度: 43 / 45 = 0.96 (96%)

## 5. 備考

- 本機能設計書はソースコードの静的解析に基づいて作成された
- 行番号はHashtable.cls (VBCorLib v3.0相当) を基準としている
- 一部の内部構造体については推定に基づく記載がある
