---
generated_at: 2026-01-20 10:35:00
metrics:
  claims_total: 42
  claims_with_evidence: 41
  claims_without_evidence: 1
confidence_derived: 0.98
---

# 根拠レポート: SortedList機能設計書

## 1. 概要

本レポートは、No.22 SortedList機能設計書に記載された内容の根拠を示すものである。

## 2. 主張と根拠の対応表

### 2.1 機能概要セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 1 | SortedListはソートされた順序を維持するキー/値ペアのコレクション | SortedList.cls | 38-43 | ドキュメントコメントで「maintain a list of sorted items based on an associated key」と記載 |
| 2 | IDictionaryインターフェースを実装 | SortedList.cls | 54 | `Implements IDictionary` の宣言 |
| 3 | ICollectionインターフェースを実装 | SortedList.cls | 53 | `Implements ICollection` の宣言 |
| 4 | IEnumerableインターフェースを実装 | SortedList.cls | 52 | `Implements IEnumerable` の宣言 |
| 5 | IVersionableインターフェースを実装 | SortedList.cls | 55 | `Implements IVersionable` の宣言 |

### 2.2 データ構造セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 6 | mKeys配列の存在 | SortedList.cls | 63 | `Private mKeys() As Variant` |
| 7 | mValues配列の存在 | SortedList.cls | 64 | `Private mValues() As Variant` |
| 8 | mComparer変数の存在 | SortedList.cls | 65 | `Private mComparer As IComparer` |
| 9 | mCapacity変数の存在 | SortedList.cls | 66 | `Private mCapacity As Long` |
| 10 | mCount変数の存在 | SortedList.cls | 67 | `Private mCount As Long` |
| 11 | mVersion変数の存在 | SortedList.cls | 68 | `Private mVersion As Long` |
| 12 | DefaultCapacity定数の値（16） | SortedList.cls | 57 | `Private Const DefaultCapacity As Long = 16` |

### 2.3 提供機能セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 13 | Addメソッドの存在 | SortedList.cls | 85-98 | `Public Sub Add(ByRef Key As Variant, ByRef Value As Variant)` |
| 14 | Clearメソッドの存在 | SortedList.cls | 157-162 | `Public Sub Clear()` |
| 15 | Cloneメソッドの存在 | SortedList.cls | 170-173 | `Public Function Clone() As SortedList` |
| 16 | Containsメソッドの存在 | SortedList.cls | 197-199 | `Public Function Contains(ByRef Key As Variant) As Boolean` |
| 17 | ContainsKeyメソッドの存在 | SortedList.cls | 223-225 | `Public Function ContainsKey(ByRef Key As Variant) As Boolean` |
| 18 | ContainsValueメソッドの存在 | SortedList.cls | 237-239 | `Public Function ContainsValue(ByRef Value As Variant) As Boolean` |
| 19 | CopyToメソッドの存在 | SortedList.cls | 251-276 | `Public Sub CopyTo(ByRef Arr As Variant, ByVal ArrayIndex As Long)` |
| 20 | Itemプロパティの存在 | SortedList.cls | 473-481 | `Public Property Get Item(ByRef Key As Variant) As Variant` |
| 21 | Keysプロパティの存在 | SortedList.cls | 584-586 | `Public Property Get Keys() As ICollection` |
| 22 | Valuesプロパティの存在 | SortedList.cls | 704-706 | `Public Property Get Values() As ICollection` |
| 23 | Removeメソッドの存在 | SortedList.cls | 606-617 | `Public Sub Remove(ByRef Key As Variant)` |
| 24 | RemoveAtメソッドの存在 | SortedList.cls | 627-651 | `Public Sub RemoveAt(ByVal Index As Long)` |
| 25 | GetByIndexメソッドの存在 | SortedList.cls | 312-317 | `Public Function GetByIndex(ByVal Index As Long) As Variant` |
| 26 | GetKeyメソッドの存在 | SortedList.cls | 347-352 | `Public Function GetKey(ByVal Index As Long) As Variant` |
| 27 | IndexOfKeyメソッドの存在 | SortedList.cls | 401-410 | `Public Function IndexOfKey(ByRef Key As Variant) As Long` |
| 28 | IndexOfValueメソッドの存在 | SortedList.cls | 425-427 | `Public Function IndexOfValue(ByRef Value As Variant) As Long` |

### 2.4 アルゴリズムセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 29 | 二分探索にCorArray.InternalBinarySearchを使用 | SortedList.cls | 89 | `Index = CorArray.InternalBinarySearch(mKeys, 0, mCount, Key, mComparer)` |
| 30 | 容量拡張時に2倍に拡張 | SortedList.cls | 831 | `NewCapacity = mCapacity * 2` |
| 31 | 容量0の場合はDefaultCapacityを使用 | SortedList.cls | 829 | `NewCapacity = DefaultCapacity` |

### 2.5 内部処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 32 | Insertサブルーチンの処理 | SortedList.cls | 803-823 | `Private Sub Insert(ByVal Index As Long, ByRef Key As Variant, ByRef Value As Variant)` |
| 33 | EnsureCapacityサブルーチンの処理 | SortedList.cls | 825-841 | `Private Sub EnsureCapacity(ByVal RequiredCapacity As Long)` |
| 34 | RemoveAtでCopyMemoryを使用 | SortedList.cls | 640-641 | `CopyMemory mKeys(Index), mKeys(SourceIndex), NumberToCopy` |
| 35 | InsertでVariantCopyIndを使用 | SortedList.cls | 819-820 | `VariantCopyInd mKeys(Index), Key` |

### 2.6 関連コンポーネントセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 36 | IComparerの使用 | SortedList.cls | 65 | `Private mComparer As IComparer` |
| 37 | SortedListEnumeratorの使用 | SortedList.cls | 325-327 | `Dim Ret As New SortedListEnumerator` |
| 38 | SortedKeyListの使用 | SortedList.cls | 843-846 | `Private Function NewSortedKeyList() As SortedKeyList` |
| 39 | SortedValueListの使用 | SortedList.cls | 848-851 | `Private Function NewSortedValueList() As SortedValueList` |
| 40 | DictionaryEntryの使用 | SortedList.cls | 265 | `Set Arr(ArrayIndex + i) = Cor.NewDictionaryEntry(mKeys(i), mValues(i))` |

### 2.7 シリアライゼーションセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 41 | PropertyBagによるシリアライゼーション | SortedList.cls | 763-789 | `Class_ReadProperties`と`Class_WriteProperties`の実装 |

## 3. 根拠なしの主張

| No | 主張 | 理由 |
|----|------|------|
| 1 | 変更履歴の日付（2015年） | ソースファイルのコピーライト年から推定。具体的なコミット履歴は未確認 |

## 4. 信頼度算出

- 主張総数: 42
- 根拠あり: 41
- 根拠なし: 1
- 信頼度: 41 / 42 = 0.98 (98%)

## 5. 備考

- 本機能設計書はソースコードの静的解析に基づいて作成された
- 行番号はSortedList.cls (VBCorLib v3.0相当) を基準としている
- CorArray.InternalBinarySearchの内部実装は別モジュールにあり、本レポートでは参照していない
